/****************************************************************************
*
*					SciTech OS Portability Manager Library
*
*  ========================================================================
*
*    The contents of this file are subject to the SciTech MGL Public
*    License Version 1.0 (the "License"); you may not use this file
*    except in compliance with the License. You may obtain a copy of
*    the License at http://www.scitechsoft.com/mgl-license.txt
*
*    Software distributed under the License is distributed on an
*    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*    implied. See the License for the specific language governing
*    rights and limitations under the License.
*
*    The Original Code is Copyright (C) 1991-1998 SciTech Software, Inc.
*
*    The Initial Developer of the Original Code is SciTech Software, Inc.
*    All Rights Reserved.
*
*  ========================================================================
*
* Language:		ANSI C
* Environment:	Any
*
* Description:	Test program for the CPU detection code.
*
****************************************************************************/

#include "ztimer.h"
#include "pmapi.h"
#include <stdio.h>
#include <stdlib.h>

/*----------------------------- Implementation ----------------------------*/

int main(void)
{
	int		cpu;
	ulong	speed;

	printf("Detecting processor information ...");
	fflush(stdout);
	cpu = CPU_getProcessorType();
	speed = CPU_getProcessorSpeed();
	printf("\n\n%ld Mhz ", speed);
	switch (cpu & CPU_mask) {
		case CPU_i386:
			printf("Intel i386 processor");
			break;
		case CPU_i486:
			printf("Intel i486 processor");
			break;
		case CPU_Pentium:
			printf("Intel Pentium processor");
			break;
		case CPU_PentiumPro:
			printf("Intel PentiumPro processor");
			break;
		case CPU_PentiumII:
			printf("Intel PentiumII processor");
			break;
		case CPU_PentiumIII:
			printf("Intel PentiumIII processor");
			break;
		case CPU_UnkIntel:
			printf("Unknown Intel processor");
			break;
		case CPU_Cyrix6x86:
			printf("Cyrix 6x86 processor");
			break;
		case CPU_Cyrix6x86MX:
			printf("Cyrix 6x86MX processor");
			break;
		case CPU_CyrixMediaGX:
			printf("Cyrix MediaGX processor");
			break;
		case CPU_CyrixMediaGXm:
			printf("Cyrix MediaGXm processor");
			break;
		case CPU_UnkCyrix:
			printf("Unknown Cyrix processor");
			break;
		case CPU_AMDAm486:
			printf("AMD Am486 processor");
			break;
		case CPU_AMDAm5x86:
			printf("AMD Am5x86 processor");
			break;
		case CPU_AMDK5:
			printf("AMD K5 processor");
			break;
		case CPU_AMDK6:
			printf("AMD K6 processor");
			break;
		case CPU_AMDK6_2:
			printf("AMD K6-2 processor");
			break;
		case CPU_AMDK6_III:
			printf("AMD K6-III processor");
			break;
		case CPU_AMDAthlon:
			printf("AMD Athlon processor");
			break;
		case CPU_UnkAMD:
			printf("Unknown AMD processor");
			break;
		case CPU_WinChipC6:
			printf("IDT WinChip C6 processor");
			break;
		case CPU_WinChip2:
			printf("IDT WinChip 2 processor");
			break;
		case CPU_UnkIDT:
			printf("Unknown IDT processor");
			break;
		default:
			printf("Unknown processor");
		}
	if (CPU_haveMMX())
		printf(" with MMX(R)");
	if (CPU_have3DNow())
		printf(", 3DNow!(R)");
	if (CPU_haveKNI())
		printf(", KNI(R)");
	printf("\n");
	if (CPU_haveRDTSC())
		printf("\nProcessor supports Read Time Stamp Counter performance timer.\n");
	return 0;
}
