/****************************************************************************
*
*					SciTech Multi-platform Graphics Library
*
*  ========================================================================
*
*    The contents of this file are subject to the SciTech MGL Public
*    License Version 1.0 (the "License"); you may not use this file
*    except in compliance with the License. You may obtain a copy of
*    the License at http://www.scitechsoft.com/mgl-license.txt
*
*    Software distributed under the License is distributed on an
*    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*    implied. See the License for the specific language governing
*    rights and limitations under the License.
*
*    The Original Code is Copyright (C) 1991-1998 SciTech Software, Inc.
*
*    The Initial Developer of the Original Code is SciTech Software, Inc.
*    All Rights Reserved.
*
*  ========================================================================
*
* Language:		ANSI C
* Environment:  QNX
*
* Description:	Include file to include all OS specific header files.
*
****************************************************************************/

#include <sys/stat.h>
#include <fcntl.h>
#include <process.h>
#include <time.h>
#ifndef __QNXNTO__
#include <sys/mouse.h>
#include <sys/keyboard.h>
#include <sys/fd.h>
#include <conio.h>
#else
#include <photon/keyboard.h>
#include <sys/neutrino.h>

/* Temp 'til this header becomes 'official' */
#ifndef INPUT_RESMGR_H_INCLUDED
#define INPUT_RESMGR_H_INCLUDED

#define _MOUSE_LEFT     0x0004L
#define _MOUSE_MIDDLE   0x0002L
#define _MOUSE_RIGHT    0x0001L

struct mse_pkt {

      short                  dx;
      short                  dy;
      short                  dz;
      long                   buttons;
      struct timespec        timestamp;  
};

struct abs_pkt {

  unsigned int flags;
#define ABS_MODE_RAW    0x01
#define ABS_MODE_CALIB  0x02

  unsigned int           x;
  unsigned int           y;
  unsigned int           z;
  unsigned int           buttons;
  struct timespec        timestamp;  
};

struct kbd_data {

  unsigned long  mods;
  unsigned long  flags;
  unsigned long  caps;
  unsigned long  sym;
  unsigned char  scan;
};


struct kbd_pkt {
  struct kbd_data	        key;
  struct timespec		timestamp; 
};

#endif	/* INPUT_RESMGR_H_INCLUDED */

#endif	/* __QNXNTO__ */
