/****************************************************************************
*
*					SciTech OS Portability Manager Library
*
*  ========================================================================
*
*    The contents of this file are subject to the SciTech MGL Public
*    License Version 1.0 (the "License"); you may not use this file
*    except in compliance with the License. You may obtain a copy of
*    the License at http://www.scitechsoft.com/mgl-license.txt
*
*    Software distributed under the License is distributed on an
*    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*    implied. See the License for the specific language governing
*    rights and limitations under the License.
*
*    The Original Code is Copyright (C) 1991-1998 SciTech Software, Inc.
*
*    The Initial Developer of the Original Code is SciTech Software, Inc.
*    All Rights Reserved.
*
*  ========================================================================
*
* Language:		ANSI C
* Environment:	Any
*
* Description:	Module containing code common to all platforms.
*
****************************************************************************/

#include "pmapi.h"
#include "drvlib/os/os.h"
#ifdef __WIN32_VXD__
#include "sdd/sddhelp.h"
#else
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#endif

/*---------------------------- Global variables ---------------------------*/

long _VARAPI ___drv_os_type = _OS_UNSUPPORTED;

/*----------------------------- Implementation ----------------------------*/

/****************************************************************************
PARAMETERS:
dllname	- Name of the Binary Portable DLL to load
bpdpath	- Place to store the actual path to the file

RETURNS:
True if found, false if not.

REMARKS:
Finds the location of a specific Binary Portable DLL, by searching all
the standard SciTech Nucleus driver locations.
****************************************************************************/
ibool PMAPI PM_findBPD(
	const char *dllname,
	char *bpdpath)
{
	char	filename[256];
	FILE	*f;
#ifndef	__WIN32_VXD__
	char	*mgl_root = getenv("MGL_ROOT");
#endif

	PM_init();
	strcpy(bpdpath,PM_getNucleusPath());
	PM_backslash(bpdpath);
	strcpy(filename,bpdpath);
	strcat(filename,dllname);
	if ((f = fopen(filename,"rb")) != NULL)
		goto Found;

#ifndef	__WIN32_VXD__
	/* Next try in the directory relative to the MGL_ROOT
	 * environment variable.
	 */
	if (mgl_root) {
		strcpy(bpdpath, mgl_root);
		PM_backslash(bpdpath);
		strcat(bpdpath,"drivers");
		PM_backslash(bpdpath);
		strcpy(filename,bpdpath);
		strcat(filename,dllname);
		if ((f = fopen(filename,"rb")) != NULL)
			goto Found;
		}
#endif

	/* Next try in the MGL drivers directory relative to application */
	strcpy(bpdpath,PM_getCurrentPath());
	PM_backslash(bpdpath);
	strcpy(bpdpath,"drivers");
	PM_backslash(bpdpath);
	strcpy(filename,bpdpath);
	strcat(filename,dllname);
	if ((f = fopen(filename,"rb")) != NULL)
		goto Found;

	/* Next try to find the driver in the current directory */
	strcpy(bpdpath,PM_getCurrentPath());
	PM_backslash(bpdpath);
	strcpy(filename,bpdpath);
	strcat(filename,dllname);
	if ((f = fopen(filename,"rb")) != NULL)
		goto Found;

	/* Whoops, couldn't open the BPD file! */
	return false;

Found:
	fclose(f);
	return true;
}
