#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>
#include <pthread.h>

#include <vga.h>
#include <jpeglib.h>
#include <sys/ioctl.h>
#include <linux/soundcard.h>

#include <dlfcn.h>

#include "playvideo.h"
#include "stdDHT.h"
#include "mod.h"
#include "avi_file.h"
#include "qt_file.h"
#include "ex_file.h"
#include "mpeg_file.h"

#define RGB_16(x) (((x&0xf80000)>>8)|((x&0xfc00)>>5)|((x&0xf8)>>3))
#define RGB15_16(x,y) (((x&0x1f)|((x&0xe0)<<1)|((y&0x7f)<<9)))
#define RGB16_2C1_C2(c1,c2) ( \
(((c1&0x1f)*43+(c2&0x1f)*21)>>6) | \
(((((c1>>5)&0x3f)*43+((c2>>5)&0x3f)*21)>>6)<<5) | \
(((((c1>>11)&0x1f)*43+((c2>>11)&0x1f)*21)>>6)<<11) \
)

static int *skip;
static unsigned char *playbuf;

void src_mgr_init(struct jpeg_decompress_struct *cinfo) {
    cinfo->src->next_input_byte=playbuf + *skip;
    cinfo->src->bytes_in_buffer = 128*1024-*skip;
}

void src_mgr_skip(struct jpeg_decompress_struct *cinfo, long num_bytes) {
    cinfo->src->next_input_byte+=num_bytes;
    cinfo->src->bytes_in_buffer -= num_bytes;
}

boolean src_mgr_resync(struct jpeg_decompress_struct *cinfo, int desired) {
    return TRUE;
}

boolean src_mgr_fill(struct jpeg_decompress_struct *cinfo) {
    return TRUE;
}

void src_mgr_term(struct jpeg_decompress_struct *cinfo) {
    return;
}

int vidinfo(char *filename, VIDEO_FILE *file, int verbose) {
    int (*open_file)(char *, VIDEO_FILE *, int);
    int (*close_file)(VIDEO_FILE *);
    if(ex_check_file(filename)) {
        open_file=ex_open_file;
        close_file=ex_close_file;
    } else if(qt_check_file(filename)) {
        open_file=qt_open_file;
        close_file=qt_close_file;
    } else if(mpeg_check_file(filename)) {
        open_file=mpeg_open_file;
        close_file=mpeg_close_file;
    } else if(avi_check_file(filename)) {
        open_file=avi_open_file;
        close_file=avi_close_file;
    } else {
        fprintf(stderr,"unrecognized format.\n");
        return -1;
    }

    if(!open_file(filename, file, verbose)) {
        close_file(file);
    } else {
        return -1;
    }
    return 0;
}

void *playvideo(void *arg) {

    void *codec_module;
    XA_CODEC_HDR codec;
    VIDEO_FILE file;
    play_info *pi=(play_info *)arg;
    int frame_timepos;
    
    int (*open_file)(char *, VIDEO_FILE *, int);
    int (*read_vframe)(VIDEO_FILE *, unsigned char *, int, int *);
    int (*read_aframe)(VIDEO_FILE *, unsigned char *, int);

    if(ex_check_file(pi->filename)) {
        open_file=ex_open_file;
        read_vframe=ex_read_vframe;
        read_aframe=ex_read_aframe;
    } else if(qt_check_file(pi->filename)) {
        open_file=qt_open_file;
        read_vframe=qt_read_vframe;
        read_aframe=qt_read_aframe;
    } else if(mpeg_check_file(pi->filename)) {
        open_file=mpeg_open_file;
        read_vframe=mpeg_read_vframe;
        read_aframe=mpeg_read_aframe;
    } else if(avi_check_file(pi->filename)) {
        open_file=avi_open_file;
        read_vframe=avi_read_vframe;
        read_aframe=avi_read_aframe;
    } else {
        fprintf(stderr,"unrecognized format.\n");
        return (void *)-1;
    }

    file.palette=NULL;

    open_file(pi->filename, &file, pi->verbose);

    if(pi->verbose) {
        fprintf(stderr,"width=%i\theight=%i\tus per frame=%i   %i frames\n"
               "compression=%c%c%c%c\n"
               "asize=%i\tarate=%i\tachannels=%i\n",
               file.width,file.height,file.us_frame,file.vframes,
               file.compression[0],
               file.compression[1],
               file.compression[2],
               file.compression[3],
               file.asize,file.arate,file.achannels
               );
    }

    pi->playbuf=malloc(6*1024*1024);
    frame_timepos=0;
    
    if((pi->playframe>-1) && (pi->len>-1)) {
        int i;
        struct timeval start, tv;
        unsigned char *image, *ptr, *scr, *gm;
        struct jpeg_decompress_struct cinfo;
        struct jpeg_error_mgr jerr;
        struct jpeg_source_mgr src_mgr;
        FILE *a_file;
        int a_fh;
        int aplay=0, vplay=0;
        
        if(pi->len+pi->playframe>file.vframes)pi->len=file.vframes-pi->playframe;

        if(!pi->noaudio && file.hasaudio && (file.aframes>0)) {
            aplay=1;
        }
        
        if(!pi->novideo && file.hasvideo && (file.vframes>0)) {
            switch(MAKE4CC(file.compression)) {
                case 0:
                    vplay=2;
                    break;
                case jpegtag:
                case MJPGtag:
                    vplay=1;
                    break;
                case CRAMtag:
                    if(file.bitspp==8) {
                        vplay=3;
                    }
                    if(file.bitspp==16)vplay=4;
                    break;
                case cvidtag: 
                case IV41tag:
                case iv31tag:
                case IV31tag:
                case IV32tag: {
                    XAVID_MOD_HDR *(*what_the)(), *mh;
                    vplay=5;
                    switch(MAKE4CC(file.compression)) {
                        case cvidtag:
                            codec_module=dlopen("/usr/local/xanim/mods/vid_cvid_2.0_linuxELFx86g21.xa",RTLD_LAZY);
                            break;
                        case iv31tag:
                        case IV31tag:
                        case IV32tag:
                            codec_module=dlopen("/usr/local/xanim/mods/vid_iv32_2.1_linuxELFx86g21.xa",RTLD_LAZY);
                            break;
                        case IV41tag:
                            codec_module=dlopen("/usr/local/xanim/mods/vid_iv41_1.0_linuxELFx86g21.xa",RTLD_LAZY);
                            break;
                        default:
                            fprintf(stderr,"Unsupported codec module.\n");
                            return (void *)-2;
                    }
                    what_the=dlsym(codec_module,"What_The");                    
    
                    mh=what_the();
                    codec.avi_ctab_flag=1;
                    codec.xapi_rev=2;
                    codec.compression=MAKECC4(file.compression);
                    codec.extra=0;
                    codec.depth=24;
                    codec.x=file.width;
                    codec.y=file.height;
                    codec.avi_read_ext=NULL;
                    mh->funcs->iq_func(&codec);
                    }
                    break;
                case rletag:
                    switch(file.bitspp) {
                        case 8:
                            vplay=6;
                            break;
                    }
                    break;
                case mpegtag:
                    vplay=7;    
                    break;
                case rpzatag:
                    if(file.bitspp==16)vplay=8;
                    break;
                default:
                    if(pi->verbose)fprintf(stderr,"Unknown video compression: %c%c%c%c  (0x%08x).\n",
                        file.compression[0],file.compression[1],file.compression[2],
                        file.compression[3],MAKE4CC(file.compression));
                    
            }
            if(pi->verbose){
                fprintf(stderr,"vplay=%i\n",vplay);
            }
        }
        
        image=malloc(file.width*file.height*4+4096);

        if(aplay) {
            int j;
            a_file=fopen(pi->audiodev,"w");
            a_fh=fileno(a_file);
            ioctl(a_fh, SNDCTL_DSP_RESET, 0);
            
            switch(file.aformat&0xff) {
                case 4:
                    i=AFMT_IMA_ADPCM;
                    break;
                case 8:
                    i=AFMT_S8;
                    break;
                case 16:
                    i=AFMT_S16_LE;
                    break;
            }
            j=ioctl(a_fh, SNDCTL_DSP_SETFMT, &i);
            i=file.achannels-1;
            j=ioctl(a_fh, SNDCTL_DSP_STEREO, &i);
            i=file.arate;
            j=ioctl(a_fh, SNDCTL_DSP_SPEED, &i);
        }
        
        if(vplay) {
            if(vplay==1) {
                src_mgr.init_source=src_mgr_init;
                src_mgr.skip_input_data=src_mgr_skip;
                src_mgr.resync_to_restart=src_mgr_resync;
                src_mgr.fill_input_buffer=src_mgr_fill;
                src_mgr.term_source=src_mgr_term;
        
                cinfo.err=jpeg_std_error(&jerr);
                jpeg_create_decompress(&cinfo);
        
                cinfo.src=&src_mgr;
                playbuf=pi->playbuf;
                skip=&pi->skip;
            }
            if(pi->novga) {
                gm=(unsigned char *)pi->novga;
            } else {
                vga_modeinfo *mi;
                vga_init();
                vga_setmode(pi->scr_mode);
                mi=vga_getmodeinfo(pi->scr_mode);
                pi->scr_width=mi->width;
                switch(mi->bytesperpixel+mi->colors) {
                    case 257:
                        pi->scr_bpp=8;
                        break;
                    case 32770:
                        pi->scr_bpp=15;
                        break;
                    case 65538:
                        pi->scr_bpp=16;
                        break;
                    case (1<<24)+3:
                        pi->scr_bpp=24;
                        break;
                    case (1<<24)+4:
                        pi->scr_bpp=32;
                        break;
                    default:
                        pi->scr_bpp=0;
                        break;
                }

                sleep(1);
                vga_setlinearaddressing();
                gm=vga_getgraphmem()+(pi->sy*pi->scr_width+pi->sx)*4;
            }
            if((pi->scr_bpp==16)&& file.palette) {
                file.palette16=(unsigned short *)malloc(512);
                for(i=0;i<256;i++) file.palette16[i]=RGB_16(file.palette[i]);
            }
            if(vplay==7) {
                switch(pi->scr_bpp) {
                    case 16:
                        file.param=2;
                        break;
                    case 32:
                        file.param=1;
                        break;
                }
            }
        }

        gettimeofday(&start,NULL);
        
        for(i=0;i<pi->len;i++) {
            int j;
            int ins, sawDHT;
            
            if(aplay) {
                int size;
                size=read_aframe(&file, pi->playbuf, i+pi->playframe);
                fwrite(pi->playbuf,size,1,a_file);
            }
            
            if(vplay) {
                int framelen;
                int frametime;
                
                pi->skip=432;
                if(vplay==7){
                    unsigned char **p=(unsigned char **)pi->playbuf;
                    pi->skip=0;
                    scr=pi->playbuf+4096;
                    for(j=0;j<1024;j++) {
                        p[j]=scr;
                        scr+=4096;
                    }
                }

                frametime=read_vframe(&file, pi->playbuf+pi->skip, i+pi->playframe, &framelen);
                
                if(!file.us_frame){
                    frame_timepos=frametime;
                } else {
		    if(frametime)break;
		    frame_timepos=(i+1)*file.us_frame;
		}
                switch(pi->scr_bpp) {
                    case 32:
                        switch(vplay) {
                            case 1:
                                if((pi->playbuf[432]==0xff) && (pi->playbuf[433]==0xd8)) {
                                    ins=0;
                                    sawDHT=0;
                                    j=434;
                                    while( !ins && (j<framelen) ) {
                                        if(pi->playbuf[j]!=0xff) {
                                            ins=-1;
                                        } else {
                                            switch(pi->playbuf[j+1]) {
                                                case 0xc4:
                                                    sawDHT=1;
                                                    break;
                                                case 0xda:
                                                    ins=j-432;
                                                    break;
                                            }
                                            j+= pi->playbuf[j+3] + (pi->playbuf[j+2] << 8) + 2;
                                        }
                                    }
                                    if((ins>0) && !sawDHT) {
                                        memmove(pi->playbuf,pi->playbuf+432,ins);
                                        memcpy(pi->playbuf+ins,stdDHT,432);
                                        pi->skip=0;
                                    }
                                    jpeg_read_header(&cinfo,TRUE);
                                    cinfo.out_color_space=JCS_RGB;
                                    cinfo.dct_method=JDCT_IFAST;
                                    cinfo.do_fancy_upsampling=FALSE;
                                    jpeg_start_decompress(&cinfo);
                                    ptr=image;
                                    while(cinfo.output_scanline<cinfo.output_height) {
                                        j=jpeg_read_scanlines(&cinfo,&ptr,1 /*cinfo.output_height*/);
                                        ptr+=cinfo.output_width*3*j;
                                    }
                                    ptr=image;
                                    scr=gm;
                                    for(j=0;j<cinfo.output_height;j++) {
                                        int k;
                                        for(k=0;k<cinfo.output_width;k++) {
                                            *scr++=*(ptr+2);
                                            *scr++=*(ptr+1);
                                            *scr++=*ptr;
                                            scr++;
                                            ptr+=3;
                                        }
                                        scr+=(pi->scr_width-cinfo.output_width)*4;
                                    }
                                    jpeg_finish_decompress(&cinfo);
                                }
                                break;
                            case 2: {
                                int width, k, l;
                                                
                                l=pi->skip;
                                scr=gm+pi->scr_width*4*(file.height-1);
                                width=((file.width-1) | 3) + 1;
                                switch(file.bitspp) {
                                    case 8:
                                        for(j=0;j<file.height; j++) {
                                            for(k=0;k<width;k++) {
                                                *(int *)scr=file.palette[pi->playbuf[l++]];
                                                scr+=4;
                                            }
                                            scr-=(pi->scr_width+width)*4;
                                        }
                                        break;
                                    case 16:
                                        for(j=0;j<file.height; j++) {
                                            for(k=0;k<width;k++) {
                                                *(int *)(scr)=((pi->playbuf[l]&0x1f)<<3) | 
                                                              ((pi->playbuf[l]&0xe0)<<6) |
                                                              ((pi->playbuf[l+1]&0x03)<<14) | 
                                                              ((pi->playbuf[l+1]&0x7c)<<17);
                                                l+=2;
                                                scr+=4;
                                            }
                                            scr-=(pi->scr_width+width)*4;
                                        }
                                }
                                }
                                break;
                            case 3: {/* CRAM8 */
                                int x, y, cont=1, blocks, l;
                        
                                l=pi->skip;
                                y=file.height-1;
                                x=0;
                                blocks=file.height*file.width/16+1;
                                while(cont) {
                                    int c0,c1;
                            
                                    c0=pi->playbuf[l++];
                                    c1=pi->playbuf[l++];
                                    blocks--;
                                    if(( !c0 && !c1 && !blocks)||(y<0)) cont=0; else {
                                        if((c1>=0x84)&&(c1<=0x87)) {
                                            int k;
                                            k=((c1-0x84)<<8)+c0;
                                            blocks-=k-1;
                                            while(--k) {
                                                x+=4;
                                                if(x>=file.width) { 
                                                    x=0;
                                                    y-=4;
                                                }
                                            }
                                        } else {
                                            if(c1>=0x90) {
                                                int col0,col1,col2,col3;
                                                int *p;
                                        
                                                p=(int *)gm+y*pi->scr_width+x;
    
                                                col1=file.palette[pi->playbuf[l++]];
                                                col0=file.palette[pi->playbuf[l++]];
                                                col3=file.palette[pi->playbuf[l++]];
                                                col2=file.palette[pi->playbuf[l++]];
                                        
                                                *(p++)=c0&0x01?col1:col0;
                                                *(p++)=c0&0x02?col1:col0;
                                                *(p++)=c0&0x04?col3:col2;
                                                *p=c0&0x08?col3:col2;
                                                p-=pi->scr_width+3;
                                                *(p++)=c0&0x10?col1:col0;
                                                *(p++)=c0&0x20?col1:col0;
                                                *(p++)=c0&0x40?col3:col2;
                                                *p=c0&0x80?col3:col2;
                                                p-=pi->scr_width+3;
    
                                                col1=file.palette[pi->playbuf[l++]];
                                                col0=file.palette[pi->playbuf[l++]];
                                                col3=file.palette[pi->playbuf[l++]];
                                                col2=file.palette[pi->playbuf[l++]];
                                        
                                                *(p++)=c1&0x01?col1:col0;
                                                *(p++)=c1&0x02?col1:col0;
                                                *(p++)=c1&0x04?col3:col2;
                                                *p=c1&0x08?col3:col2;
                                                p-=pi->scr_width+3;
                                                *(p++)=c1&0x10?col1:col0;
                                                *(p++)=c1&0x20?col1:col0;
                                                *(p++)=c1&0x40?col3:col2;
                                                *p=c1&0x80?col3:col2;
                                            } else if (c1<0x80) {
                                                int col0,col1,i,j;
                                                col1=file.palette[pi->playbuf[l++]];
                                                col0=file.palette[pi->playbuf[l++]];
                                                for(i=0;i<2;i++)for(j=0;j<4;j++) {
                                                    *((int *)gm+(y-i)*pi->scr_width+x+j)=c0&1?col1:col0;
                                                    c0>>=1;
                                                }
                                                for(i=2;i<4;i++)for(j=0;j<4;j++) {
                                                    *((int *)gm+(y-i)*pi->scr_width+x+j)=c1&1?col1:col0;
                                                    c1>>=1;
                                                }
                                            } else {
                                                int i,j;
                                                for(i=0;i<4;i++)for(j=0;j<4;j++)
                                                    *((int *)gm+(y-i)*pi->scr_width+x+j)=file.palette[c0];
                                            }
                                        }
                                        x+=4;
                                        if(x>=file.width) { 
                                            x=0;
                                            y-=4;
                                        }
                                    }
                                }
                                }
                                break;
                            case 4: {/* CRAM16 */
                                int x, y, cont=1, blocks, l;
                        
                                l=pi->skip;
                                y=file.height-1;
                                x=0;
                                blocks=file.height*file.width/16+1;
                                while(cont) {
                                    int c0,c1;
                            
                                    c0=pi->playbuf[l++];
                                    c1=pi->playbuf[l++];
                                    blocks--;
                                    if(( !c0 && !c1 && !blocks)||(y<0)) cont=0; else {
                                        if((c1>=0x84)&&(c1<=0x87)) {
                                            int k;
                                            k=((c1-0x84)<<8)+c0;
                                            blocks-=k-1;
                                            while(--k) {
                                                x+=4;
                                                if(x>=file.width) { 
                                                    x=0;
                                                    y-=4;
                                                }
                                            }
                                        } else {
                                            if(c1<0x80) {
                                                int col0,col1;
                                                col1=((pi->playbuf[l]&0x1f)<<3) | 
                                                     ((pi->playbuf[l]&0xe0)<<6) | 
                                                     ((pi->playbuf[l+1]&0x03)<<14) | 
                                                     ((pi->playbuf[l+1]&0xfc)<<17);
                                                l+=2;
                                                col0=((pi->playbuf[l]&0x1f)<<3) |
                                                     ((pi->playbuf[l]&0xe0)<<6) | 
                                                     ((pi->playbuf[l+1]&0x03)<<14) |
                                                     ((pi->playbuf[l+1]&0x7c)<<17);
                                                l+=2;
                                                if(col1&0x1000000) {
                                                    int *p;
                                                    int col2,col3;
                                        
                                                    p=(int *)gm+y*pi->scr_width+x;
                                                    col1&=0x00ffffff;
                                                    col3=((pi->playbuf[l]&0x1f)<<3) |
                                                         ((pi->playbuf[l]&0xe0)<<6) | 
                                                         ((pi->playbuf[l+1]&0x03)<<14) |
                                                         ((pi->playbuf[l+1]&0x7c)<<17);
                                                    l+=2;
                                                    col2=((pi->playbuf[l]&0x1f)<<3) | 
                                                         ((pi->playbuf[l]&0xe0)<<6) | 
                                                         ((pi->playbuf[l+1]&0x03)<<14) |
                                                         ((pi->playbuf[l+1]&0x7c)<<17);
                                                    l+=2;
                                                    *(p++)=c0&0x01?col1:col0;
                                                    *(p++)=c0&0x02?col1:col0;
                                                    *(p++)=c0&0x04?col3:col2;
                                                    *p=c0&0x08?col3:col2;
                                                    p-=pi->scr_width+3;
                                                    *(p++)=c0&0x10?col1:col0;
                                                    *(p++)=c0&0x20?col1:col0;
                                                    *(p++)=c0&0x40?col3:col2;
                                                    *p=c0&0x80?col3:col2;
                                                    p-=pi->scr_width+3;
    
                                                    col1=((pi->playbuf[l]&0x1f)<<3) |
                                                         ((pi->playbuf[l]&0xe0)<<6) | 
                                                         ((pi->playbuf[l+1]&0x03)<<14) |
                                                         ((pi->playbuf[l+1]&0x7c)<<17);
                                                    l+=2;
                                                    col0=((pi->playbuf[l]&0x1f)<<3) |
                                                         ((pi->playbuf[l]&0xe0)<<6) | 
                                                         ((pi->playbuf[l+1]&0x03)<<14) |
                                                         ((pi->playbuf[l+1]&0x7c)<<17);
                                                    l+=2;
                                                    col3=((pi->playbuf[l]&0x1f)<<3) |
                                                         ((pi->playbuf[l]&0xe0)<<6) | 
                                                         ((pi->playbuf[l+1]&0x03)<<14) |
                                                         ((pi->playbuf[l+1]&0x7c)<<17);
                                                    l+=2;
                                                    col2=((pi->playbuf[l]&0x1f)<<3) |
                                                         ((pi->playbuf[l]&0xe0)<<6) | 
                                                         ((pi->playbuf[l+1]&0x03)<<14) |
                                                         ((pi->playbuf[l+1]&0x7c)<<17);
                                                    l+=2;
                                                    *(p++)=c1&0x01?col1:col0;
                                                    *(p++)=c1&0x02?col1:col0;
                                                    *(p++)=c1&0x04?col3:col2;
                                                    *p=c1&0x08?col3:col2;
                                                    p-=pi->scr_width+3;
                                                    *(p++)=c1&0x10?col1:col0;
                                                    *(p++)=c1&0x20?col1:col0;
                                                    *(p++)=c1&0x40?col3:col2;
                                                    *p=c1&0x80?col3:col2;
                                                } else {
                                                    int i,j;
                                                    for(i=0;i<2;i++)for(j=0;j<4;j++) {
                                                        *((int *)gm+(y-i)*pi->scr_width+x+j)=
                                                    			        c0&1?col1:col0;
                                                        c0>>=1;
                                                    }
                                                    for(i=2;i<4;i++)for(j=0;j<4;j++) {
                                                        *((int *)gm+(y-i)*pi->scr_width+x+j)=
                                                    			        c1&1?col1:col0;
                                                        c1>>=1;
                                                    }
                                            
                                                }
                                            } else {
                                                int i,j,c;
                                                c=((c0&0x1f)<<3) | ((c0&0xe0)<<6) | 
                                                  ((c1&0x03)<<14) | ((c1&0x7c)<<17);
                                                for(i=0;i<4;i++)for(j=0;j<4;j++)
                                                    *((int *)gm+(y-i)*pi->scr_width+x+j)=c;
                                            }
                                        }
                                        x+=4;
                                        if(x>=file.width) { 
                                            x=0;
                                            y-=4;
                                        }
                                    }
                                }
                                }
                                break;
                            case 5: { /* cvid, iv32 xanim binary codec */
                                XA_DEC2_INFO xadi;
                                int j,k;
    
                                xadi.cmd=0;
                                xadi.chdr=0;
                                xadi.map=0;
                                xadi.special=0;
                                xadi.skip_flag=0;
                                xadi.map_flag=0;
                                xadi.extra=0;
                                xadi.imagex=file.width;
                                xadi.imagey=file.height;
                                xadi.imaged=24;
                                xadi.image_type=1;
                                xadi.bytes_pixel=3;
                                if(framelen)
                                    codec.decoder(image,pi->playbuf+pi->skip,framelen,&xadi);
                                scr=gm;
                                ptr=image;
                                for(k=0;k<file.height;k++) {
                                    for (j=0;j<file.width;j++) {
                                        *(scr+2)=*ptr++;
                                        *(scr+1)=*ptr++;
                                        *scr=*ptr++;
                                        scr+=4;
                                    }
                                    scr+=(pi->scr_width-file.width)*4;
                                }   
                                }
                                break;                    
                            case 6:{ /* RLE8, quicktime */
                                int f, y, lasty, l;
                                int *p;
                        
                                l=pi->skip+4;
                        
                                p=(int *)gm;
                                f=(pi->playbuf[l]<<8)+pi->playbuf[l+1];
                                l+=2;
                        
                                if(f&0x0008) {
                                    y=(pi->playbuf[l]<<8)+pi->playbuf[l+1];
                                    l+=4;
                                    lasty=y+(pi->playbuf[l]<<8)+pi->playbuf[l+1];
                                    l+=4;
                                } else {
                                    lasty=0;
                                    y=file.height;
                                }
                                while(y<lasty) {
                                    int x,c;
                                    x=pi->playbuf[l++];
                                    if(x) {
                                        x--;
                                        x<<=2;
                                        c=pi->playbuf[l++];
                                        while(c!=0xff) {
                                            if(c==0) {
                                                x+=(pi->playbuf[l++]-1)<<2;
                                            } else if(c<0x80) {
                                                c<<=2;
                                                while(c--) {
                                                    *(p+pi->scr_width*y+x)=file.palette[pi->playbuf[l++]];
                                                    x++;
                                                }
                                            } else {
                                                int c0,c1,c2,c3;
                                                c0=file.palette[pi->playbuf[l++]];
                                                c1=file.palette[pi->playbuf[l++]];
                                                c2=file.palette[pi->playbuf[l++]];
                                                c3=file.palette[pi->playbuf[l++]];                                        
                                                c=256-c;
                                                while(c--) {
                                                    *(p+pi->scr_width*y+x)=c0;
                                                    x++;
                                                    *(p+pi->scr_width*y+x)=c1;
                                                    x++;
                                                    *(p+pi->scr_width*y+x)=c2;
                                                    x++;
                                                    *(p+pi->scr_width*y+x)=c3;
                                                    x++;
                                                }
                                            }
                                            c=pi->playbuf[l++];
                                        }
                                    }
                                    y++;
                                }
                                }
                                break;
                            case 7: {
                                int k;
                                unsigned char **p;
                        
                                p=(unsigned char **)pi->playbuf;
                                scr=gm;
                                for(k=0;k<file.height; k++) {
                                    memcpy(scr,p[k],file.width<<2);
                                    scr+=pi->scr_width<<2;
                                }
                                }
                                break;
                            case 8: {
                                int l, x, y;
                        
                                l=pi->skip+4;
                                x=0;
                                y=0;
                        
                                while(l<pi->skip+framelen) {
                                    int c;
                                    c=pi->playbuf[l++];
                                    if((c>=0xa0) && (c<=0xbf)) {
                                        int col;
                                        col=((pi->playbuf[l+1]&0x1f)<<3) |
                                            ((pi->playbuf[l+1]&0xe0)<<6) | 
                                            ((pi->playbuf[l]&0x03)<<14) |
                                            ((pi->playbuf[l]&0x7c)<<17);
                                        l+=2;
                                        while(c-->0x9f) {
                                            int i,j;
                                            for(i=0;i<4;i++)for(j=0;j<4;j++)
                                                *((int *)gm+(y+i)*pi->scr_width+x+j)=col;
                                            x+=4;
                                            if(x>=file.width) {
                                                x=0;
                                                y+=4;
                                            }
                                        }
                                    } else if((c>=0x80) && (c<=0x9f)) {
                                        while(c-->0x7f) {
                                            x+=4;
                                            if(x>=file.width) {
                                                x=0;
                                                y+=4;
                                            }
                                        }
                                    } else if((c<0x80) || ((c>=0xc0) && (c<=0xdf))) {
                                        int col0,col1,col2,col3;
                                        if(c>0x80) {
                                            col0=((pi->playbuf[l+1]&0x1f)<<3) |
                                                 ((pi->playbuf[l+1]&0xe0)<<6) | 
                                                 ((pi->playbuf[l]&0x03)<<14) | 
                                                 ((pi->playbuf[l]&0x7c)<<17);
                                            l+=2;
                                        } else {
                                            col0=((pi->playbuf[l]&0x1f)<<3) | 
                                                 ((pi->playbuf[l]&0xe0)<<6) | 
                                                 ((c&0x03)<<14) | ((c&0x7c)<<17);
                                            l++;
                                        }
                                        col1=((pi->playbuf[l+1]&0x1f)<<3) |
                                             ((pi->playbuf[l+1]&0xe0)<<6) | 
                                             ((pi->playbuf[l]&0x03)<<14) | 
                                             ((pi->playbuf[l]&0xfc)<<17);
                                        l+=2;
                                        if(!(col1&0x1000000) && (c<0x80)) {
                                            int *p;
                                            int(j);
                                            p=(int *)gm+y*pi->scr_width+x;
                                            col1&=0x00ffffff;
                                            col2=((pi->playbuf[l+1]&0x1f)<<3) |
                                                 ((pi->playbuf[l+1]&0xe0)<<6) | 
                                                 ((pi->playbuf[l]&0x03)<<14) |
                                                 ((pi->playbuf[l]&0x7c)<<17);
                                            l+=2;
                                            col3=((pi->playbuf[l+1]&0x1f)<<3) |
                                                 ((pi->playbuf[l+1]&0xe0)<<6) | 
                                                 ((pi->playbuf[l]&0x03)<<14) |
                                                 ((pi->playbuf[l]&0x7c)<<17);
                                            l+=2;
                                            *(p++)=col0;
                                            *(p++)=col1;
                                            *(p++)=col2;
                                            *p=col3;
                                            p+=pi->scr_width-3;
                                            for(j=0;j<3;j++) {
                                                col0=((pi->playbuf[l+1]&0x1f)<<3) |
                                                     ((pi->playbuf[l+1]&0xe0)<<6) | 
                                                     ((pi->playbuf[l]&0x03)<<14) |
                                                     ((pi->playbuf[l]&0x7c)<<17);
                                                l+=2;
                                                col1=((pi->playbuf[l+1]&0x1f)<<3) |
                                                     ((pi->playbuf[l+1]&0xe0)<<6) | 
                                                     ((pi->playbuf[l]&0x03)<<14) |
                                                     ((pi->playbuf[l]&0x7c)<<17);
                                                l+=2;
                                                col2=((pi->playbuf[l+1]&0x1f)<<3) |
                                                     ((pi->playbuf[l+1]&0xe0)<<6) | 
                                                     ((pi->playbuf[l]&0x03)<<14) |
                                                     ((pi->playbuf[l]&0x7c)<<17);
                                                l+=2;
                                                col3=((pi->playbuf[l+1]&0x1f)<<3) |
                                                     ((pi->playbuf[l+1]&0xe0)<<6) | 
                                                     ((pi->playbuf[l]&0x03)<<14) |
                                                     ((pi->playbuf[l]&0x7c)<<17);
                                                l+=2;
                                                *(p++)=col0;
                                                *(p++)=col1;
                                                *(p++)=col2;
                                                *p=col3;
                                                p+=pi->scr_width-3;
                                            }
                                            x+=4;
                                            if(x>=file.width) {
                                                x=0;
                                                y+=4;
                                            }
                                        } else {
                                            int n, m[4], d[4], i,j, *p;
                                    
                                            d[3]=col0;
                                            d[0]=col1;
                                            d[1]=((21*(col0&0xff)+43*(col1&0xff))>>6)&0xff;
                                            d[1]|=((21*(col0&0xff00)+43*(col1&0xff00))>>6)&0xff00;
                                            d[1]|=((21*(col0&0xff0000)+43*(col1&0xff0000))>>6)&0xff0000;
                                            d[2]=((21*(col1&0xff)+43*(col0&0xff))>>6)&0xff;
                                            d[2]|=((21*(col1&0xff00)+43*(col0&0xff00))>>6)&0xff00;
                                            d[2]|=((21*(col1&0xff0000)+43*(col0&0xff0000))>>6)&0xff0000;
                                    
                                            if(c<0x80)n=1; else n=c-0xb0;
                                            while(n--) {
                                                m[0]=pi->playbuf[l++];
                                                m[1]=pi->playbuf[l++];
                                                m[2]=pi->playbuf[l++];
                                                m[3]=pi->playbuf[l++];
                                                p=(int *)gm+y*pi->scr_width+x;
                                                for(i=0;i<4;i++) {
                                                    for(j=0;j<4;j++) {
                                                        *p++=d[(m[i]&0xc0)>>6];
                                                        m[i]<<=2;
                                                    }
                                                    p+=pi->scr_width-4;
                                                }
                                                x+=4;
                                                if(x>=file.width) {
                                                    x=0;
                                                    y+=4;
                                                }
                                            }
                                        }
                                    }
                                }
                                }
                                break;
                        }
                        break;
                    case 16:
                        switch(vplay) {
                            case 1:
                                if((pi->playbuf[432]==0xff) && (pi->playbuf[433]==0xd8)) {
                                    ins=0;
                                    sawDHT=0;
                                    j=434;
                                    while( !ins && (j<framelen) ) {
                                        if(pi->playbuf[j]!=0xff) {
                                            ins=-1;
                                        } else {
                                            switch(pi->playbuf[j+1]) {
                                                case 0xc4:
                                                    sawDHT=1;
                                                    break;
                                                case 0xda:
                                                    ins=j-432;
                                                    break;
                                            }
                                            j+= pi->playbuf[j+3] + (pi->playbuf[j+2] << 8) + 2;
                                        }
                                    }
                                    if((ins>0) && !sawDHT) {
                                        memmove(pi->playbuf,pi->playbuf+432,ins);
                                        memcpy(pi->playbuf+ins,stdDHT,432);
                                        pi->skip=0;
                                    }
                                    jpeg_read_header(&cinfo,TRUE);
                                    cinfo.out_color_space=JCS_RGB;
                                    cinfo.dct_method=JDCT_IFAST;
                                    cinfo.do_fancy_upsampling=FALSE;
                                    jpeg_start_decompress(&cinfo);
                                    ptr=image;
                                    while(cinfo.output_scanline<cinfo.output_height) {
                                        j=jpeg_read_scanlines(&cinfo,&ptr,1 /*cinfo.output_height*/);
                                        ptr+=cinfo.output_width*3*j;
                                    }
                                    ptr=image;
                                    scr=gm;
                                    for(j=0;j<cinfo.output_height;j++) {
                                        int k;
                                        for(k=0;k<cinfo.output_width;k++) {
                                            *scr++=((*(ptr+1)<<3)&0xe0)|((*(ptr+2)>>3)&0x1f);
                                            *scr++=(*(ptr)&0xf8)|((*(ptr+1)>>5)&0x07);
                                            ptr+=3;
                                        }
                                        scr+=(pi->scr_width-cinfo.output_width)*2;
                                    }
                                    jpeg_finish_decompress(&cinfo);
                                }
                                break;
                            case 2: {
                                int width, k, l;
                                                
                                l=pi->skip;
                                scr=gm+pi->scr_width*2*(file.height-1);
                                width=((file.width-1) | 3) + 1;
                                switch(file.bitspp) {
                                    case 8:
                                        for(j=0;j<file.height; j++) {
                                            for(k=0;k<width;k++) {
                                                *(unsigned short *)scr=
                                                    		file.palette16[pi->playbuf[l++]];
                                                scr+=2;
                                            }
                                            scr-=(pi->scr_width+width)*2;
                                        }
                                        break;
                                    case 16:
                                        for(j=0;j<file.height; j++) {
                                            for(k=0;k<width;k++) {
                                                *( unsigned short *)(scr)=
                                                    		(pi->playbuf[l]&0x1f) | 
                                                    		((pi->playbuf[l]&0xe0)<<1) | 
                                                                ((pi->playbuf[l+1]&0x7f)<<9);
                                                l+=2;
                                                scr+=2;
                                            }
                                            scr-=(pi->scr_width+width)*2;
                                        }
                                }
                                }
                                break;
                            case 3: {/* CRAM8 */
                                int x, y, cont=1, blocks, l;
                        
                                l=pi->skip;
                                y=file.height-1;
                                x=0;
                                blocks=file.height*file.width/16+1;
                                while(cont) {
                                    int c0,c1;
                            
                                    c0=pi->playbuf[l++];
                                    c1=pi->playbuf[l++];
                                    blocks--;
                                    if(( !c0 && !c1 && !blocks)||(y<0)) cont=0; else {
                                        if((c1>=0x84)&&(c1<=0x87)) {
                                            int k;
                                            k=((c1-0x84)<<8)+c0;
                                            blocks-=k-1;
                                            while(--k) {
                                                x+=4;
                                                if(x>=file.width) { 
                                                    x=0;
                                                    y-=4;
                                                }
                                            }
                                        } else {
                                            if(c1>=0x90) {
                                                unsigned short col0,col1,col2,col3;
                                                unsigned short *p;
                                        
                                                p=(unsigned short *)gm+y*pi->scr_width+x;
    
                                                col1=file.palette16[pi->playbuf[l++]];
                                                col0=file.palette16[pi->playbuf[l++]];
                                                col3=file.palette16[pi->playbuf[l++]];
                                                col2=file.palette16[pi->playbuf[l++]];
                                        
                                                *(p++)=c0&0x01?col1:col0;
                                                *(p++)=c0&0x02?col1:col0;
                                                *(p++)=c0&0x04?col3:col2;
                                                *p=c0&0x08?col3:col2;
                                                p-=pi->scr_width+3;
                                                *(p++)=c0&0x10?col1:col0;
                                                *(p++)=c0&0x20?col1:col0;
                                                *(p++)=c0&0x40?col3:col2;
                                                *p=c0&0x80?col3:col2;
                                                p-=pi->scr_width+3;
    
                                                col1=file.palette16[pi->playbuf[l++]];
                                                col0=file.palette16[pi->playbuf[l++]];
                                                col3=file.palette16[pi->playbuf[l++]];
                                                col2=file.palette16[pi->playbuf[l++]];
                                        
                                                *(p++)=c1&0x01?col1:col0;
                                                *(p++)=c1&0x02?col1:col0;
                                                *(p++)=c1&0x04?col3:col2;
                                                *p=c1&0x08?col3:col2;
                                                p-=pi->scr_width+3;
                                                *(p++)=c1&0x10?col1:col0;
                                                *(p++)=c1&0x20?col1:col0;
                                                *(p++)=c1&0x40?col3:col2;
                                                *p=c1&0x80?col3:col2;
                                            } else if (c1<0x80) {
                                                unsigned short col0,col1,i,j;
                                                col1=file.palette16[pi->playbuf[l++]];
                                                col0=file.palette16[pi->playbuf[l++]];
                                                for(i=0;i<2;i++)for(j=0;j<4;j++) {
                                                    *((unsigned short *)gm+(y-i)*pi->scr_width+x+j)=
                                                        	c0&1?col1:col0;
                                                    c0>>=1;
                                                }
                                                for(i=2;i<4;i++)for(j=0;j<4;j++) {
                                                    *((unsigned short *)gm+(y-i)*pi->scr_width+x+j)=
                                                        	c1&1?col1:col0;
                                                    c1>>=1;
                                                }
                                            } else {
                                                int i,j;
                                                for(i=0;i<4;i++)for(j=0;j<4;j++)
                                                    *((unsigned short *)gm+(y-i)*pi->scr_width+x+j)=
                                                        	file.palette16[c0];
                                            }
                                        }
                                        x+=4;
                                        if(x>=file.width) { 
                                            x=0;
                                            y-=4;
                                        }
                                    }
                                }
                                }
                                break;
                            case 4: {/* CRAM16 */
                                int x, y, cont=1, blocks, l;
                        
                                l=pi->skip;
                                y=file.height-1;
                                x=0;
                                blocks=file.height*file.width/16+1;
                                while(cont) {
                                    int c0,c1;
                            
                                    c0=pi->playbuf[l++];
                                    c1=pi->playbuf[l++];
                                    blocks--;
                                    if(( !c0 && !c1 && !blocks)||(y<0)) cont=0; else {
                                        if((c1>=0x84)&&(c1<=0x87)) {
                                            int k;
                                            k=((c1-0x84)<<8)+c0;
                                            blocks-=k-1;
                                            while(--k) {
                                                x+=4;
                                                if(x>=file.width) { 
                                                    x=0;
                                                    y-=4;
                                                }
                                            }
                                        } else {
                                            if(c1<0x80) {
                                                unsigned short col0,col1, bit;
                                                col1=RGB15_16(pi->playbuf[l],pi->playbuf[l+1]);
                                                bit=pi->playbuf[l+1]&0x80;
                                                l+=2;
                                                col0=RGB15_16(pi->playbuf[l],pi->playbuf[l+1]);
                                                l+=2;
                                                if(bit) {
                                                    unsigned short *p;
                                                    unsigned short col2,col3;
                                        
                                                    p=(unsigned short *)gm+y*pi->scr_width+x;
                                                    col3=RGB15_16(pi->playbuf[l],pi->playbuf[l+1]);
                                                    l+=2;
                                                    col2=RGB15_16(pi->playbuf[l],pi->playbuf[l+1]);
                                                    l+=2;
                                                    *(p++)=c0&0x01?col1:col0;
                                                    *(p++)=c0&0x02?col1:col0;
                                                    *(p++)=c0&0x04?col3:col2;
                                                    *p=c0&0x08?col3:col2;
                                                    p-=pi->scr_width+3;
                                                    *(p++)=c0&0x10?col1:col0;
                                                    *(p++)=c0&0x20?col1:col0;
                                                    *(p++)=c0&0x40?col3:col2;
                                                    *p=c0&0x80?col3:col2;
                                                    p-=pi->scr_width+3;
    
                                                    col1=RGB15_16(pi->playbuf[l],pi->playbuf[l+1]);                                                    l+=2;
                                                    col0=RGB15_16(pi->playbuf[l],pi->playbuf[l+1]);                                                    l+=2;
                                                    col3=RGB15_16(pi->playbuf[l],pi->playbuf[l+1]);                                                    l+=2;
                                                    col2=RGB15_16(pi->playbuf[l],pi->playbuf[l+1]);                                                    l+=2;
                                                    *(p++)=c1&0x01?col1:col0;
                                                    *(p++)=c1&0x02?col1:col0;
                                                    *(p++)=c1&0x04?col3:col2;
                                                    *p=c1&0x08?col3:col2;
                                                    p-=pi->scr_width+3;
                                                    *(p++)=c1&0x10?col1:col0;
                                                    *(p++)=c1&0x20?col1:col0;
                                                    *(p++)=c1&0x40?col3:col2;
                                                    *p=c1&0x80?col3:col2;
                                                } else {
                                                    int i,j;
                                                    for(i=0;i<2;i++)for(j=0;j<4;j++) {
                                                        *((unsigned short *)gm+(y-i)*pi->scr_width+x+j)=
                                                    			        c0&1?col1:col0;
                                                        c0>>=1;
                                                    }
                                                    for(i=2;i<4;i++)for(j=0;j<4;j++) {
                                                        *((unsigned short *)gm+(y-i)*pi->scr_width+x+j)=
                                                    			        c1&1?col1:col0;
                                                        c1>>=1;
                                                    }
                                            
                                                }
                                            } else {
                                                int i,j;
                                                unsigned short c;
                                                c=RGB15_16(c0,c1);
                                                for(i=0;i<4;i++)for(j=0;j<4;j++)
                                                    *((unsigned short *)gm+(y-i)*pi->scr_width+x+j)=c;
                                            }
                                        }
                                        x+=4;
                                        if(x>=file.width) { 
                                            x=0;
                                            y-=4;
                                        }
                                    }
                                }
                                }
                                break;
                            case 5: { /* cvid, iv32 xanim binary codec */
                                XA_DEC2_INFO xadi;
                                int j,k;
    
                                xadi.cmd=0;
                                xadi.chdr=0;
                                xadi.map=0;
                                xadi.special=0;
                                xadi.skip_flag=0;
                                xadi.map_flag=0;
                                xadi.extra=0;
                                xadi.imagex=file.width;
                                xadi.imagey=file.height;
                                xadi.imaged=24;
                                xadi.image_type=1;
                                xadi.bytes_pixel=3;
                                if(framelen)
                                    codec.decoder(image,pi->playbuf+pi->skip,framelen,&xadi);
                                scr=gm;
                                ptr=image;
                                for(k=0;k<file.height;k++) {
                                    for (j=0;j<file.width;j++) {
                                        *scr++=((*(ptr+1)<<3)&0xe0)|((*(ptr+2)>>3)&0x1f);
                                        *scr++=(*(ptr)&0xf8)|((*(ptr+1)>>5)&0x07);
                                        ptr+=3;
                                    }
                                    scr+=(pi->scr_width-file.width)*2;
                                }   
                                }
                                break;                    
                            case 6:{ /* RLE8, quicktime */
                                int f, y, lasty, l;
                                unsigned short *p;
                        
                                l=pi->skip+4;
                        
                                p=(unsigned short *)gm;
                                f=(pi->playbuf[l]<<8)+pi->playbuf[l+1];
                                l+=2;
                        
                                if(f&0x0008) {
                                    y=(pi->playbuf[l]<<8)+pi->playbuf[l+1];
                                    l+=4;
                                    lasty=y+(pi->playbuf[l]<<8)+pi->playbuf[l+1];
                                    l+=4;
                                } else {
                                    lasty=0;
                                    y=file.height;
                                }
                                while(y<lasty) {
                                    int x,c;
                                    x=pi->playbuf[l++];
                                    if(x) {
                                        x--;
                                        x<<=2;
                                        c=pi->playbuf[l++];
                                        while(c!=0xff) {
                                            if(c==0) {
                                                x+=(pi->playbuf[l++]-1)<<2;
                                            } else if(c<0x80) {
                                                c<<=2;
                                                while(c--) {
                                                    *(p+pi->scr_width*y+x)=file.palette16[pi->playbuf[l++]];
                                                    x++;
                                                }
                                            } else {
                                                unsigned short c0,c1,c2,c3;
                                                c0=file.palette16[pi->playbuf[l++]];
                                                c1=file.palette16[pi->playbuf[l++]];
                                                c2=file.palette16[pi->playbuf[l++]];
                                                c3=file.palette16[pi->playbuf[l++]];                                        
                                                c=256-c;
                                                while(c--) {
                                                    *(p+pi->scr_width*y+x)=c0;
                                                    x++;
                                                    *(p+pi->scr_width*y+x)=c1;
                                                    x++;
                                                    *(p+pi->scr_width*y+x)=c2;
                                                    x++;
                                                    *(p+pi->scr_width*y+x)=c3;
                                                    x++;
                                                }
                                            }
                                            c=pi->playbuf[l++];
                                        }
                                    }
                                    y++;
                                }
                                }
                                break;
                            case 7: { /* mpeg */
                                int k;
                                unsigned char **p;
                        
                                p=(unsigned char **)pi->playbuf;
                                scr=gm;
                                for(k=0;k<file.height; k++) {
                                    memcpy(scr,p[k],file.width<<1);
                                    scr+=pi->scr_width<<1;
                                }
                                }
                                break;
                            case 8: {
                                int l, x, y;
                        
                                l=pi->skip+4;
                                x=0;
                                y=0;
                        
                                while(l<pi->skip+framelen) {
                                    int c;
                                    c=pi->playbuf[l++];
                                    if((c>=0xa0) && (c<=0xbf)) {
                                        unsigned short col;
                                        col=RGB15_16(pi->playbuf[l+1],pi->playbuf[l]);
                                        l+=2;
                                        while(c-->0x9f) {
                                            int i,j;
                                            for(i=0;i<4;i++)for(j=0;j<4;j++)
                                                *((unsigned short *)gm+(y+i)*pi->scr_width+x+j)=col;
                                            x+=4;
                                            if(x>=file.width) {
                                                x=0;
                                                y+=4;
                                            }
                                        }
                                    } else if((c>=0x80) && (c<=0x9f)) {
                                        while(c-->0x7f) {
                                            x+=4;
                                            if(x>=file.width) {
                                                x=0;
                                                y+=4;
                                            }
                                        }
                                    } else if((c<0x80) || ((c>=0xc0) && (c<=0xdf))) {
                                        unsigned short col0,col1,col2,col3;
                                        int bit;
                                        if(c>0x80) {
                                            col0=RGB15_16(pi->playbuf[l+1],pi->playbuf[l]);
                                            l+=2;
                                        } else {
                                            col0=RGB15_16(pi->playbuf[l],c);
                                            l++;
                                        }
                                        col1=RGB15_16(pi->playbuf[l+1],pi->playbuf[l]);
                                        bit=pi->playbuf[l]&0x80;
                                        l+=2;
                                        if(!bit && (c<0x80)) {
                                            unsigned short *p;
                                            int j;
                                            p=(unsigned short *)gm+y*pi->scr_width+x;
                                            col1&=0x00ffffff;
                                            col2=RGB15_16(pi->playbuf[l+1],pi->playbuf[l]);
                                            l+=2;
                                            col3=RGB15_16(pi->playbuf[l+1],pi->playbuf[l]);
                                            l+=2;
                                            *(p++)=col0;
                                            *(p++)=col1;
                                            *(p++)=col2;
                                            *p=col3;
                                            p+=pi->scr_width-3;
                                            for(j=0;j<3;j++) {
                                                col0=RGB15_16(pi->playbuf[l+1],pi->playbuf[l]);
                                                l+=2;
                                                col1=RGB15_16(pi->playbuf[l+1],pi->playbuf[l]);
                                                l+=2;
                                                col2=RGB15_16(pi->playbuf[l+1],pi->playbuf[l]);
                                                l+=2;
                                                col3=RGB15_16(pi->playbuf[l+1],pi->playbuf[l]);
                                                l+=2;
                                                *(p++)=col0;
                                                *(p++)=col1;
                                                *(p++)=col2;
                                                *p=col3;
                                                p+=pi->scr_width-3;
                                            }
                                            x+=4;
                                            if(x>=file.width) {
                                                x=0;
                                                y+=4;
                                            }
                                        } else {
                                            int n, m[4], i, j;
                                            unsigned short d[4], *p;
                                            d[3]=col0;
                                            d[0]=col1;
                                            d[1]=RGB16_2C1_C2(col1,col0);
                                            d[2]=RGB16_2C1_C2(col0,col1);
                                    
                                            if(c<0x80)n=1; else n=c-0xb0;
                                            while(n--) {
                                                m[0]=pi->playbuf[l++];
                                                m[1]=pi->playbuf[l++];
                                                m[2]=pi->playbuf[l++];
                                                m[3]=pi->playbuf[l++];
                                                p=(unsigned short *)gm+y*pi->scr_width+x;
                                                for(i=0;i<4;i++) {
                                                    for(j=0;j<4;j++) {
                                                        *p++=d[(m[i]&0xc0)>>6];
                                                        m[i]<<=2;
                                                    }
                                                    p+=pi->scr_width-4;
                                                }
                                                x+=4;
                                                if(x>=file.width) {
                                                    x=0;
                                                    y+=4;
                                                }
                                            }
                                        }
                                    }
                                }
                                }
                                break;
                        }
                        break;
                }
            }
            gettimeofday(&tv,NULL);
            j=(tv.tv_sec-start.tv_sec)*1000000+tv.tv_usec-start.tv_usec-frame_timepos;
            if(j<0)usleep(-j);
            if(file.us_frame && (j>=file.us_frame)) {
                i+=(j/file.us_frame);
                if(pi->verbose) {
                    fprintf(stderr,"skipping %i frames.\n",j/file.us_frame);
                }
                if(aplay) {
                    ioctl(a_fh, SNDCTL_DSP_SYNC, 0);
                }
            }
        }
        if(vplay==1) jpeg_destroy_decompress(&cinfo);
        free(pi->playbuf);
        free(image);
        if(aplay) fclose(a_file);
        if(vplay && !pi->novga) vga_setmode(TEXT);
    }
    return NULL;
}
