#include "playvideo.h"
#include <stdlib.h>
#include <string.h>
#include <quicktime.h>
#include "qtstdpal.h"

struct vid_idx {
    long long timepos;
    int duration;
};

struct qt_info {
    struct vid_idx *vidx;
    quicktime_t *p;
};

int qt_read_aframe(VIDEO_FILE *vf, unsigned char *buf, int frame) {
    quicktime_t *p;
    struct qt_info *q=vf->extra;
    int asize, pos;
    
    p=q->p;
 
    asize=(long long)vf->arate*vf->aformat*q->vidx[frame].duration/8000000;
    
    pos=(long long)vf->arate*q->vidx[frame].timepos/1000000;
    
    quicktime_set_audio_position(p,pos,0);
    quicktime_read_audio(p,buf,asize*8/vf->aformat,0);
    return asize;
}

int qt_read_vframe(VIDEO_FILE *vf, unsigned char *buf, int frame, int *len) {
    quicktime_t *p;
    struct qt_info *q=vf->extra;
    
    p=q->p;
    
    *len=quicktime_frame_size(p,frame,0);
    quicktime_set_video_position(p,frame,0);
    quicktime_read_frame(p,buf,0);
    return q->vidx[frame].timepos+q->vidx[frame].duration;
}


int qt_open_file(char *filename, VIDEO_FILE *vf, int verbose) {
    quicktime_t *p;
    struct qt_info *q;
    float hz;
    
    q=malloc(sizeof(struct qt_info));
    p=quicktime_open(filename,1,0);
    q->p=p;
    strncpy(vf->filename,filename,253);
    vf->extra=q;
    
    vf->hasaudio=quicktime_audio_tracks(p);
    vf->hasvideo=quicktime_video_tracks(p);

    vf->palette=0;
    q->vidx=0;
    
    hz=quicktime_frame_rate(p,0);
    
    vf->us_frame=(float)1000000/hz;
    
    if(vf->hasaudio) {
        vf->achannels=quicktime_track_channels(p,0);
        vf->arate=quicktime_sample_rate(p,0);
        vf->aformat=quicktime_audio_bits(p,0);
        vf->aframes=(long long)1000000*quicktime_audio_length(p,0)/vf->us_frame/vf->arate;
        vf->asize=(long long)vf->arate*vf->aformat*vf->us_frame/8000000;
    }
    if(vf->hasvideo) {
        char *c;
        int i,k;
        vf->vframes=quicktime_video_length(p,0);
        vf->width=quicktime_video_width(p,0);
        vf->height=quicktime_video_height(p,0);
        c=quicktime_video_compressor(p,0);
        vf->compression[0]=c[0];
        vf->compression[1]=c[1];
        vf->compression[2]=c[2];
        vf->compression[3]=c[3];
        vf->bitspp=-1;
        vf->colors=-1;
        i=0;
        while((i<16) && !p->moov.trak[i]->mdia.minf.is_video)i++;
        vf->bitspp=p->moov.trak[i]->mdia.minf.stbl.stsd.table->depth;
        if(vf->bitspp<9) { /* setup default palette */
            vf->palette=(int *)malloc(1024);
            for(i=0;i<256;i++) {
                vf->palette[i]=(qtstdpal[i*4]<<16) | (qtstdpal[i*4+1]<<8) | qtstdpal[i*4+2];
    	    }	
        } else vf->palette=0;
        q->vidx=malloc(sizeof(struct vid_idx)*vf->vframes);
        q->vidx[0].timepos=0;
        k=0;
        for(i=0;i<vf->vframes;) {
            int j=p->moov.trak[0]->mdia.minf.stbl.stts.table[k].sample_count;
            while(j--) {
                q->vidx[i].duration=p->moov.trak[0]->mdia.minf.stbl.stts.table[k].sample_duration*
                    1000000/p->moov.mvhd.time_scale;
                if(i)q->vidx[i].timepos=q->vidx[i-1].timepos+q->vidx[i-1].duration;
                i++;
            };
            k++;
        }
        vf->us_frame=0;
        vf->aframes=vf->vframes;
    }
    return 0;
}

int qt_check_file(char *filename) {
    return quicktime_check_sig(filename);
}

int qt_close_file(VIDEO_FILE *vf) {
    struct qt_info *q=vf->extra;
    if(vf->palette)free(vf->palette);
    if(q->vidx)free(q->vidx);
    quicktime_close(q->p);
    free(q);
}
