#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>
#include <pthread.h>
#include <vga.h>

#include "vidplay.h"

void
usage(char *prog)
{
    char *h;

    if (NULL != (h = strrchr(prog,'/')))
	prog = h+1;
    fprintf(stderr,
	    "\n"
	    "%s Plays video files.\n\n"
	    "usage:  %s [-h] [-m] [-d]"
            " [-p num] [-x address,width] [-s mode]"
            " [-l len] filename\n"
	    "\n"
            "\t-p num\t\tskip to frame num\n"
            "\t-l len\t\tnum of frames to play\n"
            "\t-m\t\tmute (don't play audio)\n"
            "\t-d\t\tdon't play video\n"
            "\t-s\t\tuse svgalib mode number\n"
            "\t-v\t\tbe more verbose\n"
            "\t-x\t\tdon't set vga mode, draw to framebuffer at given address with given width\n",
	    prog,prog);
}

int main (int argc, char **argv)
{
    int c;

    pthread_t th[4];
    void *res;
    
    play_info pi[4];
    
    int sx=0, sy=0;
    int scr_width=320;
    int scr_mode=G320x240x16M32;    
    char audiodev[128];
    unsigned int novga;    
    int playframe, len;
    int verbose;
    int noaudio, novideo;

    verbose=0;
    len=999999;
    playframe=0;
    noaudio=0;
    novideo=0;
    novga=0;
    
    strcpy(audiodev,"/dev/dsp");
    /* parse options */
    for (;;) {
        char *ptr;
	if (-1 == (c = getopt(argc, argv, "a:dhl:mo:p:s:vx:")))
	    break;
	switch (c) {
        case 'a':
            strncpy(audiodev,optarg,126);
	case 'd':
            novideo=1;
	    break;
	case 'l':
            len=atoi(optarg);
	    break;
	case 'm':
            noaudio=1;
	    break;
        case 'o':
            sx=strtoul(optarg,&ptr,0);
            if(*ptr==',')
                sy=strtoul(ptr+1,NULL,0);
            break;
	case 'p':
            playframe=atoi(optarg);
	    break;
	case 's':
            scr_mode=atoi(optarg);
	    break;
        case 'v':
            verbose=1;
            break;
        case 'x':
            novga=strtoul(optarg,&ptr,0);
            if(*ptr==',')
                scr_width=strtoul(ptr+1,NULL,0);
            break;
	case 'h':
	default:
	    usage(argv[0]);
	    exit(1);
	}
    }
    
    if (optind == argc) {
	usage(argv[0]);
	exit(1);
    }

    strncpy(pi[0].filename,argv[optind],254);
    strncpy(pi[0].audiodev,audiodev,254);
    pi[0].verbose=verbose;
    pi[0].noaudio=noaudio;
    pi[0].novideo=novideo;
    pi[0].playframe=playframe;
    pi[0].len=len;
    pi[0].novga=novga;
    pi[0].scr_width=scr_width;
    pi[0].scr_mode=scr_mode;
    pi[0].sx=sx;
    pi[0].sy=sy;

    pthread_create(&th[0],NULL,playvideo,&pi[0]);
    pthread_join(th[0],&res);
    return 0;
}
