#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>
#include <pthread.h>

#include <vga.h>
#include <jpeglib.h>
#include <sys/ioctl.h>
#include <linux/soundcard.h>

#include <dlfcn.h>

#include "playvideo.h"
#include "stdDHT.h"
#include "mod.h"
#include "avi_file.h"
#include "qt_file.h"
#include "ex_file.h"
#include "mpeg_file.h"

typedef struct {
    char filename[256];
    int verbose;
    int noaudio;
    int novideo;
    int playframe;
    int len;
    int novga;
    int scr_width;
    int scr_mode;
    char audiodev[256];
    int sx;
    int sy;
} play_info;

void *playvideo(void *);

void
usage(char *prog)
{
    char *h;

    if (NULL != (h = strrchr(prog,'/')))
	prog = h+1;
    fprintf(stderr,
	    "\n"
	    "%s Plays video files.\n\n"
	    "usage:  %s [-h] [-m] [-d]"
            " [-p num] [-x address,width] [-s mode]"
            " [-l len] filename\n"
	    "\n"
            "\t-p num\t\tskip to frame num\n"
            "\t-l len\t\tnum of frames to play\n"
            "\t-m\t\tmute (don't play audio)\n"
            "\t-d\t\tdon't play video\n"
            "\t-s\t\tuse svgalib mode number\n"
            "\t-v\t\tbe more verbose\n"
            "\t-x\t\tdon't set vga mode, draw to framebuffer at given address with given width\n",
	    prog,prog);
}

unsigned char *playbuf;
int skip;

void src_mgr_init(struct jpeg_decompress_struct *cinfo) {
    cinfo->src->next_input_byte=playbuf + skip;
    cinfo->src->bytes_in_buffer = 128*1024-skip;
}

void src_mgr_skip(struct jpeg_decompress_struct *cinfo, long num_bytes) {
    cinfo->src->next_input_byte+=num_bytes;
    cinfo->src->bytes_in_buffer -= num_bytes;
}

boolean src_mgr_resync(struct jpeg_decompress_struct *cinfo, int desired) {
    return TRUE;
}

boolean src_mgr_fill(struct jpeg_decompress_struct *cinfo) {
    return TRUE;
}

void src_mgr_term(struct jpeg_decompress_struct *cinfo) {
    return;
}

int main (int argc, char **argv)
{
    int c;

    pthread_t th[4];
    void *res;
    
    play_info pi[4];
    
    int sx=0, sy=0;
    int scr_width=320;
    int scr_mode=G320x240x16M32;    
    char audiodev[128];
    unsigned int novga;    
    int playframe, len;
    int verbose;
    int noaudio, novideo;

    verbose=0;
    len=999999;
    playframe=0;
    noaudio=0;
    novideo=0;
    novga=0;
    
    strcpy(audiodev,"/dev/dsp");
    /* parse options */
    for (;;) {
        char *ptr;
	if (-1 == (c = getopt(argc, argv, "a:dhl:mo:p:s:vx:")))
	    break;
	switch (c) {
        case 'a':
            strncpy(audiodev,optarg,126);
	case 'd':
            novideo=1;
	    break;
	case 'l':
            len=atoi(optarg);
	    break;
	case 'm':
            noaudio=1;
	    break;
        case 'o':
            sx=strtoul(optarg,&ptr,0);
            if(*ptr==',')
                sy=strtoul(ptr+1,NULL,0);
            break;
	case 'p':
            playframe=atoi(optarg);
	    break;
	case 's':
            scr_mode=atoi(optarg);
	    break;
        case 'v':
            verbose=1;
            break;
        case 'x':
            novga=strtoul(optarg,&ptr,0);
            if(*ptr==',')
                scr_width=strtoul(ptr+1,NULL,0);
            break;
	case 'h':
	default:
	    usage(argv[0]);
	    exit(1);
	}
    }
    
    if (optind == argc) {
	usage(argv[0]);
	exit(1);
    }

    strncpy(pi[0].filename,argv[optind],254);
    strncpy(pi[0].audiodev,audiodev,254);
    pi[0].verbose=verbose;
    pi[0].noaudio=noaudio;
    pi[0].novideo=novideo;
    pi[0].playframe=playframe;
    pi[0].len=len;
    pi[0].novga=novga;
    pi[0].scr_width=scr_width;
    pi[0].scr_mode=scr_mode;
    pi[0].sx=sx;
    pi[0].sy=sy;

    pthread_create(&th[0],NULL,playvideo,&pi[0]);
    pthread_join(th[0],&res);
    return 0;
}

void *playvideo(void *arg) {

    void *codec_module;
    XA_CODEC_HDR codec;
    VIDEO_FILE file;
    play_info *pi=(play_info *)arg;
    
    int (*open_file)(char *, VIDEO_FILE *, int);
    int (*read_vframe)(VIDEO_FILE *, unsigned char *, int, int *);
    int (*read_aframe)(VIDEO_FILE *, unsigned char *, int);

    if(ex_check_file(pi->filename)) {
        open_file=ex_open_file;
        read_vframe=ex_read_vframe;
        read_aframe=ex_read_aframe;
    } else if(qt_check_file(pi->filename)) {
        open_file=qt_open_file;
        read_vframe=qt_read_vframe;
        read_aframe=qt_read_aframe;
    } else if(mpeg_check_file(pi->filename)) {
        open_file=mpeg_open_file;
        read_vframe=mpeg_read_vframe;
        read_aframe=mpeg_read_aframe;
    } else if(avi_check_file(pi->filename)) {
        open_file=avi_open_file;
        read_vframe=avi_read_vframe;
        read_aframe=avi_read_aframe;
    } else {
        fprintf(stderr,"unrecognized format.\n");
        return (void *)-1;
    }

    open_file(pi->filename, &file, pi->verbose);

    if(pi->verbose) {
        fprintf(stderr,"width=%i\theight=%i\tus per frame=%i   %i frames\n"
               "compression=%c%c%c%c\n"
               "asize=%i\tarate=%i\tachannels=%i\n",
               file.width,file.height,file.us_frame,file.vframes,
               file.compression[0],
               file.compression[1],
               file.compression[2],
               file.compression[3],
               file.asize,file.arate,file.achannels
               );
    }

    playbuf=malloc(6*1024*1024);

    if((pi->playframe>-1) && (pi->len>-1)) {
        int i;
        struct timeval start, tv;
        unsigned char *image, *ptr, *scr, *gm;
        struct jpeg_decompress_struct cinfo;
        struct jpeg_error_mgr jerr;
        struct jpeg_source_mgr src_mgr;
        FILE *a_file;
        int a_fh;
        int aplay=0, vplay=0;
        
        if(pi->len+pi->playframe>file.vframes)pi->len=file.vframes-pi->playframe;

        if(!pi->noaudio && file.hasaudio && (file.aframes>0)) {
            aplay=1;
        }
        
        if(!pi->novideo && file.hasvideo && (file.vframes>0)) {
            switch(MAKE4CC(file.compression)) {
                case 0:
                    vplay=2;
                    break;
                case jpegtag:
                case MJPGtag:
                    vplay=1;
                    break;
                case CRAMtag:
                    if(file.bitspp==8) {
                        vplay=3;
                    }
                    if(file.bitspp==16)vplay=4;
                    break;
                case cvidtag: 
                case IV41tag:
                case iv31tag:
                case IV31tag:
                case IV32tag: {
                    XAVID_MOD_HDR *(*what_the)(), *mh;
                    vplay=5;
                    switch(MAKE4CC(file.compression)) {
                        case cvidtag:
                            codec_module=dlopen("/usr/local/xanim/mods/vid_cvid_2.0_linuxELFx86g21.xa",RTLD_LAZY);
                            break;
                        case iv31tag:
                        case IV31tag:
                        case IV32tag:
                            codec_module=dlopen("/usr/local/xanim/mods/vid_iv32_2.1_linuxELFx86g21.xa",RTLD_LAZY);
                            break;
                        case IV41tag:
                            codec_module=dlopen("/usr/local/xanim/mods/vid_iv41_1.0_linuxELFx86g21.xa",RTLD_LAZY);
                            break;
                        default:
                            fprintf(stderr,"Unsupported codec module.\n");
                            return (void *)-2;
                    }
                    what_the=dlsym(codec_module,"What_The");                    
    
                    mh=what_the();
                    codec.avi_ctab_flag=1;
                    codec.xapi_rev=2;
                    codec.compression=MAKECC4(file.compression);
                    codec.extra=0;
                    codec.depth=24;
                    codec.x=file.width;
                    codec.y=file.height;
                    codec.avi_read_ext=NULL;
                    mh->funcs->iq_func(&codec);
                    }
                    break;
                case rletag:
                    switch(file.bitspp) {
                        case 8:
                            vplay=6;
                            break;
                    }
                    break;
                case mpegtag:
                    vplay=7;    
                    break;
                case rpzatag:
                    if(file.bitspp==16)vplay=8;
                    break;
                default:
                    if(pi->verbose)fprintf(stderr,"Unknown video compression: %c%c%c%c  (0x%08x).\n",
                        file.compression[0],file.compression[1],file.compression[2],
                        file.compression[3],MAKE4CC(file.compression));
                    
            }
        }
        
        image=malloc(file.width*file.height*4+4096);

        if(aplay) {
            int j;
            a_file=fopen(pi->audiodev,"w");
            a_fh=fileno(a_file);
            ioctl(a_fh, SNDCTL_DSP_RESET, 0);
            
            switch(file.aformat&0xff) {
                case 4:
                    i=AFMT_IMA_ADPCM;
                    break;
                case 8:
                    i=AFMT_S8;
                    break;
                case 16:
                    i=AFMT_S16_LE;
                    break;
            }
            j=ioctl(a_fh, SNDCTL_DSP_SETFMT, &i);
            i=file.achannels-1;
            j=ioctl(a_fh, SNDCTL_DSP_STEREO, &i);
            i=file.arate;
            j=ioctl(a_fh, SNDCTL_DSP_SPEED, &i);
        }
        
        if(vplay) {
            if(vplay==1) {
                src_mgr.init_source=src_mgr_init;
                src_mgr.skip_input_data=src_mgr_skip;
                src_mgr.resync_to_restart=src_mgr_resync;
                src_mgr.fill_input_buffer=src_mgr_fill;
                src_mgr.term_source=src_mgr_term;
        
                cinfo.err=jpeg_std_error(&jerr);
                jpeg_create_decompress(&cinfo);
        
                cinfo.src=&src_mgr;
            }
            if(pi->novga) {
                gm=(unsigned char *)pi->novga;
            } else {
                vga_modeinfo *mi;
                vga_init();
                vga_setmode(pi->scr_mode);
                mi=vga_getmodeinfo(pi->scr_mode);
                pi->scr_width=mi->width;

                sleep(1);
                vga_setlinearaddressing();
                gm=vga_getgraphmem()+(pi->sy*pi->scr_width+pi->sx)*4;
            }
        }

        gettimeofday(&start,NULL);
        
        for(i=0;i<pi->len;i++) {
            int j;
            int ins, sawDHT;
            
            if(aplay) {
                read_aframe(&file, playbuf, i+pi->playframe);
                fwrite(playbuf,file.asize,1,a_file);
            }
            
            if(vplay) {
                int framelen;
                skip=432;
                if(vplay==7){
                    unsigned char **p=(unsigned char **)playbuf;
                    skip=0;
                    scr=playbuf+4096;
                    for(j=0;j<1024;j++) {
                        p[j]=scr;
                        scr+=4096;
                    }
                }

                read_vframe(&file, playbuf+skip, i+pi->playframe, &framelen);

                switch(vplay) {
                    case 1:
                        if((playbuf[432]==0xff) && (playbuf[433]==0xd8)) {
                            ins=0;
                            sawDHT=0;
                            j=434;
                            while( !ins && (j<framelen) ) {
                                if(playbuf[j]!=0xff) {
                                    ins=-1;
                                } else {
                                    switch(playbuf[j+1]) {
                                        case 0xc4:
                                            sawDHT=1;
                                            break;
                                        case 0xda:
                                            ins=j-432;
                                            break;
                                    }
                                    j+= playbuf[j+3] + (playbuf[j+2] << 8) + 2;
                                }
                            }
                            if((ins>0) && !sawDHT) {
                                memmove(playbuf,playbuf+432,ins);
                                memcpy(playbuf+ins,stdDHT,432);
                                skip=0;
                            }
                            jpeg_read_header(&cinfo,TRUE);
                            cinfo.out_color_space=JCS_RGB;
                            cinfo.dct_method=JDCT_IFAST;
                            cinfo.do_fancy_upsampling=FALSE;
                            jpeg_start_decompress(&cinfo);
                            ptr=image;
                            while(cinfo.output_scanline<cinfo.output_height) {
                                j=jpeg_read_scanlines(&cinfo,&ptr,1 /*cinfo.output_height*/);
                                ptr+=cinfo.output_width*3*j;
                            }
                            ptr=image;
                            scr=gm;
                            for(j=0;j<cinfo.output_height;j++) {
                                int k;
                                for(k=0;k<cinfo.output_width;k++) {
                                    *scr++=*(ptr+2);
                                    *scr++=*(ptr+1);
                                    *scr++=*ptr;
                                    scr++;
                                    ptr+=3;
                                }
                                scr+=(pi->scr_width-cinfo.output_width)*4;
                            }
                            jpeg_finish_decompress(&cinfo);
                        }
                        break;
                    case 2: {
                        int width, k, l;
                                                
                        l=skip;
                        scr=gm+pi->scr_width*4*(file.height-1);
                        width=((file.width-1) | 3) + 1;
                        switch(file.bitspp) {
                            case 8:
                                for(j=0;j<file.height; j++) {
                                    for(k=0;k<width;k++) {
                                        *(int *)scr=file.palette[playbuf[l++]];
                                        scr+=4;
                                    }
                                    scr-=(pi->scr_width+width)*4;
                                }
                                break;
                            case 16:
                                for(j=0;j<file.height; j++) {
                                    for(k=0;k<width;k++) {
                                        *(int *)(scr)=((playbuf[l]&0x1f)<<3) | ((playbuf[l]&0xe0)<<6) | 
                                             ((playbuf[l+1]&0x03)<<14) | ((playbuf[l+1]&0x7c)<<17);
                                        l+=2;
                                        scr+=4;
                                    }
                                    scr-=(pi->scr_width+width)*4;
                                }
                        }
                        }
                        break;
                    case 3: {/* CRAM8 */
                        int x, y, cont=1, blocks, l;
                        
                        l=skip;
                        y=file.height-1;
                        x=0;
                        blocks=file.height*file.width/16+1;
                        while(cont) {
                            int c0,c1;
                            
                            c0=playbuf[l++];
                            c1=playbuf[l++];
                            blocks--;
                            if(( !c0 && !c1 && !blocks)||(y<0)) cont=0; else {
                                if((c1>=0x84)&&(c1<=0x87)) {
                                    int k;
                                    k=((c1-0x84)<<8)+c0;
                                    blocks-=k-1;
                                    while(--k) {
                                        x+=4;
                                        if(x>=file.width) { 
                                            x=0;
                                            y-=4;
                                        }
                                    }
                                } else {
                                    if(c1>=0x90) {
                                        int col0,col1,col2,col3;
                                        int *p;
                                        
                                        p=(int *)gm+y*pi->scr_width+x;

                                        col1=file.palette[playbuf[l++]];
                                        col0=file.palette[playbuf[l++]];
                                        col3=file.palette[playbuf[l++]];
                                        col2=file.palette[playbuf[l++]];
                                        
                                        *(p++)=c0&0x01?col1:col0;
                                        *(p++)=c0&0x02?col1:col0;
                                        *(p++)=c0&0x04?col3:col2;
                                        *p=c0&0x08?col3:col2;
                                        p-=pi->scr_width+3;
                                        *(p++)=c0&0x10?col1:col0;
                                        *(p++)=c0&0x20?col1:col0;
                                        *(p++)=c0&0x40?col3:col2;
                                        *p=c0&0x80?col3:col2;
                                        p-=pi->scr_width+3;

                                        col1=file.palette[playbuf[l++]];
                                        col0=file.palette[playbuf[l++]];
                                        col3=file.palette[playbuf[l++]];
                                        col2=file.palette[playbuf[l++]];
                                        
                                        *(p++)=c1&0x01?col1:col0;
                                        *(p++)=c1&0x02?col1:col0;
                                        *(p++)=c1&0x04?col3:col2;
                                        *p=c1&0x08?col3:col2;
                                        p-=pi->scr_width+3;
                                        *(p++)=c1&0x10?col1:col0;
                                        *(p++)=c1&0x20?col1:col0;
                                        *(p++)=c1&0x40?col3:col2;
                                        *p=c1&0x80?col3:col2;
                                    } else if (c1<0x80) {
                                        int col0,col1,i,j;
                                        col1=file.palette[playbuf[l++]];
                                        col0=file.palette[playbuf[l++]];
                                        for(i=0;i<2;i++)for(j=0;j<4;j++) {
                                            *((int *)gm+(y-i)*pi->scr_width+x+j)=c0&1?col1:col0;
                                            c0>>=1;
                                        }
                                        for(i=2;i<4;i++)for(j=0;j<4;j++) {
                                            *((int *)gm+(y-i)*pi->scr_width+x+j)=c1&1?col1:col0;
                                            c1>>=1;
                                        }
                                    } else {
                                        int i,j;
                                        for(i=0;i<4;i++)for(j=0;j<4;j++)
                                            *((int *)gm+(y-i)*pi->scr_width+x+j)=file.palette[c0];
                                    }
                                }
                                x+=4;
                                if(x>=file.width) { 
                                    x=0;
                                    y-=4;
                                }
                            }
                        }
                        }
                        break;
                    case 4: {/* CRAM16 */
                        int x, y, cont=1, blocks, l;
                        
                        l=skip;
                        y=file.height-1;
                        x=0;
                        blocks=file.height*file.width/16+1;
                        while(cont) {
                            int c0,c1;
                            
                            c0=playbuf[l++];
                            c1=playbuf[l++];
                            blocks--;
                            if(( !c0 && !c1 && !blocks)||(y<0)) cont=0; else {
                                if((c1>=0x84)&&(c1<=0x87)) {
                                    int k;
                                    k=((c1-0x84)<<8)+c0;
                                    blocks-=k-1;
                                    while(--k) {
                                        x+=4;
                                        if(x>=file.width) { 
                                            x=0;
                                            y-=4;
                                        }
                                    }
                                } else {
                                    if(c1<0x80) {
                                        int col0,col1;
                                        col1=((playbuf[l]&0x1f)<<3) | ((playbuf[l]&0xe0)<<6) | 
                                             ((playbuf[l+1]&0x03)<<14) | ((playbuf[l+1]&0xfc)<<17);
                                        l+=2;
                                        col0=((playbuf[l]&0x1f)<<3) | ((playbuf[l]&0xe0)<<6) | 
                                             ((playbuf[l+1]&0x03)<<14) | ((playbuf[l+1]&0x7c)<<17);
                                        l+=2;
                                        if(col1&0x1000000) {
                                            int *p;
                                            int col2,col3;
                                        
                                            p=(int *)gm+y*pi->scr_width+x;
                                            col1&=0x00ffffff;
                                            col3=((playbuf[l]&0x1f)<<3) | ((playbuf[l]&0xe0)<<6) | 
                                                 ((playbuf[l+1]&0x03)<<14) | ((playbuf[l+1]&0x7c)<<17);
                                            l+=2;
                                            col2=((playbuf[l]&0x1f)<<3) | ((playbuf[l]&0xe0)<<6) | 
                                                 ((playbuf[l+1]&0x03)<<14) | ((playbuf[l+1]&0x7c)<<17);
                                            l+=2;
                                            *(p++)=c0&0x01?col1:col0;
                                            *(p++)=c0&0x02?col1:col0;
                                            *(p++)=c0&0x04?col3:col2;
                                            *p=c0&0x08?col3:col2;
                                            p-=pi->scr_width+3;
                                            *(p++)=c0&0x10?col1:col0;
                                            *(p++)=c0&0x20?col1:col0;
                                            *(p++)=c0&0x40?col3:col2;
                                            *p=c0&0x80?col3:col2;
                                            p-=pi->scr_width+3;
    
                                            col1=((playbuf[l]&0x1f)<<3) | ((playbuf[l]&0xe0)<<6) | 
                                                 ((playbuf[l+1]&0x03)<<14) | ((playbuf[l+1]&0x7c)<<17);
                                            l+=2;
                                            col0=((playbuf[l]&0x1f)<<3) | ((playbuf[l]&0xe0)<<6) | 
                                                 ((playbuf[l+1]&0x03)<<14) | ((playbuf[l+1]&0x7c)<<17);
                                            l+=2;
                                            col3=((playbuf[l]&0x1f)<<3) | ((playbuf[l]&0xe0)<<6) | 
                                                 ((playbuf[l+1]&0x03)<<14) | ((playbuf[l+1]&0x7c)<<17);
                                            l+=2;
                                            col2=((playbuf[l]&0x1f)<<3) | ((playbuf[l]&0xe0)<<6) | 
                                                 ((playbuf[l+1]&0x03)<<14) | ((playbuf[l+1]&0x7c)<<17);
                                            l+=2;
                                            *(p++)=c1&0x01?col1:col0;
                                            *(p++)=c1&0x02?col1:col0;
                                            *(p++)=c1&0x04?col3:col2;
                                            *p=c1&0x08?col3:col2;
                                            p-=pi->scr_width+3;
                                            *(p++)=c1&0x10?col1:col0;
                                            *(p++)=c1&0x20?col1:col0;
                                            *(p++)=c1&0x40?col3:col2;
                                            *p=c1&0x80?col3:col2;
                                        } else {
                                            int i,j;
                                            for(i=0;i<2;i++)for(j=0;j<4;j++) {
                                                *((int *)gm+(y-i)*pi->scr_width+x+j)=c0&1?col1:col0;
                                                c0>>=1;
                                            }
                                            for(i=2;i<4;i++)for(j=0;j<4;j++) {
                                                *((int *)gm+(y-i)*pi->scr_width+x+j)=c1&1?col1:col0;
                                                c1>>=1;
                                            }
                                            
                                        }
                                    } else {
                                        int i,j,c;
                                        c=((c0&0x1f)<<3) | ((c0&0xe0)<<6) | ((c1&0x03)<<14) | ((c1&0x7c)<<17);
                                        for(i=0;i<4;i++)for(j=0;j<4;j++)
                                            *((int *)gm+(y-i)*pi->scr_width+x+j)=c;
                                    }
                                }
                                x+=4;
                                if(x>=file.width) { 
                                    x=0;
                                    y-=4;
                                }
                            }
                        }
                        }
                        break;
                    case 5: { /* cvid, iv32 xanim binary codec */
                        XA_DEC2_INFO xadi;
                        int j,k;

                        xadi.cmd=0;
                        xadi.chdr=0;
                        xadi.map=0;
                        xadi.special=0;
                        xadi.skip_flag=0;
                        xadi.map_flag=0;
                        xadi.extra=0;
                        xadi.imagex=file.width;
                        xadi.imagey=file.height;
                        xadi.imaged=24;
                        xadi.image_type=1;
                        xadi.bytes_pixel=3;
                        if(framelen)
                            codec.decoder(image,playbuf+skip,framelen,&xadi);
                        scr=gm;
                        ptr=image;
                        for(k=0;k<file.height;k++) {
                            for (j=0;j<file.width;j++) {
                                *(scr+2)=*ptr++;
                                *(scr+1)=*ptr++;
                                *scr=*ptr++;
                                scr+=4;
                            }
                            scr+=(pi->scr_width-file.width)*4;
                        }   
                        }
                        break;                    
                    case 6:{ /* RLE8, quicktime */
                        int f, y, lasty, l;
                        int *p;
                        
                        l=skip+4;
                        
                        p=(int *)gm;
                        f=(playbuf[l]<<8)+playbuf[l+1];
                        l+=2;
                        
                        if(f&0x0008) {
                            y=(playbuf[l]<<8)+playbuf[l+1];
                            l+=4;
                            lasty=y+(playbuf[l]<<8)+playbuf[l+1];
                            l+=4;
                        } else {
                            lasty=0;
                            y=file.height;
                        }
                        while(y<lasty) {
                            int x,c;
                            x=playbuf[l++];
                            if(x) {
                                x--;
                                x<<=2;
                                c=playbuf[l++];
                                while(c!=0xff) {
                                    if(c==0) {
                                        x+=(playbuf[l++]-1)<<2;
                                    } else if(c<0x80) {
                                        c<<=2;
                                        while(c--) {
                                            *(p+pi->scr_width*y+x)=file.palette[playbuf[l++]];
                                            x++;
                                        }
                                    } else {
                                        int c0,c1,c2,c3;
                                        c0=file.palette[playbuf[l++]];
                                        c1=file.palette[playbuf[l++]];
                                        c2=file.palette[playbuf[l++]];
                                        c3=file.palette[playbuf[l++]];                                        
                                        c=256-c;
                                        while(c--) {
                                            *(p+pi->scr_width*y+x)=c0;
                                            x++;
                                            *(p+pi->scr_width*y+x)=c1;
                                            x++;
                                            *(p+pi->scr_width*y+x)=c2;
                                            x++;
                                            *(p+pi->scr_width*y+x)=c3;
                                            x++;
                                        }
                                    }
                                    c=playbuf[l++];
                                }
                            }
                            y++;
                        }
                        }
                        break;
                    case 7: {
                        int k;
                        unsigned char **p;
                        
                        p=(unsigned char **)playbuf;
                        scr=gm;
                        for(k=0;k<file.height; k++) {
                            memcpy(scr,p[k],file.width<<2);
                            scr+=pi->scr_width<<2;
                        }
                        }
                        break;
                    case 8: {
                        int l, x, y;
                        
                        l=skip+4;
                        x=0;
                        y=0;
                        
                        while(l<skip+framelen) {
                            int c;
                            c=playbuf[l++];
                            if((c>=0xa0) && (c<=0xbf)) {
                                int col;
                                col=((playbuf[l+1]&0x1f)<<3) | ((playbuf[l+1]&0xe0)<<6) | 
                                     ((playbuf[l]&0x03)<<14) | ((playbuf[l]&0x7c)<<17);
                                l+=2;
                                while(c-->0x9f) {
                                    int i,j;
                                    for(i=0;i<4;i++)for(j=0;j<4;j++)
                                        *((int *)gm+(y+i)*pi->scr_width+x+j)=col;
                                    x+=4;
                                    if(x>=file.width) {
                                        x=0;
                                        y+=4;
                                    }
                                }
                            } else if((c>=0x80) && (c<=0x9f)) {
                                while(c-->0x7f) {
                                    x+=4;
                                    if(x>=file.width) {
                                        x=0;
                                        y+=4;
                                    }
                                }
                            } else if((c<0x80) || ((c>=0xc0) && (c<=0xdf))) {
                                int col0,col1,col2,col3;
                                if(c>0x80) {
                                    col0=((playbuf[l+1]&0x1f)<<3) | ((playbuf[l+1]&0xe0)<<6) | 
                                         ((playbuf[l]&0x03)<<14) | ((playbuf[l]&0x7c)<<17);
                                    l+=2;
                                } else {
                                    col0=((playbuf[l]&0x1f)<<3) | ((playbuf[l]&0xe0)<<6) | 
                                         ((c&0x03)<<14) | ((c&0x7c)<<17);
                                    l++;
                                }
                                col1=((playbuf[l+1]&0x1f)<<3) | ((playbuf[l+1]&0xe0)<<6) | 
                                     ((playbuf[l]&0x03)<<14) | ((playbuf[l]&0xfc)<<17);
                                l+=2;
                                if(!(col1&0x1000000) && (c<0x80)) {
                                    int *p;
                                    int(j);
                                    p=(int *)gm+y*pi->scr_width+x;
                                    col1&=0x00ffffff;
                                    col2=((playbuf[l+1]&0x1f)<<3) | ((playbuf[l+1]&0xe0)<<6) | 
                                         ((playbuf[l]&0x03)<<14) | ((playbuf[l]&0x7c)<<17);
                                    l+=2;
                                    col3=((playbuf[l+1]&0x1f)<<3) | ((playbuf[l+1]&0xe0)<<6) | 
                                         ((playbuf[l]&0x03)<<14) | ((playbuf[l]&0x7c)<<17);
                                    l+=2;
                                    *(p++)=col0;
                                    *(p++)=col1;
                                    *(p++)=col2;
                                    *p=col3;
                                    p+=pi->scr_width-3;
                                    for(j=0;j<3;j++) {
                                        col0=((playbuf[l+1]&0x1f)<<3) | ((playbuf[l+1]&0xe0)<<6) | 
                                             ((playbuf[l]&0x03)<<14) | ((playbuf[l]&0x7c)<<17);
                                        l+=2;
                                        col1=((playbuf[l+1]&0x1f)<<3) | ((playbuf[l+1]&0xe0)<<6) | 
                                             ((playbuf[l]&0x03)<<14) | ((playbuf[l]&0x7c)<<17);
                                        l+=2;
                                        col2=((playbuf[l+1]&0x1f)<<3) | ((playbuf[l+1]&0xe0)<<6) | 
                                             ((playbuf[l]&0x03)<<14) | ((playbuf[l]&0x7c)<<17);
                                        l+=2;
                                        col3=((playbuf[l+1]&0x1f)<<3) | ((playbuf[l+1]&0xe0)<<6) | 
                                             ((playbuf[l]&0x03)<<14) | ((playbuf[l]&0x7c)<<17);
                                        l+=2;
                                        *(p++)=col0;
                                        *(p++)=col1;
                                        *(p++)=col2;
                                        *p=col3;
                                        p+=pi->scr_width-3;
                                    }
                                    x+=4;
                                    if(x>=file.width) {
                                        x=0;
                                        y+=4;
                                    }
                                } else {
                                    int n, m[4], d[4], i,j, *p;
                                    
                                    d[3]=col0;
                                    d[0]=col1;
                                    d[1]=((21*(col0&0xff)+43*(col1&0xff))>>6)&0xff;
                                    d[1]|=((21*(col0&0xff00)+43*(col1&0xff00))>>6)&0xff00;
                                    d[1]|=((21*(col0&0xff0000)+43*(col1&0xff0000))>>6)&0xff0000;
                                    d[2]=((21*(col1&0xff)+43*(col0&0xff))>>6)&0xff;
                                    d[2]|=((21*(col1&0xff00)+43*(col0&0xff00))>>6)&0xff00;
                                    d[2]|=((21*(col1&0xff0000)+43*(col0&0xff0000))>>6)&0xff0000;
                                    
                                    if(c<0x80)n=1; else n=c-0xb0;
                                    while(n--) {
                                        m[0]=playbuf[l++];
                                        m[1]=playbuf[l++];
                                        m[2]=playbuf[l++];
                                        m[3]=playbuf[l++];
                                        p=(int *)gm+y*pi->scr_width+x;
                                        for(i=0;i<4;i++) {
                                            for(j=0;j<4;j++) {
                                                *p++=d[(m[i]&0xc0)>>6];
                                                m[i]<<=2;
                                            }
                                            p+=pi->scr_width-4;
                                        }
                                        x+=4;
                                        if(x>=file.width) {
                                            x=0;
                                            y+=4;
                                        }
                                    }
                                }
                            }
                        }
                        }
                        break;
                }
            }
            gettimeofday(&tv,NULL);
            j=(tv.tv_sec-start.tv_sec)*1000000+tv.tv_usec-start.tv_usec-(i+1)*file.us_frame;
            if(j<0)usleep(-j);
            if(j>=file.us_frame) {
                i+=(j/file.us_frame);
                if(aplay) {
                    ioctl(a_fh, SNDCTL_DSP_SYNC, 0);
                }
            }
        }
        if(vplay==1) jpeg_destroy_decompress(&cinfo);
        free(playbuf);
        free(image);
        if(aplay) fclose(a_file);
        if(vplay && !pi->novga) vga_setmode(TEXT);
    }
    return NULL;
}
