#include <stdio.h>
#include "playvideo.h"
#include <mpeg3.h>
#include <string.h>

static int lastframe;
static int lastvframe;

int mpeg_read_aframe(VIDEO_FILE *vf, unsigned char *buf, int frame) {
    mpeg3_t *p;
    p=vf->extra;
    
#ifndef NOMPEGSEEK
    if(++lastframe!=frame) {
    	mpeg3_set_sample(p,frame*vf->asize/2,0);
	lastframe=frame;
    }
#endif
    mpeg3_read_audio(p,NULL,(short *)buf,0,vf->asize/2,0);

    return vf->asize;
}

int mpeg_read_vframe(VIDEO_FILE *vf, unsigned char *buf, int frame, int *len) {
    mpeg3_t *p;
    unsigned char **c;
    p=vf->extra;
    c=(unsigned char **)buf;

#ifndef NOMPEGSEEK
    if(++lastvframe!=frame) {
        mpeg3_set_frame(p,frame,0);
	lastvframe=frame;
    }
#endif
    return mpeg3_read_frame(p,c,0,0,vf->width,vf->height,vf->width,vf->height,vf->param,0);
}


int mpeg_open_file(char *filename, VIDEO_FILE *vf, int verbose) {
    mpeg3_t *p;
    float hz;
    
    lastframe=-1;
    lastvframe=-1;
    p=mpeg3_open(filename);
    strncpy(vf->filename,filename,253);
    vf->extra=p;
    
    vf->hasaudio=mpeg3_has_audio(p);
    vf->hasvideo=mpeg3_has_video(p);
    
    hz=mpeg3_frame_rate(p,0);
    
    vf->us_frame=(float)1000000/hz;
    
    if(vf->hasvideo && (vf->us_frame==1000000))vf->us_frame=41666;

    if(vf->hasaudio) {
        vf->achannels=mpeg3_audio_channels(p,0);
        vf->arate=mpeg3_sample_rate(p,0);
        vf->aformat=16;
        vf->aframes=(long long)1000000*mpeg3_audio_samples(p,0)/vf->us_frame/vf->arate;
        vf->asize=(long long)vf->arate*vf->us_frame/500000;
        if(verbose) {
            fprintf(stderr,"audio streams:%i, channels in stream 0:%i\n",mpeg3_total_astreams(p),vf->achannels);
        }
    }
    if(vf->hasvideo) {
        vf->vframes=mpeg3_video_frames(p,0);
	if(vf->vframes<2) {
            vf->vframes=1048576;
        }
        vf->width=mpeg3_video_width(p,0);
        vf->height=mpeg3_video_height(p,0);
        vf->compression[0]='m';
        vf->compression[1]='p';
        vf->compression[2]='e';
        vf->compression[3]='g';
        vf->bitspp=-1;
        vf->colors=-1;
        if(verbose) {
            fprintf(stderr,"video streams:%i\n",mpeg3_total_vstreams(p));
        }
    }
    return 0;
}

int mpeg_check_file(char *filename) {
    return mpeg3_check_sig(filename);
}

int mpeg_close_file(VIDEO_FILE *vf) {
    mpeg3_close(vf->extra);
}
