#include "libvga.h"

unsigned char *VGAMap;

int __svgalib_mm_inmisc(void)
{
   return *((unsigned char *)VGAMap+MIS_R);
}

void __svgalib_mm_outmisc(int i)
{
   *((unsigned char *)VGAMap+MIS_W) = i;
}

int __svgalib_mm_incrtc(int i)
{
   *((unsigned char *)VGAMap+__svgalib_CRT_I)=i;
   return *((unsigned char *)VGAMap+__svgalib_CRT_D);
}

void __svgalib_mm_outcrtc(int i, int d)
{
   *((unsigned char *)VGAMap+__svgalib_CRT_I)=i;
   *((unsigned char *)VGAMap+__svgalib_CRT_D)=d;
}

int __svgalib_mm_inseq(int index)
{
   *((unsigned char *)VGAMap+SEQ_I)=index;
   return *((unsigned char *)VGAMap+SEQ_D);
}

void __svgalib_mm_outseq(int index, int val)
{
   *((unsigned char *)VGAMap+SEQ_I)=index;
   *((unsigned char *)VGAMap+SEQ_D)=val;
}

int __svgalib_mm_ingra(int index)
{
   *((unsigned char *)VGAMap+GRA_I)=index;
   return *((unsigned char *)VGAMap+GRA_D);
}

void __svgalib_mm_outgra(int index, int val)
{
   *((unsigned char *)VGAMap+GRA_I)=index;
   *((unsigned char *)VGAMap+GRA_D)=val;
}

int __svgalib_mm_inis1(void)
{
    return *((unsigned char *)VGAMap+__svgalib_IS1_R);
   return inb(__svgalib_IS1_R);
}

int __svgalib_mm_inatt(int index)
{
    __svgalib_mm_inis1();
    *((unsigned char *)VGAMap+ATT_IW)=index;
    return *((unsigned char *)VGAMap+ATT_R);
}

void __svgalib_mm_outatt(int index, int val)
{
    __svgalib_mm_inis1();
    *((unsigned char *)VGAMap+ATT_IW)=index;
    *((unsigned char *)VGAMap+ATT_IW)=val;
}

void __svgalib_mm_attscreen(int i)
{
    __svgalib_mm_inis1();
    *((unsigned char *)VGAMap+ATT_IW)=i;
}

void __svgalib_mm_inpal(int i, int *r, int *g, int *b)
{
    *((unsigned char *)VGAMap+PEL_IR)=i;
    *r=*((unsigned char *)VGAMap+PEL_D);
    *g=*((unsigned char *)VGAMap+PEL_D);
    *b=*((unsigned char *)VGAMap+PEL_D);
}

void __svgalib_mm_outpal(int i, int r, int g, int b)
{
    *((unsigned char *)VGAMap+PEL_IW)=i;
    *((unsigned char *)VGAMap+PEL_D)=r;
    *((unsigned char *)VGAMap+PEL_D)=g;
    *((unsigned char *)VGAMap+PEL_D)=b;
}

void mm_io_mapio(void)
{
    __svgalib_inmisc=__svgalib_mm_inmisc;
    __svgalib_outmisc=__svgalib_mm_outmisc;
    __svgalib_incrtc=__svgalib_mm_incrtc;
    __svgalib_outcrtc=__svgalib_mm_outcrtc;
    __svgalib_inseq=__svgalib_mm_inseq;
    __svgalib_outseq=__svgalib_mm_outseq;
    __svgalib_ingra=__svgalib_mm_ingra;
    __svgalib_outgra=__svgalib_mm_outgra;
    __svgalib_inatt=__svgalib_mm_inatt;
    __svgalib_outatt=__svgalib_mm_outatt;
    __svgalib_attscreen=__svgalib_mm_attscreen;
    __svgalib_inis1=__svgalib_mm_inis1;
    __svgalib_inpal=__svgalib_mm_inpal;
    __svgalib_outpal=__svgalib_mm_outpal;
}
