#include <sys/ioctl.h>
#include "svgalib_helper.h"
#include "libvga.h"

void port_out(int value, int port)
{
    io_t iov;
    
    iov.val=value;
    iov.port=port;
    ioctl(__svgalib_mem_fd,SVGALIB_HELPER_IOCSOUTB,&iov);
}

void port_outw(int value, int port)
{
    io_t iov;
    
    iov.val=value;
    iov.port=port;
    ioctl(__svgalib_mem_fd,SVGALIB_HELPER_IOCSOUTW,&iov);
}

void port_outl(int value, int port)
{
    io_t iov;
    
    iov.val=value;
    iov.port=port;
    ioctl(__svgalib_mem_fd,SVGALIB_HELPER_IOCSOUTL,&iov);
}

int port_in(int port)
{
    io_t iov;
    
    iov.port=port;
    ioctl(__svgalib_mem_fd,SVGALIB_HELPER_IOCGINB,&iov);

    return iov.val;
}

int port_inw(int port)
{
    io_t iov;
    
    iov.port=port;
    ioctl(__svgalib_mem_fd,SVGALIB_HELPER_IOCGINW,&iov);

    return iov.val;
}

int port_inl(int port)
{
    io_t iov;
    
    iov.port=port;
    ioctl(__svgalib_mem_fd,SVGALIB_HELPER_IOCGINL,&iov);

    return iov.val;
}

