#include "libvga.h"
#include <stdio.h>

int __svgalib_sis_inmisc(void)
{
   return inb(MIS_R+sis_io);
}

void __svgalib_sis_outmisc(int i)
{
   outb(MIS_W+sis_io,i);
}

int __svgalib_sis_incrtc(int i)
{
   outb(__svgalib_CRT_I+sis_io,i);
   return inb(__svgalib_CRT_D+sis_io);
}

void __svgalib_sis_outcrtc(int i, int d)
{
    outb(__svgalib_CRT_I+sis_io, i);
    outb(__svgalib_CRT_D+sis_io, d);
}

int __svgalib_sis_inseq(int index)
{
    outb(SEQ_I+sis_io, index);
    return inb(SEQ_D+sis_io);
}

void __svgalib_sis_outseq(int index, int val)
{
    outb(SEQ_I+sis_io, index);
    outb(SEQ_D+sis_io, val);
}

int __svgalib_sis_ingra(int index)
{
    outb(GRA_I+sis_io, index);
    return inb(GRA_D+sis_io);
}

void __svgalib_sis_outgra(int index, int val)
{
    outb(GRA_I+sis_io, index);
    outb(GRA_D+sis_io, val);
}

int __svgalib_sis_inis1(void)
{
   return inb(__svgalib_IS1_R+sis_io);
}

#ifdef NO_DELAY

int __svgalib_sis_inatt(int index)
{
    __svgalib_sis_inis1();
    outb(ATT_IW+sis_io, index);
    return inb(ATT_R+sis_io);
}

void __svgalib_sis_outatt(int index, int val)
{
    __svgalib_sis_inis1();
    outb(ATT_IW+sis_io, index);
    outb(ATT_IW+sis_io, val);
}

void __svgalib_sis_attscreen(int i)
{
    __svgalib_sis_inis1();
    outb(ATT_IW+sis_io, i);
}

void __svgalib_sis_inpal(int i, int *r, int *g, int *b)
{
    outb(PEL_IR+sis_io,i);
    *r=inb(PEL_D+sis_io);
    *g=inb(PEL_D+sis_io);
    *b=inb(PEL_D+sis_io);
}

void __svgalib_sis_outpal(int i, int r, int g, int b)
{

    outb(PEL_IW+sis_io,i);
    outb(PEL_D+sis_io,r);
    outb(PEL_D+sis_io,g);
    outb(PEL_D+sis_io,b);
}

#else /* NO_DELAY */

int __svgalib_sis_inatt(int index)
{
    __svgalib_delay();
    __svgalib_sis_inis1();
    __svgalib_delay();
    outb(ATT_IW+sis_io, index);
    __svgalib_delay();
    return inb(ATT_R+sis_io);
}

void __svgalib_sis_outatt(int index, int val)
{
    __svgalib_delay();
    __svgalib_sis_inis1();
    __svgalib_delay();
    outb(ATT_IW+sis_io, index);
    __svgalib_delay();
    outb(ATT_IW+sis_io, val);
}

void __svgalib_sis_attscreen(int i)
{
    __svgalib_delay();
    __svgalib_sis_inis1();
    __svgalib_delay();
    outb(ATT_IW+sis_io, i);
}

void __svgalib_sis_inpal(int i, int *r, int *g, int *b)
{
    outb(PEL_IR+sis_io,i);
    __svgalib_delay();
    *r=inb(PEL_D+sis_io);
    __svgalib_delay();
    *g=inb(PEL_D+sis_io);
    __svgalib_delay();
    *b=inb(PEL_D+sis_io);
}

void __svgalib_sis_outpal(int i, int r, int g, int b)
{

    outb(PEL_D+sis_io,i);
    __svgalib_delay();
    outb(PEL_D+sis_io,r);
    __svgalib_delay();
    outb(PEL_D+sis_io,g);
    __svgalib_delay();
    outb(PEL_D+sis_io,b);
}

#endif /* NO_DELAY */

static void sis_mapio(void)
{
    __svgalib_inmisc=__svgalib_sis_inmisc;
    __svgalib_outmisc=__svgalib_sis_outmisc;
    __svgalib_incrtc=__svgalib_sis_incrtc;
    __svgalib_outcrtc=__svgalib_sis_outcrtc;
    __svgalib_inseq=__svgalib_sis_inseq;
    __svgalib_outseq=__svgalib_sis_outseq;
    __svgalib_ingra=__svgalib_sis_ingra;
    __svgalib_outgra=__svgalib_sis_outgra;
    __svgalib_inatt=__svgalib_sis_inatt;
    __svgalib_outatt=__svgalib_sis_outatt;
    __svgalib_attscreen=__svgalib_sis_attscreen;
    __svgalib_inis1=__svgalib_sis_inis1;
    __svgalib_inpal=__svgalib_sis_inpal;
    __svgalib_outpal=__svgalib_sis_outpal;
}

