#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include "endianess.h"
#include "libvga.h"
#include "svgalib_helper.h"

int __svgalib_pci_idev=0;

int __svgalib_pci_read_config_dword(int pos, int address);

static int proc_pci_read_config(int device, unsigned long *buf, int size)
{
   int i;

   for(i=0;i<size;i++) {
       buf[i]=__svgalib_pci_read_config_dword(device, i*4);
   }
   return 0;
};

/* 
   find a vga device of the specified vendor, and return
   its configuration (64 dwords) in conf 
   return zero if device found.
*/ 

int __svgalib_pci_find_vendor_vga(unsigned int vendor, unsigned long *conf, int cont)
{ unsigned long buf[64];
  int device;
  int s, f, step;

#if NOHELPER 
  step = 8; /* only one function per device */
  if(__svgalib_pci_idev) {
      s=__svgalib_pci_idev;
      f=__svgalib_pci_idev+1;
  } else {
      s=0;
      f=1024;
  }
#else
  step=1;
  if(__svgalib_pci_idev) {
      s=__svgalib_pci_idev;
      f=__svgalib_pci_idev+1;
  } else {
      s=1;
      f=17;
  }
#endif
  cont++;

  for(device=s;(device<f)&&cont;device+=step){
      proc_pci_read_config(device,buf,3); 
      if(((buf[0]&0xffff)==vendor)&&
        (((buf[2]>>16)&0xffff)==0x0300))  /* VGA Class */
              if(!(--cont)){
                proc_pci_read_config(device,buf,16); 
                memcpy(conf,buf,256); 
                return 0;
              };
    };

  return cont;
}

int __svgalib_pci_find_vendor_vga_pos(unsigned int vendor, unsigned long *conf, int cont)
{ unsigned long buf[64];
  int device;
  int s,f;
  
  if(__svgalib_pci_idev) {
      s=__svgalib_pci_idev;
      f=__svgalib_pci_idev+1;
  } else {
      s=1;
      f=17;
  }
  
  cont++;

  for(device=__svgalib_pci_idev;(device<32)&&cont;device++){
        proc_pci_read_config(device,buf,3); 
        if(((buf[0]&0xffff)==vendor)&&
           (((buf[2]>>16)&0xffff)==0x0300))  /* VGA Class */
              if(!(--cont)){
                proc_pci_read_config(device,buf,16); 
                memcpy(conf,buf,256); 
                return device;
              };
    };

  return 0;
}

#if NOHELPER
int __svgalib_pci_read_config_dword(int pos, int address)
{
	int f;
	unsigned int n, d;
	int bus, device, fn;
	char filename[256];
	
	bus=(pos&0xff00)>>8;
	device=(pos&0xf8)>>3;
	fn=pos&0x07;
	sprintf(filename,"/proc/bus/pci/%02i/%02x.%i",bus,device,fn);
	f=open(filename,O_RDONLY);
	lseek(f, address, SEEK_SET);
	read(f, &n, 4);
	close(f);
	d=LE32(n);
	return d;
};

void __svgalib_pci_write_config_dword(int pos, int address, unsigned int data)
{
	int f;
	unsigned int d;
	int bus, device, fn;
	char filename[256];
	
	d=LE32(data);
	bus=(pos&0xff00)>>8;
	device=(pos&0xf8)>>3;
	fn=pos&0x07;
	sprintf(filename,"/proc/bus/pci/%02i/%02x.%i",bus,device,fn);
	f=open(filename,O_WRONLY);
	lseek(f, address, SEEK_SET);
	write(f, &d, 4);
	close(f);
};

int __svgalib_pci_read_aperture_len(int pos, int address)
{
	FILE *f;
	char buf[512];

	f=fopen("/proc/bus/pci/devices", "r");
	while (fgets(buf, sizeof(buf)-1, f)) {
		int cnt;
		unsigned int dev, di;
		unsigned long lens[6], dl;
		cnt = sscanf(buf, "%x %x %x %lx %lx %lx %lx %lx %lx %lx %lx %lx %lx %lx %lx %lx %lx",
				&dev, &di, &di, 
				&dl, &dl, &dl, &dl, &dl, &dl, &dl,
				&lens[0], &lens[1], &lens[2], &lens[3], &lens[4], &lens[5],
				&dl);
		if(dev==pos)
			return lens[address];				
	}
  
}

#else

int __svgalib_pci_read_config_dword(int pos, int address)
{
    pcic_t p;
   
    p.pcipos = pos;
    p.address = address;
    
    if(ioctl( __svgalib_mem_fd, SVGAHELPER_PCIINL, &p)) return -1;
    
    return p.val;
};

int __svgalib_pci_read_aperture_len(int pos, int address)
{
    pcic_t p;
   
    p.pcipos = pos;
    p.address = address;
    
    if(ioctl( __svgalib_mem_fd, SVGAHELPER_PCIAPLEN, &p)) return -1;
    
    return p.val;
};

void __svgalib_pci_write_config_dword(int pos, int address, unsigned int data)
{
    pcic_t p;
   
    p.pcipos = pos;
    p.address = address;
    p.val = data;
    
    ioctl( __svgalib_mem_fd, SVGAHELPER_PCIOUTL, &p);
};
#endif

int memorytest(uint32_t *m, int max_mem) {
    unsigned char sav[1024];
    int i, j;

    max_mem*=4;
    for(i=0;i<max_mem;i++) {
        sav[i]=*(m+64*1024*i);
    }
    for(i=max_mem-1;i>=0;i--) {
        *(m+64*1024*i)=i;
    }
    for(i=0;i<max_mem;i++) {
//        printf("%i %i\n",i*256, *(m+64*1024*i));
        if(*(m+64*1024*i)!=i) break;
    }
    for(j=0;j<i;j++) {
        *(m+64*1024*j)=sav[j];
    }
    return i*256;
}
