#include <vga.h>
#include <dirent.h>
#include <stdio.h>
#include <string.h>

#include "ft.h"

struct dirent **namelist;

int select_font(const struct dirent *dirent) {
    char tmp[256]; 
    strcpy(tmp,"/usr/X11R6/lib/X11/fonts/ttf/");
    strcat(tmp,dirent->d_name);    
    return checkfontencoding(tmp,NULL,NULL,NULL)==15;
}

static FT_font font, font2, font3;

int main()
{
    int i, x, n;

    checkfontencoding("arial.ttf",NULL,NULL,NULL);
    printf("%i\n",checkfontencoding("arial.ttf",NULL,NULL,NULL));
    printf("%i\n",checkfontencoding("times.ttf",NULL,NULL,NULL));

    loadfont(&font,"arial.ttf",37*64,37*64,180,180);
    loadfont(&font3,"arial.ttf",37*64,37*64,90,90);
    loadfont(&font2,"times.ttf",0,24*64,100,100);

    vga_init();
    vga_setmode(G1024x768x256);

    graphbase=vga_getgraphmem();
    screen_pitch=1024;
    screen_bpp=1;

    x=0;
    for(i=65;i<91;i++)
        x+=drawchar(font.chars,i,x&1023,120+(x>>3),i-65,0,0)>>6;

    x=0;
    for(i=97;i<123;i++)
        x+=drawchar(font2.chars,i,x,400,0,i,0)>>6;

    ft_font=font2.chars;
    ft_fg=0x4;
    ft_bg=0;
    ft_transparent=1;

    for(i=500;i<700;i+=45) {
        changefontsize(&font2,0,0,i>>2,i>>2);
        ft_writen(0,i,300,"Maya Maya 1 2 3 MMM!@#$%^&*()[]{}`~''/.,,?><");
    }

#if 0
    changefontsize(&font,0,0,150,150);
    for(i=32;i<33;i++)
printf("%c %i %i\n",i,font.chars[i].metrics.horiAdvance,font3.chars[i].metrics.horiAdvance);
    for(i=46;i<47;i++)
printf("%c %i %i\n",i,font.chars[i].metrics.horiAdvance,font3.chars[i].metrics.horiAdvance);
    for(i=224;i<251;i++)printf("%c %i %i\n",i,font.chars[i].metrics.horiAdvance,font3.chars[i].metrics.horiAdvance);

#endif

    vga_getch();

    vga_setmode(TEXT);

    return 0;

}

