#include <X11/Xlib.h>
#include <X11/Xutil.h>
#define XK_MISCELLANY
#include <X11/keysymdef.h>
#include <stdio.h>

#include "bd.h"
#include "keys.h"

int DPI;
int left_skip;
int top_skip;
int vis_width;
int vis_height;
int vis_pix_height;
int vis_pitch;
int color_fg;
int color_bg;
int color_uitext;
int color_selected;
int color_cursor;
int color_decor;

int display_width;
int display_height;
int display_pix_height;

static char zero[8192];

static int xmax,xmin,ymax,ymin;

Window w;
Display *dpy;
Pixmap pm;
int scr;
int bpp;
Visual *vis;
XSetWindowAttributes attr;
GC gc, pmgc;
XGCValues values;
XImage *im;
char *mem;

int readchar() {

    int ch;
    XEvent event;
    XKeyEvent *kev;
    int kc;
    
    ch=0;
    if((xmin<=xmax)&&(ymin<=ymax)) {
        XPutImage(dpy,w,gc,im,xmin,ymin,xmin,ymin,xmax-xmin+1,ymax-ymin+1);
//printf("readch %i,%i   %i,%i\n",xmin,ymin,xmax,ymax);
        xmin=display_width;
        xmax=0;
        ymin=display_pix_height;
        ymax=0;
    }
    while(ch==0) {
        XNextEvent(dpy, &event);
        switch(event.type) {
            case KeyPress:
                kev=(XKeyEvent *)&event;
                switch(kev->keycode) {
                    case 97: case 98: case 99: case 100: 
                        kc=kev->keycode+5;
                        break;
                    case 102: case 103: case 104: case 105:
                    case 106: case 107:
                        kc=kev->keycode+4;
                        break;
                    case 110: 
                        kc=101;
                        break;
                    case 111: 
                        kc=99;
                        break;
                    case 112: 
                        kc=96;
                        break;
                    case 116: 
                        kc=98;
                        break;
                    default:
                        kc=kev->keycode-8;
                }
                ch=translate_keycode(kc,kev->state);
/*
                ch=XKeycodeToKeysym(dpy,kev->keycode,kev->state&1);
                if((ch>=XK_F1)&&(ch<=XK_F12))ch+=K_F1-XK_F1;
                if(((kev->state&13)==4)&&(ch>='a')&&(ch<='z'))ch-=96;
                if(((kev->state&15)==2)&&(ch>='a')&&(ch<='z'))ch-=32;
                if(((kev->state&15)==3)&&(ch>='A')&&(ch<='Z'))ch+=32;
                switch(ch) {
                    case XK_Return:
                        ch=K_ENTER;
                        break;
                    case XK_Left:
                        ch=K_LEFT;
                        break;
                    case XK_Down:
                        ch=K_DOWN;
                        break;
                    case XK_Right:
                        ch=K_RIGHT;
                        break;
                    case XK_Up:
                        ch=K_UP;
                        break;
                    case XK_Home:
                        ch=K_HOME;
                        break;
                    case XK_End:
                        ch=K_END;
                        break;
                    case XK_Delete:
                        ch=K_DEL;
                        break;
                    case XK_BackSpace:
                        ch=K_BACKSPACE;
                        break;
                }
*/
                break;
            case Expose:
            case GraphicsExpose:
                XPutImage(dpy,w,gc,im,0,0,0,0,display_width,display_pix_height);
                xmin=display_width;
                xmax=0;
                ymin=display_pix_height;
                ymax=0;
                break;
        }
    }
    return ch;
}


int init_graphics() {
 
    dpy= XOpenDisplay(0);
    w = XCreateWindow(dpy, DefaultRootWindow(dpy), 0, 0, display_width, display_pix_height, 0, 
        	CopyFromParent, CopyFromParent, CopyFromParent,
                0, 0);
    XMapWindow(dpy, w);
    scr=DefaultScreen(dpy);
    bpp=DefaultDepth(dpy,scr);
    screen_bpp=(bpp+7)/8;
    screen_pitch=display_width*screen_bpp;
    vis=DefaultVisual(dpy,scr);
    gc=XCreateGC(dpy,w,0,&values);
    mem=(char *)malloc(display_pix_height*screen_pitch);
    im=XCreateImage(dpy,vis,bpp,ZPixmap,0,mem,display_width,display_pix_height,32,screen_pitch);
    
    memset(mem,0,display_pix_height*screen_pitch);
    
    XPutImage(dpy,w,gc,im,0,0,0,0,display_width,display_pix_height);
    
    XFlush(dpy);

    graphbase=mem;

    top_skip=50;
    left_skip=50;
    vis_width=display_width-left_skip;
    vis_pix_height=display_pix_height-top_skip;
    vis_pitch=vis_width*screen_bpp;
    
    display_height=vis_pix_height*72/DPI;

    color_fg=0xffff;
    color_bg=0;
    color_uitext=0x400;
    color_selected=0x8000;
    color_cursor=0x8200;
    color_decor=0xfa06;

    memset(zero,0,8192);

    XPutImage(dpy,w,gc,im,0,0,0,0,display_width,display_pix_height);
    xmin=display_width;
    xmax=0;
    ymin=display_pix_height;
    ymax=0;

    XSelectInput(dpy,w,KeyPressMask|ExposureMask);
    
    return 0;
}

int close_graphics() {
    return 0;
}

static int drawscansegment(char *buf, int x, int y, int pitch) {
    char *b;
    
    b=mem+screen_pitch*y+x*screen_bpp;
    memcpy(b,buf,pitch);
    if(x<xmin)xmin=x;
    if(y<ymin)ymin=y;
    if(x+pitch/screen_bpp>xmax)xmax=x+pitch/screen_bpp;
    if(y>ymax)ymax=y;
    
    return 0;
}

static int getscansegment(char *buf, int x, int y, int pitch) {
    char *b;
    
    b=mem+screen_pitch*y+x*screen_bpp;
    memcpy(buf,b,pitch);
    return 0;
}

int save_area(int x, int y, int pitch, int height, char *buf)
{
    int i;
    
    for(i=0;i<height;i++) {
        getscansegment(buf+pitch*i, x, y+i, pitch);
    }
    return 0;
}

int restore_area(int x, int y, int pitch, int height, char *buf)
{
    int i;
    
    for(i=0;i<height;i++) {
        drawscansegment(buf+pitch*i, x, y+i, pitch);
    }
    if((xmin<=xmax)&&(ymin<=ymax)) {
        XPutImage(dpy,w,gc,im,xmin,ymin,xmin,ymin,xmax-xmin+1,ymax-ymin+1);
//printf("restore %i,%i   %i,%i\n",xmin,ymin,xmax,ymax);
        xmin=display_width;
        xmax=0;
        ymin=display_pix_height;
        ymax=0;
    }
    
    return 0;
}

int blank_area(int x, int y, int pitch, int height)
{
    int i;
    
    for(i=0;i<height;i++) {
        drawscansegment(zero, x, y+i, pitch);
    }
    return 0;
}

int drawline(int x1, int y1, int x2, int y2, int col) {
    int i;

    if(x1<x2) {
        for(i=x1;i<=x2;i++)XPutPixel(im,i,y1,col);
    } else if(y1<y2) {
        for(i=y1;i<=y2;i++)XPutPixel(im,x1,i,col);
    }
    if(x1<xmin)xmin=x1;
    if(y1<ymin)ymin=y1;
    if(x2>xmax)xmax=x2;
    if(y2>ymax)ymax=y2;
/*
    if((xmin<=xmax)&&(ymin<=ymax))
        XPutImage(dpy,w,gc,im,xmin,ymin,xmin,ymin,xmax-xmin+1,ymax-ymin+1);
printf("drawline %i,%i   %i,%i\n",xmin,ymin,xmax,ymax);
    xmin=display_width;
    xmax=0;
    ymin=display_pix_height;
    ymax=0;
*/

    return 0;
}

void writen(int x, int y, int n, unsigned char *s, par_t *par, int line)
{
    font_element *ft_font;
    int i=0;
    int j;
    int k;

    if(x<xmin)xmin=x;

    x<<=6;
    
    ft_font=par->font->chars;
    while((i<n) && s[i] && ((x>>6)+ft_font[s[i]].bitmap.width)*screen_bpp<screen_pitch) {
        j=0;
        k=par->v2l[i+par->lines[line]->st]+par->lines[line]->st;
        while((j<par->numfontchanges-1)&&(k>=par->fontchangepos[j+1]))j++;
        ft_font=fonts[par->fontchange[j]]->chars;
        x+=drawchar(ft_font,s[i++],x>>6,y,ft_fg,ft_bg,ft_transparent);
    }
    if((x>>6)>xmax)xmax=x>>6;
}

