#include "bd.h"

par_t *new_par(par_t *template) 
{
    par_t *par;
    int i;
    
    par=malloc(sizeof(par_t));
    par->text=(unsigned char *)malloc(MAXPARCHARS);
    par->vistext=(unsigned char *)malloc(MAXPARCHARS);
    par->v2l=(guint16 *)malloc(MAXPARCHARS*sizeof(guint16));
    par->text[0]=0;
    if(template==NULL) {
        par->font=fonts[0]; 
        par->style=0;
        par->par_point_width=WIDTH;
        par->par_point_margin=0;
        par->numfontchanges=1;
        par->fontchange[0]=0;
        par->fontchangepos[0]=0;        
        par->lineskip=0;
        par->firstlineskip=0;
        par->firstlineindent=18;
    } else {
        par->font=fonts[template->fontchange[template->numfontchanges-1]];
        par->style=template->style;
        par->par_point_width=template->par_point_width;
        par->par_point_margin=template->par_point_margin;
        par->numfontchanges=1;
        par->fontchange[0]=0;
        par->fontchangepos[0]=template->fontchange[template->numfontchanges-1];
        par->lineskip=template->lineskip;
        par->firstlineskip=template->firstlineskip;
        par->firstlineindent=template->firstlineindent;
    }
    
    for(i=0;i<100;i++)par->lines[i]=NULL;
    par->next=NULL;
    par->prev=NULL;

    par->numlines=0;

    return par;
}

int insert_par(par_t *par,par_t *item) {
/* 3 cases: 
    item==first_par - insert before first paragraph
    item==NULL - insert at the end (after last paragraph).
    else - insert before item
*/
    par_t *tmp;
    
    if(last_par==NULL) {
        last_par=par;
        first_par=par;
        par->prev=NULL;
        par->next=NULL;        
    } else if(item==NULL) {
        par->next=NULL;
        last_par->next=par;
        par->prev=last_par;
        last_par=par;
    } else if(item==first_par) {
        first_par=par;
        par->next=item;
        item->prev=par;
        par->prev=NULL;
    } else {
        tmp=item->prev;
        
        item->prev=par;
        tmp->next=par;
        par->prev=tmp;
        par->next=item;
    }
    
    if(par==first_par) {
        par->par_point_ypos=0;
    } else {
        par->par_point_ypos=par->prev->par_point_ypos+par->prev->numlines*par->prev->line_point_height;
    }
    return 0;
}

int del_par(par_t *par) {
    int i;
    
    if(par==first_par) {
        if(first_par==last_par) {
            first_par=NULL;
            last_par=NULL;
        } else {
            first_par=par->next;
            first_par->prev=NULL;
        }
    } else if(par==last_par) {
        last_par=par->prev;
        last_par->next=NULL;
    } else {
        par->prev->next=par->next;
        par->next->prev=par->prev;
    }
    free(par->text);
    free(par->vistext);
    for(i=0;i<100;i++)if(par->lines[i]!=NULL)free(par->lines[i]);
    free(par);

    return 0;
}

