#include <vga.h>
#include <vgakeyboard.h>
#include <string.h>

#include "bd.h"
#include "keys.h"

int DPI;
int left_skip;
int top_skip;
int vis_width;
int vis_height;
int vis_pix_height;
int vis_pitch;

int color_fg;
int color_bg;
int color_uitext;
int color_selected;
int color_cursor;
int color_decor;

int display_width;
int display_height;
int display_pix_height;

static char zero[8192];
volatile int lastkey;
static int shift_state; /* shift capslock ctrl alt numlock */
static int shiftkeys; /* rshift lshift capslock rctrl lctrl ralt lalt numlock */
int ttyfd;

void handler(int scancode, int newstate)
{
    int m;
    
    switch(scancode) {
        case SCANCODE_RIGHTSHIFT:
            m=1;
            break;
        case SCANCODE_LEFTSHIFT:
            m=2;
            break;
        case SCANCODE_CAPSLOCK:
            m=4;
            break;
        case SCANCODE_RIGHTCONTROL:
            m=8;
            break;
        case SCANCODE_LEFTCONTROL:
            m=16;
            break;
        case SCANCODE_RIGHTALT:
            m=32;
            break;
        case SCANCODE_LEFTALT:
            m=64;
            break;
        case SCANCODE_NUMLOCK:
            m=128;
            break;
        default:
            m=0;
    }
    if(m) {
        if(newstate)shiftkeys|=m; else shiftkeys&=~m;
        switch(scancode) {
            case SCANCODE_CAPSLOCK:
                if(newstate)shift_state^=2;
                break;
            case SCANCODE_NUMLOCK:
                if(newstate)shift_state^=16;
                break;
            case SCANCODE_RIGHTSHIFT: case SCANCODE_LEFTSHIFT:
                shift_state&=0xfe;
                shift_state |= shiftkeys&3 ? 1 : 0;
                break;
            case SCANCODE_RIGHTCONTROL: case SCANCODE_LEFTCONTROL:
                shift_state&=0xfb;
                shift_state |= shiftkeys&24 ? 4 : 0;
                break;
            case SCANCODE_RIGHTALT: case SCANCODE_LEFTALT:
                shift_state&=0xf7;
                shift_state |= shiftkeys&96 ? 8 : 0;
                break;
        }
    } else {
        if(newstate) {
            lastkey=scancode;
        } else {
            lastkey=0;
        }
    }
}

int readchar() {

    int ch;
    
    ch=0;
    while(ch==0) {
        keyboard_waitforupdate();
        if(lastkey) ch=translate_keycode(lastkey, shift_state);
    }
    
    return ch;
}

int init_graphics() {
    int vgamode;

    switch (display_width*10000+display_pix_height) {
        case  3200200:
            vgamode=G320x200x256;
            break;
        case  3200240:
            vgamode=G320x240x256V;
            break;
        case  6400480:
            vgamode=G640x480x256;
            break;
        case  8000600:
            vgamode=G800x600x256;
            break;
        case 10240768:
            vgamode=G1024x768x256;
            break;
        case 11520864:
            vgamode=G1152x864x256;
            break;
        case 12801024:
            vgamode=G1280x1024x256;
            break;
        case 16001200:
            vgamode=G1600x1200x256;
            break;
        case 20481536:
            vgamode=G2048x1536x256;
            break;
        default:
            exit(1);
    }

    vga_disabledriverreport();
    vga_init();
    vga_setmode(vgamode);
    vga_setlinearaddressing();
    screen_bpp=1;

    graphbase=vga_getgraphmem();
    screen_pitch=display_width*screen_bpp;

    top_skip=50;
    left_skip=50;
    vis_width=display_width-left_skip;
    vis_pix_height=display_pix_height-top_skip;
    vis_pitch=vis_width*screen_bpp;

    display_height=vis_pix_height*72/DPI;

    color_fg=15;
    color_bg=0;
    color_uitext=7;
    color_selected=4;
    color_cursor=0x87;
    color_decor=13;

    memset(zero,0,8192);
    
    ttyfd=keyboard_init_return_fd();
    lastkey=0;
    shift_state=0;
    keyboard_seteventhandler(handler);
    
    return 0;
}

int close_graphics() {
    keyboard_close();
    vga_setmode(TEXT);
    return 0;
}

int save_area(int x, int y, int pitch, int height, char *buf)
{
    int i;
    
    for(i=0;i<height;i++) {
        vga_getscansegment(buf+pitch*i, x, y+i, pitch);
    }
    return 0;
}

int restore_area(int x, int y, int pitch, int height, char *buf)
{
    int i;
    
    for(i=0;i<height;i++) {
        vga_drawscansegment(buf+pitch*i, x, y+i, pitch);
    }
    return 0;
}

int blank_area(int x, int y, int pitch, int height)
{
    int i;
    
    for(i=0;i<height;i++) {
        vga_drawscansegment(zero, x, y+i, pitch);
    }
    return 0;
}

int drawline(int x1, int y1, int x2, int y2, int col) {
    vga_setcolor(col);
    vga_drawline(x1,y1,x2,y2);
    return 0;
}

void writen(int x, int y, int n, unsigned char *s, par_t *par, int line)
{
    font_element *ft_font;
    int i=0;
    int j;
    int k;

    x<<=6;
    
    ft_font=par->font->chars;
    while((i<n) && s[i] && ((x>>6)+ft_font[s[i]].bitmap.width)*screen_bpp<screen_pitch) {
        j=0;
        k=par->v2l[i+par->lines[line]->st]+par->lines[line]->st;
        while((j<par->numfontchanges-1)&&(k>=par->fontchangepos[j+1]))j++;
        ft_font=fonts[par->fontchange[j]]->chars;
        x+=drawchar(ft_font,s[i++],x>>6,y,ft_fg,ft_bg,ft_transparent);
    }
}

