#include <stdio.h>

#include "bd.h"


typedef struct {
	char name[32];
	int (*readval)(char *, void *);
	void *val;
} cfgline;

int readint(char *line, void *val) {
    int i,j;

    j=sscanf(line," %i",&i);
    if(j==1)*(int *)val=i;
    return j;
}

cfgline configs[]= {
	{ "print dpi", readint, &PDPI },
	{ "display dpi", readint, &DPI },
	{ "page width", readint, &page_width },
	{ "page height", readint, &page_height },
	{ "display width", readint, &display_width },
	{ "display height", readint, &display_pix_height },
	{ "top margin", readint, &page_bottom_margin },
	{ "bottom margin", readint, &page_top_margin },
	{ "right margin", readint, &page_right_margin },
	{ "left margin", readint, &page_left_margin },
        { "", NULL, NULL }
};

int default_values() {

    page_width=8*72;
    page_height=11*72;
    page_right_margin=36;
    page_left_margin=36;
    page_top_margin=36;
    page_bottom_margin=36;
    
    PDPI=104;
    
    display_width=1024;
    display_pix_height=768;
    DPI=0;

    return 0;
}

int recalc_defaults() {
    WIDTH=page_width-page_right_margin-page_left_margin;
    if((DPI==0) || ((DPI*WIDTH)/72>display_width-50)) {
        DPI=(8*(display_width-50)/WIDTH)*9;
    }
    UDPI=(display_width-50)/63*9;
    return 0;
}

int readconfigfile() {
    char line[1024], cfname[256];
    FILE *f;
    char *c;
    
    default_values();
    
    c=getenv("HOME");
    strcpy(cfname,c);
    strcat(cfname,"/.timna/config");

    f=fopen(cfname,"r");
    if(f) {
        while(fgets(line,1023,f)) {
            int i;
            
            i=0;
            while(configs[i].val && strncasecmp(configs[i].name,line,strlen(configs[i].name)))i++;
            if(configs[i].val) {
                configs[i].readval(line+strlen(configs[i].name),configs[i].val);
            }
        }
        fclose(f);
    }

    recalc_defaults();
    
    return 0;
}
