#include <string.h>

#include "bd.h"


int split_par(par_t *par, int pos)
{
    par_t *tmp;
    int i, j;
    
    tmp=new_par(par);
    i=0;
    while((i<par->numfontchanges)&&(par->fontchangepos[i]<pos))i++;
    if(i>0)i--;
    for(j=0;j<par->numfontchanges-i;j++) {
        tmp->fontchange[j]=par->fontchange[j+i];
        tmp->fontchangepos[j]=(par->fontchangepos[j+i]-pos)*(j!=0);
    }

    par->numfontchanges=i+1;
    tmp->numfontchanges=j;    
    strcpy(tmp->text,par->text+pos);
    par->text[pos]=0;

    insert_par(tmp,par->next);

    reformat(3, DPI, par);
    
    return 0;
}

int join_par(par_t *par) {
    int i, p;
    par_t *tmp;
    
    if(par->next==NULL)return 0;
    tmp=par->next;
    p=strlen(par->text);
    if(par->fontchangepos[par->numfontchanges-1]==p)par->numfontchanges--;
    for(i=0;i<tmp->numfontchanges;i++) {
        par->fontchange[par->numfontchanges+i]=tmp->fontchange[i];
        par->fontchangepos[par->numfontchanges+i]=tmp->fontchangepos[i]+p;
    }
    par->numfontchanges+=i;
    strcat(par->text,tmp->text);

    del_par(tmp);

    return 0;
}

int insert_char(par_t *par, int ch, int pos) {
    int i;
    
    for(i=strlen(par->text)+1;i>=pos;i--)par->text[i]=par->text[i-1];
    par->text[pos]=ch;
    pos++;

    return 0;
}
