#include <stdlib.h>
#include <stdio.h>
#include <vga.h>
#include "bd.h"
#include "keys.h"

int UDPI;
int ui_unit;
int ui_x;
int ui_y;
int ui_height;
int ui_width;

int choose_font(char *family, int size, int style) {
    int i,f;
    int x;
    int pitch;
    int ch;
    unsigned char *buf;
    char str[20];
    char fam[48];
    char *styles[4]={"Normal","Italic","Bold","BoldItalic"};
    int save_fg;
    
    if(size==0)size=12;
    f=fontfilesnum-1;
    while(strcmp(fontfiles[f]->family,family)&&f)f--;
    while (((1<<style)&fontfiles[f]->style_flags)==0)style=(style+1)%4;
    
    pitch=ui_width*screen_bpp;
    
    buf=malloc(pitch*ui_height);
    save_area(ui_x,ui_y,pitch,ui_height,buf);
    blank_area(ui_x,ui_y,pitch,ui_height);

    drawline(ui_x,ui_y,ui_x+ui_width-1,ui_y,color_decor);
    drawline(ui_x,ui_y,ui_x,ui_y+ui_height-1,color_decor);
    drawline(ui_x+ui_width-1,ui_y,ui_x+ui_width-1,ui_y+ui_height-1,color_decor);
    drawline(ui_x,ui_y+ui_height-1,ui_x+ui_width-1,ui_y+ui_height-1,color_decor);

    ft_font=ui_font->chars;

    strcpy(fam,fontfiles[f]->family);
    sprintf(str,"Size: %03i",size);
    ft_writen(ui_x+ui_unit,ui_y+6*ui_unit,10,str);
    ft_writen(ui_x+ui_unit,ui_y+3*ui_unit,30,fam);

    save_fg=ft_fg;
    x=ui_x+ui_unit;
    for(i=0;i<4;i++) {
        if(((1<<i)&fontfiles[f]->style_flags)!=0) {
            ft_fg=color_uitext;
            if(i==style) ft_fg=color_selected;
            ft_writen(x,ui_y+8*ui_unit,11,styles[i]);
            x+=3*ui_unit;
        }
    }
    ft_fg=save_fg;

    while((ch=readchar())!=K_ENTER) {
        switch(ch) {
            case '0': case '1': case '2': case '3': case '4':
            case '5': case '6': case '7': case '8': case '9':
                size=(10*size+ch-'0')%1000;
                break;
            case K_UP:
                if(f>0)f--;
                while (((1<<style)&fontfiles[f]->style_flags)==0)style=(style+1)%4;
                break;
            case K_DOWN:
                if(f<fontfilesnum-1)f++;
                while (((1<<style)&fontfiles[f]->style_flags)==0)style=(style+1)%4;
                break;
            case 'n': case 'N':
                if((1&fontfiles[f]->style_flags)!=0)style=0;
                break;
            case 'i': case 'I':
                if((2&fontfiles[f]->style_flags)!=0)style=1;
                break;
            case 'b': case 'B':
                if((4&fontfiles[f]->style_flags)!=0)style=2;
                break;
            case 'm': case 'M':
                if((8&fontfiles[f]->style_flags)!=0)style=3;
                break;
        }
        sprintf(str,"Size: %03i",size);
        strcpy(fam,fontfiles[f]->family);
        blank_area(ui_x+1,ui_y+1,pitch-2*screen_bpp,ui_height-2);
        ft_writen(ui_x+ui_unit,ui_y+6*ui_unit,10,str);
        ft_writen(ui_x+ui_unit,ui_y+3*ui_unit,30,fam);

        save_fg=ft_fg;
        x=ui_x+ui_unit;
        for(i=0;i<4;i++) {            
            if(((1<<i)&fontfiles[f]->style_flags)!=0) {
                ft_fg=color_uitext;
                if(i==style) ft_fg=color_selected;
                ft_writen(x,ui_y+8*ui_unit,11,styles[i]);
                x+=3*ui_unit;
            }
        }
        ft_fg=save_fg;
    }
   
    restore_area(ui_x,ui_y,pitch,ui_height,buf);
    free(buf);
    
    return open_font(fam, style,size<<6, DPI);
}

int choose_file_name(char *prompt, char *filename) {
    int i;
    int pos,l;
    int pitch;
    int ch;
    unsigned char *buf;
    
    pitch=ui_width*screen_bpp;
    
    buf=malloc(pitch*ui_height);
    save_area(ui_x,ui_y,pitch,ui_height,buf);
    blank_area(ui_x,ui_y,pitch,ui_height);

    drawline(ui_x,ui_y,ui_x+ui_width-1,ui_y,color_decor);
    drawline(ui_x,ui_y,ui_x,ui_y+ui_height-1,color_decor);
    drawline(ui_x+ui_width-1,ui_y,ui_x+ui_width-1,ui_y+ui_height-1,color_decor);
    drawline(ui_x,ui_y+ui_height-1,ui_x+ui_width-1,ui_y+ui_height-1,color_decor);

    ft_font=ui_font->chars;

    pos=strlen(filename);

    ft_writen(ui_x+ui_unit,ui_y+3*ui_unit,20,prompt);
    ft_writen(ui_x+ui_unit,ui_y+6*ui_unit,60,filename);

    while((ch=readchar())!=K_ENTER) {
        l=strlen(filename);
        if((ch>=' ')&&(ch<='~')&&(l<126)) {
            for(i=l+1;i>pos;i--)filename[i]=filename[i-1];
            filename[pos]=ch;
            pos++;
        }
        if((ch==K_BACKSPACE)&&(pos>0)) {
            pos--;
            for(i=pos;i<l;i++)filename[i]=filename[i+1];
        }
        blank_area(ui_x+1,ui_y+5*ui_unit,pitch-2*screen_bpp,2*ui_unit);
        ft_writen(ui_x+ui_unit,ui_y+6*ui_unit,60,filename);
    }
   
    restore_area(ui_x,ui_y,pitch,ui_height,buf);
    free(buf);
    
    return 0;
}


int choose_parameters(par_t *par) {
    int p[5];
    int ch;
    int i, j, pitch;
    int save_fg;
    char tmp[30];
    unsigned char *buf;
    
    save_fg=ft_fg;
    
    p[0]=par->par_point_width;
    p[1]=par->par_point_margin;
    p[2]=par->lineskip;
    p[3]=par->firstlineskip;
    p[4]=par->firstlineindent;
    
    pitch=ui_width*screen_bpp;
    
    buf=malloc(pitch*ui_height);
    save_area(ui_x,ui_y,pitch,ui_height,buf);
    blank_area(ui_x,ui_y,pitch,ui_height);

    drawline(ui_x,ui_y,ui_x+ui_width-1,ui_y,color_decor);
    drawline(ui_x,ui_y,ui_x,ui_y+ui_height-1,color_decor);
    drawline(ui_x+ui_width-1,ui_y,ui_x+ui_width-1,ui_y+ui_height-1,color_decor);
    drawline(ui_x,ui_y+ui_height-1,ui_x+ui_width-1,ui_y+ui_height-1,color_decor);

    ft_font=ui_font->chars;

    ft_fg=color_uitext;

    ft_writen(ui_x+ui_unit,ui_y+2*ui_unit,30,"width:");
    ft_writen(ui_x+ui_unit,ui_y+7*ui_unit/2,30,"margin:");
    ft_writen(ui_x+ui_unit,ui_y+5*ui_unit,30,"line skip:");
    ft_writen(ui_x+ui_unit,ui_y+13*ui_unit/2,30,"first line skip:");
    ft_writen(ui_x+ui_unit,ui_y+8*ui_unit,30,"first line indent:");

    j=0;
    ch=0;
    
    for(i=0;i<5;i++) {
        if(i==j) { ft_fg=color_selected; } else {ft_fg=color_uitext; };
        sprintf(tmp,"%03i",p[i]);
        ft_writen(ui_x+7*ui_unit,ui_y+(3*i+4)*ui_unit/2,4,tmp);
    }

    while((ch=readchar())!=K_ENTER) {
        switch(ch) {
            case '0': case '1': case '2': case '3': case '4':
            case '5': case '6': case '7': case '8': case '9':
                p[j]=(10*p[j]+ch-'0')%1000;
                break;
            case K_UP:
                j=(j-1)%5;
                break;
            case K_DOWN:
                j=(j+1)%5;
                break;
        }
        blank_area(ui_x+1,ui_y+1,pitch-2*screen_bpp,ui_height-2);

        ft_fg=color_uitext;
    
        ft_writen(ui_x+ui_unit,ui_y+2*ui_unit,30,"width:");
        ft_writen(ui_x+ui_unit,ui_y+7*ui_unit/2,30,"margin:");
        ft_writen(ui_x+ui_unit,ui_y+5*ui_unit,30,"line skip:");
        ft_writen(ui_x+ui_unit,ui_y+13*ui_unit/2,30,"first line skip:");
        ft_writen(ui_x+ui_unit,ui_y+8*ui_unit,30,"first line indent:");
    
        for(i=0;i<5;i++) {
            if(i==j) { ft_fg=color_selected; } else {ft_fg=color_uitext; };
            sprintf(tmp,"%03i",p[i]);
            ft_writen(ui_x+7*ui_unit,ui_y+(3*i+4)*ui_unit/2,4,tmp);
        }
    }
   
    ft_fg=save_fg;
    restore_area(ui_x,ui_y,pitch,ui_height,buf);
    free(buf);
    
    if(p[0]+p[1]<=WIDTH) {
        par->par_point_width=p[0];
        par->par_point_margin=p[1];
    }
    par->lineskip=p[2];
    par->firstlineskip=p[3];
    par->firstlineindent=p[4];
    
    return 0;
}

