#include <stdio.h>
#include <stdlib.h>

#include "bd.h"

int PDPI;

int print_ps() {
    
    FILE *file;
    unsigned char *image;
    int dummy;
    par_t *par;
    int ascender;
    int i;
    int y;
    int yoffs;
    int xoffs;
    int height;
    int pix_height;
    int pagenum;
    int lasty;
    int save_pitch, save_bpp, save_fg;
    unsigned char *save_base;
     
    file=fopen("/tmp/bd.ps","w");

    for(i=0;i<fontsnum;i++)changefontsize(fonts[i],0,0,PDPI,PDPI);

    save_base=graphbase;
    save_pitch=screen_pitch;
    save_bpp=screen_bpp;
    save_fg=ft_fg;

    screen_pitch=WIDTH*PDPI/72;
    screen_bpp=1;
    ft_fg=0xff;

    pix_height=(page_height-page_top_margin-page_bottom_margin)*PDPI/72;
    
    image=(unsigned char *)malloc(screen_pitch*pix_height);
    graphbase=image;
    memset(image,0,screen_pitch*pix_height);

    par=first_par;
    yoffs=0;
    pagenum=1;
    
    fprintf(file,"%%!PS-Adobe-2.0 EPSF-2.0\n");
    fprintf(file,"%%%%Creator: bdft\n");
    fprintf(file,"%%%%Title: bd.ps\n");
//    fprintf(file,"%%%%Pages: 1\n");
    fprintf(file,"%%%%BoundingBox: %i %i %i %i\n",page_left_margin,page_bottom_margin,
        			page_width-page_right_margin,page_height-page_top_margin);
    fprintf(file,"%%%%EndComments\n");
    fprintf(file,"/readstring {\n");
    fprintf(file,"  currentfile exch readhexstring pop\n");
    fprintf(file,"} bind def\n");
    fprintf(file,"/picstr %i string def\n",screen_pitch);
    fprintf(file,"%%%%EndProlog\n");

    while(par!=NULL) {

        if(strlen(par->text)>0) {
            int i;
    
            break_paragraph(par, strlen(par->text), PDPI, -1, &dummy, &dummy, &dummy);
            ascender=par->font->face->bbox.yMax*(par->font->height>>6)*PDPI/72/par->font->face->units_per_EM;
            ft_font=par->font->chars;
    
            for(i=0;i<par->numlines;i++) {

                switch((par->style&0x1c)>>2) {
                    case 0:
                        xoffs=screen_pitch-(par->par_point_margin*PDPI/72)-par->lines[i]->width;
                        break;
                    case 1:
                        xoffs=screen_pitch-(par->par_point_margin*PDPI/72)-(par->par_point_width*PDPI/72);
                        break;
                    case 2:
                        xoffs=screen_pitch-(par->par_point_margin*PDPI/72)-
                              (par->lines[i]->width+(par->par_point_width*PDPI/72))/2;
                        break;
                    case 3: /* should be fully justified. fix later */
                        xoffs=0;
                        break;
                    case 4:
                        xoffs=(par->par_point_margin+par->par_point_width)*PDPI/72-par->lines[i]->width;
                        break;
                    case 5:
                        xoffs=par->par_point_margin*PDPI/72;
                        break;
                    case 6:
                        xoffs=(par->par_point_margin*2+par->par_point_width)*PDPI/144-par->lines[i]->width/2;
                        break;
                    case 7: /* should be fully justified. fix later */
                        xoffs=0;
                        break;
                }

                y=(par->par_point_ypos+par->lines[i]->yoffs-yoffs)*PDPI/72;
                if(y+par->line_pix_height<pix_height) {
                    writen(xoffs,y+ascender,par->lines[i]->len,
                              par->vistext+par->lines[i]->st, par, i);
                    lasty=y+par->line_pix_height;
                } else {
                    int j;
                    
                    height=72*lasty/PDPI;
        
                    fprintf(file,"%%%%Page: %i %i\n",pagenum, pagenum);
    
                    fprintf(file,"gsave\n");
                    fprintf(file,"%i %i translate\n",page_left_margin,page_height-page_top_margin-height);
                    fprintf(file,"%i %i scale\n",WIDTH,height);
                    fprintf(file,"%i %i 8\n",screen_pitch,lasty);
                    fprintf(file,"[ %i 0 0 %i 0 %i ]\n",screen_pitch,-lasty,lasty);
                    fprintf(file,"{ picstr readstring }\n");
                    fprintf(file,"image\n");
                    for(j=0;j<screen_pitch*lasty;j++) {
                        fprintf(file,"%02x",255-*(image+j));
                        if((j%30) == 29)fprintf(file,"\n");
                    }
                    fprintf(file,"\n");
    
                    fprintf(file,"grestore\n");
                    fprintf(file,"showpage\n");

                    yoffs=par->par_point_ypos+par->lines[i]->yoffs;
                    y=(par->par_point_ypos+par->lines[i]->yoffs-yoffs)*PDPI/72;
                    memset(image,0,screen_pitch*pix_height);
                    pagenum++;
                    writen(xoffs,y+ascender,par->lines[i]->len,
                              par->vistext+par->lines[i]->st, par, i);
                    lasty=y+par->line_pix_height;
                }
            }
        }
        
        par=par->next;
    }

    height=72*lasty/PDPI;
        
    fprintf(file,"%%%%Page: %i %i\n", pagenum, pagenum);

    fprintf(file,"gsave\n");
    fprintf(file,"%i %i translate\n",page_left_margin,page_height-page_top_margin-height);
    fprintf(file,"%i %i scale\n",WIDTH,height);
    fprintf(file,"%i %i 8\n",screen_pitch,lasty);
    fprintf(file,"[ %i 0 0 %i 0 %i ]\n",screen_pitch,-lasty,lasty);
    fprintf(file,"{ picstr readstring }\n");
    fprintf(file,"image\n");
    for(i=0;i<screen_pitch*lasty;i++) {
        fprintf(file,"%02x",255-*(image+i));
        if((i%30) == 29)fprintf(file,"\n");
    }
    fprintf(file,"\n");

    fprintf(file,"grestore\n");
    fprintf(file,"showpage\n");
    fprintf(file,"%%%%Trailer\n");

    fclose(file);

    for(i=0;i<fontsnum;i++) {
        changefontsize(fonts[i],0,0,DPI,DPI);
    }
    graphbase=save_base;
    screen_pitch=save_pitch;
    screen_bpp=save_bpp;
    ft_fg=save_fg;
    

    return 0;
}


