#include <vga.h>
#include <stdio.h>
#include "keys.h"
#include "bd.h"

#include <sys/time.h>
#include <dirent.h>

struct timeval tv1,tv2,tv3;
struct timezone tz;

par_t *first_par, *last_par;
char filename[128];

int ystart;

static char cursor_buf[4096];
static char cursor_buf2[4096];

int cursor_x, cursor_y, cursor_height;

int WIDTH;
int page_width;
int page_height;
int page_right_margin;
int page_left_margin;
int page_top_margin;
int page_bottom_margin;

int insert_fontchange(par_t *par, int pos, int font)
{
    int j,i;

    j=0;
    while((j<par->numfontchanges)&&(pos>par->fontchangepos[j]))j++;
    if(j==par->numfontchanges) {
        par->fontchangepos[j]=pos;
        par->fontchange[j]=font;
        par->numfontchanges++;
    } else if (pos==par->fontchangepos[j]) {
        par->fontchangepos[j]=pos;
        par->fontchange[j]=font;    
    } else {
        for(i=par->numfontchanges;i>j;i--) {
            par->fontchangepos[i]=par->fontchangepos[i-1];
            par->fontchange[i]=par->fontchange[i-1];
        }
        par->fontchangepos[j]=pos;
        par->fontchange[j]=font;
        par->numfontchanges++;
    }

    return 0;
}

int hebconv(int i) {
    int j;
    static unsigned char hebconvert[26]="ypabwkriogljvnmt/xc`ed'qhf";
    
    if(i>='a' && i<='z') {
        j=hebconvert[i-'a'];
        if(j>='`' && j<='z')j+=128;
        return j;
    } else switch(i) {
        case ';': return 's'+128; break;
        case '\'': return ','; break;
        case ',': return 'z'+128; break;
        case '.': return 'u'+128; break;
        case '/': return '.'; break;
        default: return i;
    }
}
   
int hebmode;

int display_par_simple(par_t *par, int bdline, int bdx, int bdcd, int pos, int flags) {
    int yoffs;
    int chline, i;
    int x, cy, xoffs;
    int ascender;

    chline=bdline; 
    if(flags&0x100)chline=0;
    if((chline>0)&&(bdline!=par->lastline))chline--;
    par->lastline=bdline;

    yoffs=par->par_point_ypos-ystart;    
    ascender=((-par->font->face->bbox.yMax*((par->font->height))*DPI/72/par->font->face->units_per_EM)>>6)-1;

    for(i=chline;i<par->numlines;i++) {
        int y;
    
        y=(yoffs+par->lines[i]->yoffs)*DPI/72+top_skip;    
        if((y>=top_skip)&&(y+par->lines[i]->height)) {
            if(((flags&1)==1)||((i==bdline)&&(flags&0x200)==0)){
                switch((par->style&0x1c)>>2) {
                    case 0:
                        xoffs=DISPWIDTH-(par->par_point_margin*DPI/72)-par->lines[i]->width;
                        break;
                    case 1:
                        xoffs=DISPWIDTH-(par->par_point_margin*DPI/72)-(par->par_point_width*DPI/72);
                        break;
                    case 2:
                        xoffs=DISPWIDTH-(par->par_point_margin*DPI/72)-
                              (par->lines[i]->width+(par->par_point_width*DPI/72))/2;
                        break;
                    case 3: /* should be fully justified. fix later */
                        xoffs=0;
                        break;
                    case 4:
                        xoffs=(par->par_point_margin+par->par_point_width)*DPI/72-par->lines[i]->width;
                        break;
                    case 5:
                        xoffs=par->par_point_margin*DPI/72;
                        break;
                    case 6:
                        xoffs=(par->par_point_margin*2+par->par_point_width)*DPI/144-par->lines[i]->width/2;
                        break;
                    case 7: /* should be fully justified. fix later */
                    default:
                        xoffs=0;
                }
                xoffs+=left_skip;
            }
        
            if((flags&1)==1) {
                if(y+par->line_pix_height>display_pix_height) { 
                    blank_area(left_skip,y,vis_pitch,vis_pix_height-y-1);
                    return -2;
                }
                blank_area(left_skip,y,vis_pitch,par->line_pix_height);
                writen(xoffs,y-ascender,par->lines[i]->len,
                          par->vistext+par->lines[i]->st,par,i);
            }
    
            if ((i==bdline)&&(flags&0x200)==0) {
    
                x=xoffs+bdx;
                if((pos==0)&&((par->style&0x1c)==0))x-=par->firstlineindent*DPI/72;
                cy=y+par->line_pix_height-1;
    
                cursor_height=par->line_pix_height;
                cursor_y=y;
                cursor_x=x;
                if ((bdcd&1)==1) cursor_x-=3;
                save_area(cursor_x,cursor_y,4*screen_bpp,cursor_height,cursor_buf);
    
                drawline(x,y,x,cy,color_cursor);
                if ((bdcd&1)==1) {
                    drawline(x-1,cy-4,x-1,cy-1,color_cursor);
                    drawline(x-2,cy-3,x-2,cy-2,color_cursor);
                } else {
                    drawline(x+1,cy-4,x+1,cy-1,color_cursor);
                    drawline(x+2,cy-3,x+2,cy-2,color_cursor);
                }
            }
        }
    }
    return 0;
}

int display_par(par_t *par, int pos, int flags)
/* flags:
    bit 0 - draw the paragraph
    bit 8 - redraw all paragraph
    bit 9 - hide cursor
    bit 10 - redraw from this paragraph on
    bit 11 - font was changed
    bit 12 - redraw
   return:
    -2: paragraph too low to display

*/
{
    int bdx, bdline, bdcd;
    int yoffs;
    int i;
    
    yoffs=par->par_point_ypos-ystart;    

    if((flags&0x200)&&(par->par_point_ypos-ystart>display_height)) return -2;
    if((flags&0x200)&&(yoffs+par->par_point_height<0)) return -3;

    i=break_paragraph(par, strlen(par->text), DPI, pos, &bdx, &bdline, &bdcd);
    if(i==1)reformat(0, DPI, par->next);

    if(((flags&0x200)==0)&&(((yoffs+par->lines[bdline]->yoffs)<0) || 
       ((yoffs+par->lines[bdline]->yoffs+par->lines[bdline]->height)>=display_height))) {
        int diff;
        par_t *tmp;
        int i;
        
        if(yoffs+par->lines[bdline]->yoffs<0) {
            diff=yoffs+par->lines[bdline]->yoffs;
        } else {
            diff=yoffs+par->lines[bdline]->yoffs+par->lines[bdline]->height-display_height;
        }

        ystart+=diff;
        tmp=first_par;
        while((tmp!=NULL)&&(tmp->par_point_ypos+tmp->par_point_height < ystart)) {
            tmp=tmp->next;
        }
        
        i=0;

        if(tmp==NULL) {
            tmp=last_par;
        } 

        while((i<par->numlines)&&((tmp->par_point_ypos+tmp->lines[i]->yoffs) <= ystart)) i++;

        if(diff<0) {
            ystart=tmp->par_point_ypos+tmp->lines[i-1]->yoffs;
        } else {
            if(i==par->numlines) {
                ystart=tmp->next->par_point_ypos+tmp->next->lines[0]->yoffs;
            } else ystart=tmp->par_point_ypos+tmp->lines[i]->yoffs;
        }

        blank_area(left_skip,top_skip,vis_pitch,vis_pix_height);
        i=0;
        while((i!=-2)&&(tmp!=NULL)) {
            if(tmp!=par)
                i=display_par_simple(tmp,0,0,0,0,0x201);
            tmp=tmp->next;
        }
  
        yoffs=(par->par_point_ypos-ystart);    
        flags&=~0x400;
        flags|=0x101;
    }

    if((flags&0x1400)||(i==1)) {
        par_t *tmp=par->next;

        if(flags&0x1000) {
            tmp=first_par;
            blank_area(left_skip,top_skip,vis_pitch,vis_pix_height);
        }
        i=0;
        reformat(0,DPI,par);
        while((i!=-2)&&(tmp!=NULL)) {
            i=display_par_simple(tmp,0,0,0,0,0x201);
            tmp=tmp->next;
        }
    }

    display_par_simple(par, bdline, bdx, bdcd, pos, flags);

    return 0;
}
   
int edit_par(par_t *par, int hpos)
{
    int ch;
    int refresh;
    static int pos;
    int f;
    int ret;

    if(par==NULL)return K_F10;
    
    f=257;

    ret=0;

    if (hpos>=0) {
        pos=hpos;
    } else switch(hpos) {
        case -2:
            f|=0x1400;
            pos=0;
            break;
        case -3:
            f|=0x800;
            break;
        default:
            break;
    }

    display_par(par,pos,f);

    while (1) {    
    
        ch=readchar();
        if(cursor_height)save_area(cursor_x,cursor_y,4*screen_bpp,cursor_height,cursor_buf2);
        if(cursor_height)restore_area(cursor_x,cursor_y,4*screen_bpp,cursor_height,cursor_buf);

        refresh=0;
        
        if((ch>=' ')&&(ch<127)) {
            if(hebmode)ch=hebconv(ch);
            insert_char(par, ch, pos);
            pos++;
            refresh=1;
    	} else {
            int i,j;
            
            switch(ch) {
                case K_DEL:
                    if(pos<strlen(par->text)) {
                        for(i=pos;i<=strlen(par->text);i++)par->text[i]=par->text[i+1];
                    } else {
                        join_par(par);
                    }
                    refresh=1;
                    break;
                case K_BACKSPACE: 
                    if(pos>0) {
                        pos--;
                        for(i=pos;i<=strlen(par->text);i++)par->text[i]=par->text[i+1];
                    }
                    refresh=1;
                    break;
                case K_RIGHT:
                    if((pos==0) && (par!=first_par)) {
                        ret=K_RIGHT;
                    } else {
                        if(pos>0)pos--;
                        refresh=2;
                    }
                    break;
                case K_LEFT:
                    if((pos==strlen(par->text)) && (par!=last_par)) {
                        ret=K_LEFT;
                    } else {
                        if(pos<strlen(par->text))pos++;
                        refresh=2;
                    }
                    break;
                case CONTROL+'r':
                    par->style&=~0x0c;
                    par->style|=0;
                    refresh=1;
                    break;
                case CONTROL+'l':
                    par->style&=~0x0c;
                    par->style|=4;
                    refresh=1;
                    break;
                case CONTROL+'z':
                    par->style&=~0x0c;
                    par->style|=8;
                    refresh=1;
                    break;
                case CONTROL+'e':
                    par->style^=0x03;
                    refresh=1;
                    break;
                case CONTROL+'h':
                    hebmode=!hebmode;
                    break;
                case K_ENTER: 
                    split_par(par,pos);
                    refresh=0x601;
                    ret=K_LEFT;
                    break;
                case CONTROL+'q':
                    refresh=0x1101;
                    break;
                case K_HOME:
                    pos=0;
                    refresh=2;
                    break;
                case K_END:
                    pos=strlen(par->text);
                    refresh=2;
                    break;
                case CONTROL+'p': 
                case K_F3: 
                case K_F10: 
                case CONTROL+K_END:
                case CONTROL+K_HOME:
                    ret=ch;
                    break;
                case K_F1: 
                    j=0;
                    while((j<par->numfontchanges-1)&&(pos>=par->fontchangepos[j+1]))j++;
                    if((i=choose_font(fonts[par->fontchange[j]]->face->family_name,
                        	      fonts[par->fontchange[j]]->height>>6,
                    		      fonts[par->fontchange[j]]->face->style_flags))>=0) {
                        insert_fontchange(par,pos,i);
                        refresh=0x901;
                    }
                    break;
                case K_F2:
                    choose_file_name("Save as:",filename);
                    if(strlen(filename)>0)save(filename);
                    break;
                case K_F4:
                    choose_parameters(par);
                    refresh=0x1101;
                    break;
            }
        } 
    	if(refresh) { 
            display_par(par,pos,refresh);
            refresh=2; /* always refresh cursor */
        }
        if(ret)return ret;
        if(!refresh && cursor_height)
            restore_area(cursor_x,cursor_y,4*screen_bpp,cursor_height,cursor_buf2);
    }

    return 0;
}

int main()
{
    int i;
    int n;
    par_t *par;

    fontsnum=0;
    init_fonts();

    readconfigfile();
    
    init_graphics();

    drawline(0,top_skip-1,display_width-1,top_skip-1,color_decor);
    drawline(left_skip-1,0,left_skip-1,display_pix_height-1,color_decor);

    if(open_ui_font("Arial",0,12<<6,UDPI)) {
        printf("Error openning ui font.\n");
        close_graphics();
        exit(1);
    } 

    if(open_font("Arial",0,12<<6,DPI)) {
        printf("Error openning default font.\n");
        close_graphics();
        exit(1);
    } 

    ui_unit=(fonts[0]->face->height*fonts[0]->height*UDPI/72/fonts[0]->face->units_per_EM)>>6;
    ui_x=DPI;
    ui_y=DPI;
    ui_height=10*ui_unit;
    ui_width=15*ui_unit;
    
    ft_fg=color_fg;
    ft_bg=color_bg;
    ft_transparent=1;
    
    hebmode=1;

    first_par=NULL;
    last_par=NULL;
    filename[0]=0;

    strcpy(filename,"/tmp/peace.bd");
    
    first_par=new_par(NULL);
    last_par=first_par;    

    par=first_par;
    par->par_point_ypos=0;
    n=0;
    ystart=0;
    
    while ((i=edit_par(par,n))!=K_F10) {
        switch(i) {
            case K_LEFT:
                par=par->next;
                n=0;
                break;
            case K_RIGHT:
                par=par->prev;
                n=strlen(par->text);
                break;
            case CONTROL+'p':
                print_ps();
                n=-1;
                break;
            case K_F3:
                while(first_par!=NULL)del_par(first_par);
                choose_file_name("Load filename:",filename);
                if(load(filename)==-1) {
                    printf("Can't read %s\n",filename);
                }
                n=-2;
                ystart=0;
                par=first_par;
                break;
            case CONTROL+K_HOME:
                par=first_par;
                n=0;
                break;
            case CONTROL+K_END:
                par=last_par;
                n=strlen(par->text);
                break;
        }
                
    }
    
    close_graphics();
    
    return 0;
}

