#include <fribidi/fribidi.h>

#include "bd.h"

int break_paragraph(par_t *par, int len, int dpi, int pos, int *bdx, int *bdline, int *bdcd)
{
    int last, line, i, x, brk;
    FriBidiChar unistr[1024], unistr2[1024];
    FriBidiCharType base, parbase;
    unsigned char tmpstr[1024];
    guint16 positions[MAXPARCHARS];
    gint8 embedings[1024];
    int j;
    int width;
    FT_font *fnt;
    int fc;
    int oldheight;

    par->font=fonts[par->fontchange[0]];
    for(i=1;i<par->numfontchanges;i++)if(par->font->face->height*par->font->height/par->font->face->units_per_EM<
                 fonts[par->fontchange[i]]->face->height*fonts[par->fontchange[i]]->height/
                 fonts[par->fontchange[i]]->face->units_per_EM)
			par->font=fonts[par->fontchange[i]];
    par->line_point_height=(par->font->face->height*(par->font->height>>6)/par->font->face->units_per_EM);
    par->line_pix_height=(par->font->face->height*(par->font->height>>6)*dpi/72/par->font->face->units_per_EM);

    if(!len) {
        par->numlines=1;
        if(par->lines[0]==NULL) {
            par->lines[0]=malloc(sizeof(line_t));
        }
        par->lines[0]->st=0;
        par->lines[0]->end=0;
        par->lines[0]->len=0;
        par->lines[0]->width=0;
        par->lines[0]->height=par->line_point_height;
        par->lines[0]->yoffs=par->firstlineskip;
        par->par_point_height=par->line_point_height+par->firstlineskip;
	if(pos>=0) {
            *bdline=0;
            *bdx=0;
            *bdcd=1;
        }
        return 1;
    }

    switch(par->style&3) {
        case 0:
            parbase=FRIBIDI_TYPE_R;
            break;
        case 3:
            parbase=FRIBIDI_TYPE_L;
            break;
        default:
            parbase=FRIBIDI_TYPE_N;
            break;
    }
    width=par->par_point_width*dpi*8/9; 
    last=0;
    line=0;
    if(par->lines[line]==NULL) {
        par->lines[line]=malloc(sizeof(line_t));
    }
    i=0;
    if((par->style&0x1c)==0)
        x=par->firstlineindent*dpi*8/9; else x=0;
    fnt=fonts[par->fontchange[0]];
    fc=1;
    
    for(;;) {
        while((x<width) && par->text[i] && (i<len)) {
            x+=(fnt->chars[par->text[i]].metrics.horiAdvance);
            i++;
            if(i==par->fontchangepos[fc]) {
                fnt=fonts[par->fontchange[fc]];
                fc++;
            }
        }
    
        if(x>=width) {
            i--;
            if(i==par->fontchangepos[fc-1]-1) {
                fc--;
                fnt=fonts[par->fontchange[fc-1]];
            }
        }
    
        if((!par->text[i]) || (i==len)) {
            if(!par->text[i]) { 
                i--;
                if(i==par->fontchangepos[fc-1]-1) {
                    fc--;
                    fnt=fonts[par->fontchange[fc-1]];
                }
            }

            par->lines[line]->end=par->text[i] ? i : i-1;
            par->lines[line]->len=par->lines[line]->end-last+1;
            par->lines[line]->width=x>>6;
            par->lines[line]->st=last;
            par->lines[line]->height=par->line_point_height;
            par->lines[line]->yoffs=par->line_point_height*line+par->lineskip*(line)+par->firstlineskip;
            par->lines[line]->yskip=0;

            base=parbase;
	    strncpy(tmpstr,&par->text[last],par->lines[line]->len);
            fribidi_iso8859_8_to_unicode(tmpstr, unistr);
            fribidi_log2vis(unistr,par->lines[line]->len,
                		&base,unistr2,par->v2l+par->lines[line]->st,positions,embedings);
            fribidi_unicode_to_iso8859_8(unistr2, par->lines[line]->len, tmpstr);
	    strncpy(&par->vistext[last], tmpstr, par->lines[line]->len);

            if((pos>last)&&(pos<=i)) {
                *bdline=line;
                pos-=last;
                *bdcd=embedings[pos];
                if(pos<par->lines[line]->len) pos=positions[pos];
                *bdx=0;
                for(j=0;j<=pos;j++) {
    		    int m,k;
                    m=0;
                    k=par->v2l[j+last]+last;
                    while((m<par->numfontchanges-1)&&(k>=par->fontchangepos[m+1]))m++;
                    fnt=fonts[par->fontchange[m]];
                    *bdx+=(fnt->chars[par->vistext[last+j]].metrics.horiAdvance);
                }
                *bdx>>=6;
            } else  
                if(pos>i) { 
                    *bdx=0; 
                    *bdline=line; 
                    *bdcd=embedings[i-last];
                } else if(pos==last) { 
                    *bdx=par->lines[line]->width; 
                    *bdline=line; 
                    *bdcd=embedings[0];
                }
            par->numlines=line+1;
            oldheight=par->par_point_height;
            par->par_point_height=par->lines[line]->yoffs+par->lines[line]->height;
            if(par->par_point_height!=oldheight)return 1;
            return 0;
        }
        
        brk=i;
    
        if(brk<=last+1)return -1;
    
        while((par->text[i]!=' ')&&i>last) {
            x-=(fnt->chars[par->text[i]].metrics.horiAdvance);
            i--;
            if(i==par->fontchangepos[fc-1]-1) {
                fc--;
                fnt=fonts[par->fontchange[fc-1]];
            }
        }
        
        if(i==last) {
            x=0;
            for(i=last;i<brk;) {
                x+=(fnt->chars[par->text[i]].metrics.horiAdvance);
                if((++i)==par->fontchangepos[fc]) {
                    fnt=fonts[par->fontchange[fc]];
                    fc++;
                }    
            }
            i--;
            if(i==par->fontchangepos[fc-1]-1) {
                fc--;
                fnt=fonts[par->fontchange[fc-1]];
            }
        }

        while((par->text[i]==' ')&&i>last) {
            x-=(fnt->chars[par->text[i]].metrics.horiAdvance);
            i--;
            if(i==par->fontchangepos[fc-1]-1) {
                fc--;
                fnt=fonts[par->fontchange[fc-1]];
            }
        }

        par->lines[line]->st=last;
        par->lines[line]->end=i;
        par->lines[line]->width=x>>6;
        par->lines[line]->len=i-last+1;
        par->lines[line]->height=par->line_point_height;
        par->lines[line]->yoffs=par->line_point_height*line+par->lineskip*(line)+par->firstlineskip;
        par->lines[line]->yskip=0;

        base=parbase;
	strncpy(tmpstr,&par->text[last],par->lines[line]->len);
        tmpstr[par->lines[line]->len]=0;
        fribidi_iso8859_8_to_unicode(tmpstr, unistr);
        fribidi_log2vis(unistr,par->lines[line]->len,
            		&base,unistr2,par->v2l+par->lines[line]->st,positions,embedings);
        fribidi_unicode_to_iso8859_8(unistr2, par->lines[line]->len, tmpstr);
	strncpy(&par->vistext[last], tmpstr, par->lines[line]->len);

        if((pos>last)&&(pos<=i)) {
            *bdline=line;
            pos-=last;
            *bdcd=embedings[pos];
            if(pos<par->lines[line]->len) pos=positions[pos];
            *bdx=0;

            for(j=0;j<=pos;j++) {
    		int m,k;
                FT_font *fnt;

                m=0;                
                k=par->v2l[j+last]+last;
                while((m<par->numfontchanges-1)&&(k>=par->fontchangepos[m+1]))m++;
                fnt=fonts[par->fontchange[m]];
                *bdx+=(fnt->chars[par->vistext[last+j]].metrics.horiAdvance);
            }
            *bdx>>=6;
        } else  
            if(pos>i) { 
                *bdx=-(((fnt->chars[32].metrics.horiAdvance))*(pos-i-1))>>6; 
                *bdline=line;
                *bdcd=embedings[i-last];
            } else            
                if(pos==last) { 
                    *bdx=par->lines[line]->width; 
                    *bdline=line;
                    *bdcd=embedings[0];
                }

	x=0;
        i++;
        if(i==par->fontchangepos[fc]) {
            fnt=fonts[par->fontchange[fc]];
            fc++;
        }    

        while(par->text[i]==' ') {
            i++;
            if(i==par->fontchangepos[fc]) {
                fnt=fonts[par->fontchange[fc]];
                fc++;
            }
        }
        last=i;
	line++;
        if(par->lines[line]==NULL) {
            par->lines[line]=malloc(sizeof(line_t));
        }
    }
}

int reformat(int flags, int dpi, par_t *par)
/*
    bit 0 - break all paragraphs
    bit 1 - break this par
    bit 2 - break next par
    bit 3 - only height changes are in breaking paragraphs
*/
{
    par_t *tmp;
    int ypos;
    
    if(par==NULL)return 0;

    tmp=par;
    
    if(tmp==first_par) {
        ypos=0;
    } else {
        ypos=tmp->prev->par_point_ypos+tmp->prev->par_point_height;
    }

    while(tmp!=NULL) {
        tmp->par_point_ypos=ypos;
        break_paragraph(tmp,strlen(tmp->text),dpi,-1,NULL,NULL,NULL);
        ypos+=tmp->par_point_height;
        tmp=tmp->next;
    }
    return 0;
}
