#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include "bd.h"

static char basedir[128];
FT_font *fonts[256];
FT_font *ui_font;
font_file_t *fontfiles[MAXFONTFILES];
int fontfilesnum;
int fontsnum;

int select_font(const struct dirent *dirent) {
    char tmp[256],fam[128]; 
    int ff,sf;
    int i;
    
    if(fontfilesnum==MAXFONTFILES)return 0;
    strcpy(tmp,basedir);
    strcat(tmp,dirent->d_name);    
    if(checkfontencoding(tmp,&ff,&sf,fam)==15) {
        i=0;
        while((i<fontfilesnum) && strcmp(fontfiles[i]->family,fam))i++;
        if(i==fontfilesnum) {
            fontfiles[i]=malloc(sizeof(font_file_t));
            strncpy(fontfiles[i]->family,fam,47);
            fontfiles[i]->style_flags=0;
            fontfiles[i]->face_flags=0;
            fontfiles[i]->flags=0;
            fontfilesnum++;
        }
        if((sf>=0) && (sf<4)) {
            strncpy(fontfiles[i]->fname[sf],tmp,175);
            fontfiles[i]->style_flags|=(1<<sf);
            fontfiles[i]->face_flags=ff; /* last one sets */
        }
    }
    return 0;
}

int compare_fonts(const void *p1, const void *p2) {
    font_file_t *f1, *f2;
    
    f1= *(font_file_t **)p1;
    f2= *(font_file_t **)p2;
    return strcmp(f1->family,f2->family);
}

int init_fonts()
{
    fontfilesnum=0;
    
    strncpy(basedir,"/usr/X11R6/lib/X11/fonts/ttfonts/office/",128);
    scandir(basedir,NULL,select_font,NULL);
    strncpy(basedir,"/usr/X11R6/lib/X11/fonts/ttfonts/winfonts/",128);
    scandir(basedir,NULL,select_font,NULL);
    strncpy(basedir,"/usr/X11R6/lib/X11/fonts/ttfonts/",128);
    scandir(basedir,NULL,select_font,NULL);
    
    qsort(fontfiles, fontfilesnum, sizeof(font_file_t *),compare_fonts);
    
    return fontfilesnum;

}

int open_font(char *fam, int style, int size, int DPI) {
    int i,j;
    char fname[192];
    
    j=0;
    while(j<fontsnum) {
        if((fonts[j]->height==size) &&
           (fonts[j]->face->style_flags==style) &&
           !strcmp(fam,fonts[j]->face->family_name)) return j;
        j++;
    }

    for(i=0;i<fontfilesnum;i++) {
        if(!strcmp(fontfiles[i]->family,fam)) {
            if ((fontfiles[i]->style_flags&(1<<style))==0) return -1;
            strcpy(fname,fontfiles[i]->fname[style]);
            fonts[j]=malloc(sizeof(FT_font));
            loadfont(fonts[j],fname, 0, size, DPI, DPI);
            if(fonts[j]->face->height<fonts[j]->face->bbox.yMax-fonts[j]->face->bbox.yMin)
                fonts[j]->face->height=fonts[j]->face->bbox.yMax-fonts[j]->face->bbox.yMin;
            fontsnum++;
            return j;
        }
    }
    
    return -1;
}

int open_ui_font(char *fam, int style, int size, int DPI) {
    int i;
    char fname[192];
    
    for(i=0;i<fontfilesnum;i++) {
        if(!strcmp(fontfiles[i]->family,fam)) {
            if ((fontfiles[i]->style_flags&(1<<style))==0) return -1;
            strcpy(fname,fontfiles[i]->fname[style]);
            ui_font=malloc(sizeof(FT_font));
            loadfont(ui_font,fname, 0, size, DPI, DPI);
            if(ui_font->face->height<ui_font->face->bbox.yMax-ui_font->face->bbox.yMin)
                ui_font->face->height=ui_font->face->bbox.yMax-ui_font->face->bbox.yMin;
            return 0;
        }
    }
    
    return -1;
}

