#include "ft.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define MAXPARCHARS 1024

#define DISPWIDTH (WIDTH*DPI/72)
#define POINTSIZE 12
#define MAXFONTFILES 256

extern int PDPI;
extern int DPI;
extern int UDPI;
extern int WIDTH;
extern int left_skip;
extern int top_skip;
extern int vis_width;
extern int vis_height;
extern int vis_pix_height;
extern int vis_pitch;

extern int display_width;
extern int display_height;
extern int display_pix_height;

extern int page_width;
extern int page_height;
extern int page_right_margin;
extern int page_left_margin;
extern int page_top_margin;
extern int page_bottom_margin;

extern int color_fg;
extern int color_bg;
extern int color_uitext;
extern int color_selected;
extern int color_cursor;
extern int color_decor;

extern int ui_unit;
extern int ui_x;
extern int ui_y;
extern int ui_height;
extern int ui_width;

typedef struct {
    int st;
    int end;
    int height;
    int width;
    int len;
    int yskip;
    int yoffs; /* relative to paragraph */
} line_t;

/* 
par_t.style is a bitfield
    0-1 language direction
    2-3 alignment/justification
    4   margin is from right/left
*/

typedef struct par_type {
/* those are "cache" values. They can be calculated */
    int line_pix_height;
    int line_point_height;
    int par_point_height;
    int par_point_ypos;
    int numlines;
    int lastline;
    unsigned char *vistext;
    guint16 *v2l;
    line_t *lines[100];
/* this should be selected as the tallest of all fonts used */
    FT_font *font; 
    int ascender;
    
/* Those define the paragraph */
    int par_point_width;
    int par_point_margin;
    int style;
    int lineskip;
    int firstlineskip;
    int firstlineindent;

    unsigned char *text;

    int numfontchanges;
    int fontchange[64];
    int fontchangepos[64];
    
    struct par_type *next;
    struct par_type *prev;
} par_t;

typedef struct font_file_type {
    char family[48];
    char fname[4][176];
    int flags;
    int style_flags;
    int face_flags;
} font_file_t;

extern FT_font *fonts[256];
extern FT_font *ui_font;
extern font_file_t *fontfiles[MAXFONTFILES];
extern int fontfilesnum;
extern int fontsnum;
extern par_t *first_par, *last_par;

extern int choose_font(char *, int, int);
extern int choose_file_name(char *, char *);
extern int choose_parameters(par_t *);

int save_area(int, int, int, int, char *);
int restore_area(int, int, int, int, char *);
int blank_area(int, int, int, int);
int init_graphics();
int close_graphics();
int drawline(int, int, int, int, int);

extern int readchar();
extern int open_font(char *, int, int, int);
extern int open_ui_font(char *, int, int, int);

extern par_t *new_par(par_t *);
extern int insert_par(par_t *, par_t *);
extern int del_par(par_t *par);

extern int break_paragraph(par_t *, int, int, int, int *, int *, int *);
extern int reformat(int, int, par_t *);

extern int save(char *);
extern int load(char *);
extern int init_fonts();

extern int print_ps();

extern void writen(int, int, int, unsigned char *, par_t *, int);

extern int split_par(par_t *, int);
extern int join_par(par_t *);
extern int insert_char(par_t *, int, int);

extern int readconfigfile(void);

extern int translate_keycode(int, int);
