#include <PceNativeCall.h>
#include <CoreTraps.h>
#include <stddef.h>
#include <Standalone.h>

#include "endian.h"
#include "armlet-ids.h"

STANDALONE_CODE_RESOURCE_ID (malloc_and_write_id);

void *PalmOS_MemPtrNew (const void *emulStateP, Call68KFuncType *call68KFuncP,
			size_t size) {
  unsigned long size_m68k = ByteSwap32 (size);

  return (void *) call68KFuncP (emulStateP, PceNativeTrapNo (sysTrapMemPtrNew),
				&size_m68k, 4 | kPceNativeWantA0);
  }

void *malloc_and_write (const void *emulStateP, void *userData68KP,
			Call68KFuncType *call68KFuncP) {
  char *buffer = PalmOS_MemPtrNew (emulStateP, call68KFuncP, 10);

#if 0
  /* Dammit this induces a GOT.  */
  memcpy (buffer, "ABCDEFGHI", 10);
#else
  int i;
  for (i = 0; i < 9; i++)  buffer[i] = 'A' + i;
  buffer[9] = '\0';
#endif

  return buffer;
  }
