#include <PalmOS.h>
#include <PceNativeCall.h>

#include <stdio.h>

#include "armlet-ids.h"

UInt32
PilotMain (UInt16 cmd, void *params, UInt16 flags) {
  if (cmd == sysAppLaunchCmdNormalLaunch) {
    struct { UInt32 a, b; 
			 UInt32 r[10];} p;
    char *letters;
    EventType e;
	int mul, div;

    MemHandle addH = DmGetResource ('armc', add_id);
    void *add = MemHandleLock (addH);
    MemHandle mawH = DmGetResource ('armc', malloc_and_write_id);
    void *maw = MemHandleLock (mawH);

    /* Check results from add().  */

    p.a = 37;
    p.b = 29;
    //printf ("add() %s,  %li\n",
	//    (PceNativeCall (add, &p) == 37 + 29)? "okay" : "failed", PceNativeCall (add, &p));

	PceNativeCall (add, &p);
	printf("rtc r0=%02lx, r1=%02lx, r2=%02lx\n", p.r[0], p.r[1], p.r[2]);
	printf("dpll1=%04lx ckctl=%04lx\n", p.r[3], p.r[4], p.r[5]);
	printf("tim1 c=%02lx, l=%lx, r=%lx\n", p.r[6], p.r[7], p.r[8]);

	mul=(p.r[3]&0xf80)>>7;
	div = ((p.r[3]&0x60)>>5)+1;

	printf("m=%i d=%i f=%iMHz\n", mul, div, 12*mul/div);
    /* Check results from malloc_and_write().  */
#if 0
    letters = (void *) PceNativeCall (maw, NULL);
    if (letters) {
      if (StrCompare (letters, "ABCDEFGHI") == 0)
	puts ("maw okay");
      else
	printf ("maw failed: %s\n", letters);
      MemPtrFree (letters);
      }
    else
      puts ("maw returned NULL!");
#endif
    MemHandleUnlock (addH);
    MemHandleUnlock (mawH);

    /* Give us time to see what happened.  */

    do {
      EvtGetEvent (&e, evtWaitForever);
      SysHandleEvent (&e);
      } while (e.eType != appStopEvent);
    }
  
  return 0;
  }
