
#ifdef STANDALONE
#include <stdlib.h>
#include <stdio.h>
#define FRAMECOLOUR 0xff0000
#define TEXTCOLOUR 0xffffff
#else
#define FRAMECOLOUR 2
#define TEXTCOLOUR 7
#endif

#define WIDTH 280
#define HEIGHT 104

int vl[5][13]= {
	{20, 41, 62, 83, 104, 125, 146, 167, 188, 209, 230, 251, 281},
	{31, 52, 73, 94, 115, 136, 157, 178, 199, 220, 241, 261, 281},
	{31, 57, 78, 99, 120, 141, 162, 183, 204, 225, 246, 281, 281},
	{47, 68, 89, 110, 131, 152, 173, 194, 215, 236, 281, 281,281},
	{21, 42, 63, 84, 105, 199, 220, 240, 259, 281, 281, 281, 281} };

/* true		\020
 * inv		\021
 * delete	\022
 * graph	\023
 * extend	\011 (tab) 
 * edit		\025
 * caps shf \026
 * caps lck	\027
 * symbol	\030
 * break	\031
 * left		\032
 * right	\033
 * up		\034
 * down		\035
 */
unsigned char trans[65]="\020\0211234567890\031\022\023qwertyuiop\n\t\025asdfghjkl\n\n\026\027zxcvbnm.\026\n\n\030;\"\032\033 \034\035,\030\n\n\n";

struct txt {
	unsigned char s[13];
	int x, y, t; /* type 1-main, 2-extra keys 4-K 8-SS 128-big font */
} text[] = {
	{ "TRUE", 3, 5, 2},
	{ "VIDEO", 2, 11, 2},
	{ "INV", 26, 5, 2},
	{ "VIDEO", 23, 11, 2},
	{ "DELETE", 6, 29, 2},
	{ "GRAPH", 32, 29, 2},
	{ "EXTEND", 6, 47, 2},
	{ "MODE", 9, 53, 2},
	{ "EDIT", 39, 50, 2},
	{ "CAPS SHIFT", 6, 71, 2},
	{ "CAPS", 51, 67, 2},
	{ "LOCK", 51, 73, 2},
	{ "SYMBL", 1, 87, 2},
	{ "SHIFT", 2, 93, 2},
	{ "BREAK", 257, 8, 2},
	{ "ENTER", 254, 50, 2}, 
	{ "CAPS SHIFT", 241, 71, 2},
	{ "SYMBL", 260, 87, 2},
	{ "SHIFT", 261, 93, 2},
	{ "\200\201", 88, 89, 2}, /* right */
	{ "\202\203", 88, 94, 2},
	{ "\205\204", 65, 89, 2}, /* left */
	{ "\207\206", 65, 94, 2},
	{ "\210\211", 206, 89, 2}, /* up */
	{ "\212\213", 206, 94, 2},
	{ "\216\217", 227, 94, 2}, /* down */
	{ "\214\215", 227, 89, 2},
	{ "\220", 225, 73, 2}, /* . */
	{ "\221", 251, 93, 2}, /* , */
	{ "\220", 31, 90, 2}, /* ; */
	{ "\221", 31, 94, 2},
	{ "\222", 52, 89, 2},
	{ "!", 60, 2, 8},
	{ "@", 78, 2, 8},
	{ "#", 99, 2, 8},
	{ "$", 121, 2, 8},
	{ "%", 140, 2, 8},
	{ "&", 162, 2, 8}, 
	{ "'", 186, 2, 8},
	{ "(", 206, 2, 8},
	{ ")", 227, 2, 8},
	{ "_", 248, 2, 8},
	{ "<=", 66, 22, 8},
	{ "<>", 86, 36, 8},
	{ ">=", 108, 22, 8},
	{ "<", 132, 22, 8},
	{ ">", 153, 22, 8},
	{ "AND", 167, 32, 8},
	{ "OR", 191, 22, 8},
	{ "AT", 211, 22, 8},
	{ "^", 179, 43, 8},
	{ "-", 201, 43, 8},
	{ "+", 221, 43, 8},
	{ "=", 243, 43, 8},
	{ ":", 87, 64, 8},
	{ "~", 105, 64, 8},
	{ "?", 127, 64, 8},
	{ "/", 148, 64, 8},
	{ "*", 167, 64 ,8},
	{ "ST", 71, 43, 8},
	{ "OP", 71, 49, 8},
	{ "NO", 92, 43, 8},
	{ "T", 94, 49, 8},
	{ "ST", 113, 43, 8},
	{ "EP", 113, 49, 8},
	{ "TO", 134, 43, 8},
	{ "TH", 155, 43, 8},
	{ "EN", 155, 49, 8},
	{ "", -1, -1, -1}
};

int sf[128][6]= {
	{1, 0},
	{1, 1, 1, 1, 0, 1},
	{3, 5, 5, 0, 0, 0},
	{4, 6, 15, 6, 15, 6},
	{3, 2, 7, 7, 7, 2},
	{5, 17, 8, 4, 2, 17},
	{3, 2, 5, 2, 5, 6},
	{1, 1, 1, 0, 0, 0},
	{2, 2, 1, 1, 1, 2},
	{2, 1, 2, 2, 2, 1},
	{5, 21, 14, 31, 14, 21},
	{3, 0, 2, 7, 2, 0},
	{2, 0, 0, 0, 2, 1},
	{2, 0, 0, 3, 0, 0},
	{1, 0, 0, 0, 0, 1},
	{3, 4, 4, 2, 1, 1},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{1, 0, 1, 0, 1, 0}, /* : */
	{2, 0, 2, 0, 2, 1},
	{3, 4, 2, 1, 2, 4},
	{2, 0, 3, 0, 3, 0},
	{3, 1, 2, 4, 2, 1},
	{3, 2, 5, 4, 0, 2},
	{4, 6, 9, 1, 13, 6},
	{3, 7, 5, 7, 5, 5}, /* A */
	{3, 3, 5, 3, 5, 3},
	{2, 2, 1, 1, 1, 2},
	{3, 3, 5, 5, 5, 3},
	{2, 3, 1, 3, 1, 3},
	{2, 3, 1, 3, 1, 1},
	{3, 2, 5, 1, 7, 3},
	{3, 5, 5, 7, 5, 5},
	{1, 1, 1, 1, 1, 1},
	{},
	{3, 5, 5, 3, 5 ,5},
	{2, 1, 1, 1, 1, 3},
	{4, 9, 15, 15, 9, 9},
	{3, 5, 7, 7, 7, 5},
	{3, 2, 5, 5, 5, 2},
	{3, 3, 5, 3, 1, 1},
	{3, 2, 5, 5, 7, 3},
	{3, 2, 5, 3, 3, 5},
	{3, 6, 1, 2, 4, 3},
	{3, 7, 2, 2, 2, 2},
	{3, 5, 5, 5, 5, 2},
	{3, 5, 5, 3, 3, 1},
	{4, 5, 5, 7, 7, 5},
	{3, 5, 5, 2, 5, 5},
	{3, 5, 5, 2, 2, 2},
	{3, 7, 4, 2, 1, 7}, /* Z */
	{2, 3, 1, 1, 1, 3}, 
	{3, 1, 1, 2, 4, 4},
	{2, 3, 2, 2, 2, 3},
	{3, 2, 5, 0, 0, 0},
	{2, 0, 0, 0, 0, 3},
	{3, 2, 7, 2, 2, 2}, /* Up arrow */
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{},
	{8, 0, 0, 255, 1, 1 }, /* right arrow - 128-131 */
	{8, 3, 5, 9, 16, 32},
	{8, 1, 255, 0, 0, 0 },
	{8, 16, 9, 5, 3, 0 },
	{8, 0, 0, 255, 128, 128 }, /* left arrow - 132-135 */
	{8, 192, 160, 144, 8, 4},
	{8, 128, 255, 0, 0, 0 },
	{8, 8, 144, 160, 192, 0 },
	{5, 16, 8, 4, 2, 7}, /* up */
	{4, 0, 1, 2, 4, 14},
	{5, 4, 4, 4, 4, 28},
	{4, 2, 2, 2, 2, 3},
	{5, 28, 4, 4, 4, 4}, /* down */
	{4, 3, 2, 2, 2, 2},
	{5, 7, 2, 4, 8, 16},
	{4, 14, 4, 2, 1, 0},
	{2, 3, 3, 0, 0, 0}, /* . */
	{2, 3, 3, 2, 1, 0}, /* , */
	{7, 119, 51, 17, 0, 0}, /* " */
};

#ifdef STANDALONE
void writeppm(unsigned char *c, int x, int y) {
	printf("P6\n%i %i\n255\n", x, y);
	fwrite(c, 1, x*y*3, stdout);
}
#endif


#ifdef STANDALONE
unsigned char b[WIDTH*HEIGHT*3];

#define putpix(x, y, c) do {b[((y)*WIDTH+(x))*3]=(c>>16)&0xff;  \
	b[((y)*WIDTH+(x))*3+1]=(c>>8)&0xff;  \
	b[((y)*WIDTH+(x))*3+2]=(c)&0xff; \
} while(0)

#define hline(y, x1, x2, c){ int ii; for(ii=x1;ii<x2;ii++)putpix(ii,y,c); }
#define vline(x, y1, y2, c){ int ii; for(ii=y1;ii<y2;ii++)putpix(x,ii,c); }

#else

#define putpix(x,y,c) sc[(((UInt32)y)+216)*320+x+20]=c;
#define hline(y, x1, x2, c){ int ii; for(ii=x1;ii<x2;ii++)putpix(ii,y,c); }
#define vline(x, y1, y2, c){ int ii; for(ii=y1;ii<y2;ii++)putpix(x,ii,c); }
#endif

int drawchar(int x, int y, int c, int col) {
	c-=32;
	if(sf[c][0]) {
		int l,m;
		for(l=0;l<5;l++) {
			int k;
			k=sf[c][l+1];
			for(m=0;m<sf[c][0];m++) {
				if(k&1)putpix(x+m, y+l, col);
				k>>=1;
			}
		}
		return sf[c][0]+(c<96);
	}
	return 0;
}

void drawstring( unsigned char *s, int x, int y, int c) {
	while(*s) {
		x+=drawchar(x, y, *s, c);
		s++;
	}
}

void drawtext(int t, int c) {
	int i;

	i=0;
	while(text[i].x>=0) {
		if(text[i].t&t) drawstring(text[i].s, text[i].x, text[i].y, c);
		i++;
	}
	
}

void drawalnum(void) {
	int i,j;

	WinPushDrawState();
	WinSetTextColor(7);
	WinSetBackColor(0);
	for(i=0;i<4;i++)
		for(j=1;j<13;j++) {
			int c;
			c=trans[i*13+j];
			if( (c>='0' && c<='9') || (c>='a' && c<='z')) {
				if(c>='a')c&=0xdf;
				WinDrawChar( c, 20+vl[i][j-1]+1, 216+i*21-(2*(c=='W')));
			}
		}
	
	WinPopDrawState();
	
}

void drawframe(int c) {
	int i,j;

//	for(i=0;i<HEIGHT;i++) hline(i, 0, WIDTH, 0);

	hline(0,0,WIDTH,c);
	hline(HEIGHT-1,0,WIDTH,c);
	vline(0,0,HEIGHT,c);
	vline(WIDTH-1,0,HEIGHT,c);

	for(i=20;i<105;i+=21) {
		if(i<104)hline(i, 0, WIDTH, c);
		for(j=0;j<12;j++) {
			if(vl[i/21][j]<WIDTH) {
				vline(vl[i/21][j], i-20, i, c);
			}
		}
	}

	hline(41, 262, WIDTH-1, 0);
}

int xytochar(int x, int y) {
	int l, c;
	if((x<0) || (x>=WIDTH) || (y<0) ||(y>=HEIGHT)) return -1;
	if(((y+1)%21) == 0) return -2;
	l=y/21;
	c=x/30;
	while(vl[l][c]<x)c++;
	if(x==vl[l][c])return -3;
	return trans[l*13+c];	
}

void draw_reset(void) {
	unsigned char b[16];

	MemSet(b, 12, 1);
	MemMove(sc+280L*320+2, b, 12);
	MemMove(sc+291L*320+2, b, 12);
	MemSet(b+1, 10, 0);
	MemMove(sc+281L*320+2, b, 12);
	MemMove(sc+282L*320+2, b, 12);
	MemMove(sc+283L*320+2, b, 12);
	MemMove(sc+284L*320+2, b, 12);
	MemMove(sc+287L*320+2, b, 12);
	MemMove(sc+288L*320+2, b, 12);
	MemMove(sc+289L*320+2, b, 12);
	MemMove(sc+290L*320+2, b, 12);
	MemSet(b+5, 2, 1);
	MemMove(sc+285L*320+2, b, 12);
	MemMove(sc+286L*320+2, b, 12);
	
}

void drawkeyboard(int kdisp) {
		UInt32 i;
		
		for(i = 216L*320; i < (UInt32)320 * 320 ; i++)
			sc[i] = 0;
		
		switch(kdisp) {
			case 0:
				break;
			case 1:
				drawalnum();
				drawframe(FRAMECOLOUR);
				drawtext(10, TEXTCOLOUR);
				draw_reset();
				break;
			case 2:
				drawframe(FRAMECOLOUR);
				drawtext(10, TEXTCOLOUR);
				break;
		}

}

int charmap(int c) {
	if(c>' ') return c;
	switch(c) {
		case 0:
			return ' ';
		case 1:
			return '>';
		case 2:
			return '<';
		case 3:
			return 'V';
		case 4:
			return '^';
		case 5:
			return 141;
		case 10:
		case 13:
			return 'E';
		case ' ':
			return 95;
		case 24:
			return 167;
		case 22:
			return 169;
	}
	return 127;
}

#ifdef STANDALONE
int main(int argc, char *argv[]) {

	drawframe(FRAMECOLOUR);	
	
	drawtext(2, TEXTCOLOUR);

//	writeppm(b, WIDTH, HEIGHT);

	printf("%i   %i    %i   %i\n", xytochar(30,60), xytochar(41,100), xytochar(210,3), xytochar(171,45));

	return 0;	

}
#endif
