/************************************************************************
 *  palmstd.c
 *                      
 *
 ************************************************************************
 *
 * PalmSpec,
 * Spectrum emulator for PalmOS(R)
 *
 * (c)2002 Alex Bassas Serramia
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 ************************************************************************
 */
#include "const.h"

struct rgb colours[16] = { 
	{0x00, 0x00, 0x00},
	{0x00, 0x00, 0xcf},
	{0xcf, 0x00, 0x00},
	{0xcf, 0x00, 0xcf},
	{0x00, 0xcf, 0x00},
	{0x00, 0xcf, 0xcf},
	{0xcf, 0xcf, 0x00},
	{0xcf, 0xcf, 0xcf},

	{0x00, 0x00, 0x00},
	{0x00, 0x00, 0xff},
	{0xff, 0x00, 0x00},
	{0xff, 0x00, 0xff},
	{0x00, 0xff, 0x00},
	{0x00, 0xff, 0xff},
	{0xff, 0xff, 0x00},
	{0xff, 0xff, 0xff}
};

UCHAR FileDump(UCHAR * mem, UCHAR * file, USHORT start, USHORT len)
{
	UCHAR ret = FALSE;
	LocalID id;
	DmOpenRef ref;
	MemHandle m;
	UCHAR *p;

	id = DmFindDatabase(0, file);
	if(id) {
		ref = DmOpenDatabase(0, id, dmModeReadOnly);
		if(ref) {
			m = DmQueryRecord(ref, 0);
			if((m != NULL)) {
				if(MemHandleSize(m) < start + len)
					len = MemHandleSize(m) - start;
				p = (UCHAR *) MemHandleLock(m);
				p += start;
				MemMove(mem, p, len);
				MemHandleUnlock(m);
				ret = TRUE;
			} else ErrAlert(DmGetLastErr());
			DmCloseDatabase(ref);
		} else ErrAlert(DmGetLastErr());
	} else ErrAlert(DmGetLastErr());
	return (ret);
}

UCHAR FileCreate(UCHAR * file, ULONG size)
{
	LocalID id;
	DmOpenRef ref;
	MemHandle m;
	UInt16 index;

	id = DmFindDatabase(0, file);
	
	if(id != 0) {
		DmDeleteDatabase(0, id);
	}
	
	if(DmCreateDatabase(0, file, 'PSPe', 'Data', FALSE) == errNone) {
		id = DmFindDatabase(0, file);
		if(id != 0) {
			ref = DmOpenDatabase(0, id, dmModeReadWrite);
			if(ref) {
				index = 0;
				m = DmNewRecord(ref, &index, size);
				if(m != 0) {
					DmReleaseRecord(ref, 0, TRUE);
				} else
					ErrAlert(DmGetLastErr());
				DmCloseDatabase(ref);
			} else ErrAlert(DmGetLastErr());
		} else ErrAlert(DmGetLastErr());
	} else ErrAlert(DmGetLastErr());
	return (TRUE);
}


UCHAR filewrite(UCHAR * file, UCHAR * mem, ULONG start, ULONG len, int resize)
{
	LocalID id;
	DmOpenRef ref;
	MemHandle m;
	UCHAR *p;

	id = DmFindDatabase(0, file);
	if(id) {
		ref = DmOpenDatabase(0, id, dmModeReadWrite);
		if(ref) {
			if(resize) m = DmResizeRecord(ref, 0, len); else m = DmGetRecord(ref, 0);
			if(m != NULL) {
				p = (UCHAR *) MemHandleLock(m);
				DmWrite(p, start, mem, len);
				MemHandleUnlock(m);
				DmReleaseRecord(ref, 0, FALSE);
			}
			DmCloseDatabase(ref);
		}
	}
	return (TRUE);
}

void filedelete(UCHAR * file) {
	LocalID id;
	id = DmFindDatabase(0, file);
	if(id != 0) {
		DmDeleteDatabase(0, id);
	}
}

int filesize(UCHAR * file) {
	int ret = -1;
	LocalID id;
	DmOpenRef ref;
	MemHandle m;

	id = DmFindDatabase(0, file);
	if(id) {
		ref = DmOpenDatabase(0, id, dmModeReadOnly);
		if(ref) {
			m = DmQueryRecord(ref, 0);
			if((m != NULL)) {
				ret = MemHandleSize(m);
			}
		}
	}

	return ret;

}	

struct rgb *getrgb(UCHAR color)
{
	return (&colours[color]);
}
