/************************************************************************
 *  palmspec.c
 *                      
 *
 ************************************************************************
 *
 * PalmSpec,
 * Spectrum emulator for PalmOS(R)
 *
 * (c)2002 Alex Bassas Serramia
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 ************************************************************************
 */

#include <PalmOS.h>
#include <PceNativeCall.h>

#include "const.h"
#include "armlet-ids.h"

#include <VFSMgr.h>
#include <StringMgr.h>
#include <SoundMgr.h>

#include "palmchars.h"
#include "keyboard.h"

#define DEBUG 0

#define NUMSNDBUFS 4
#define SNDBUFLEN 441

UInt32 depth = 8;
RGBColorType spalette[16];
UCHAR k = 0;
UCHAR cx = 0, cy = 0;
UCHAR comp = FALSE;
char **list;
UInt16 *snapver;

int nlist = 0;
UCHAR ocolor, oback;
UCHAR icolor = TRUE;

//#ifdef D_SCREEN
UCHAR *sc;
UCHAR m_fc;
UCHAR m_bc;

//#endif
UCHAR *memrom;
UCHAR *memram;
DmOpenRef refrom;
DmOpenRef refram;
MemHandle hanrom;
MemHandle hanram;

struct prefs_t {
	UCHAR sound;
	UCHAR kdisp;
	UCHAR fast;
	UCHAR keymode;
	UCHAR global;
	unsigned char hardkeys[10];
} prefs;

void set_default_prefs(struct prefs_t *prefs) {
	prefs->kdisp=1;
	prefs->fast=2;
	prefs->sound=0;
	prefs->keymode=1;
	prefs->global=0;
	MemMove(prefs->hardkeys, hkeys[0].keys, 9); 
}

struct shared_t {
	UInt32 sc, ram, rom;
	UInt32 sz53_table, halfcarry_add_table, halfcarry_sub_table,
		overflow_sub_table, overflow_add_table, parity_table, sz53p_table,
		tstates, event_next_event;
	unsigned char a, f, b, c, d, e, h, l;
	unsigned char r, a1, f1, b1, c1, d1, e1, h1, l1, i, iff1, iff2, im,
		xx1, xx2, xx3;
	unsigned short pc;
	unsigned short ix, iy, sp;
	Int32 counter;
	unsigned char k[12];
	unsigned char out254;
	unsigned char lastborder;
	unsigned char lastsound;
	unsigned char bcount;
	unsigned char sndsample;
	unsigned char sndread;
	unsigned char sndwrite;
	unsigned char sound[SNDBUFLEN*NUMSNDBUFS];
	Int32 scounter;
} armshared;

SndStreamRef sndref;
int	sndbufsize;

#define VFS 1
#define MAXVFSSNAPS 1000

struct vfssnap {
	char name[128];
	UInt16 volRefNum;
} *vfssnaps[MAXVFSSNAPS];

int vfssnapsnum;
int dbsnapsnum;

#define ROW(i) (i>>4)
#define PRESS(i) (~(1<<(i&15)))
#define RELEASE(i) (1<<(i&15))

#define NUMKEYS (sizeof(keys)/sizeof(keys[1]))

void setkey(int c);
void resetkey(int c);

RectangleType Reset={ {2, 280}, {12,12} };
RectangleType Hide={ {1, 216}, {19,60} };
RectangleType Leave={ {301, 216}, {19,60} };
RectangleType Keyboard={ {20, 216}, {280,104} };

#include "plusk.c"
#include "snapshot.c"
#include "game.c"

void setkey(int c) {
	if(c<NUMKEYS) {
		if(c==keys[c].c) {
			if(keys[c].k1!=-1)armshared.k[ROW(keys[c].k1)]&=PRESS(keys[c].k1);
			if(keys[c].k2!=-1)armshared.k[ROW(keys[c].k2)]&=PRESS(keys[c].k2);
			return;
		}
	}
}

void resetkey(int c) {
	if(c<NUMKEYS) {
		if(c==keys[c].c) {
			if(keys[c].k1!=-1)armshared.k[ROW(keys[c].k1)]|=RELEASE(keys[c].k1);
			if(keys[c].k2!=-1)armshared.k[ROW(keys[c].k2)]|=RELEASE(keys[c].k2);
			return;
		}
	}
}

void init(void) {
	int i;
	UInt16 ps;
	
	ps=0;
	i=PrefGetAppPreferences( 'PSPe', 0x0101, NULL, &ps, 1);

	if(i==3) {
		PrefGetAppPreferences( 'PSPe', 0x0101, &prefs, &ps, 1);
		prefs.global=0;
	} else {
		set_default_prefs(&prefs);
	}

	prefs.global=0;
	
	for(i=0;i<8;i++)armshared.k[i]=0xff;
	armshared.k[8]=0;
	armshared.out254=255;
	armshared.lastborder=0;
	armshared.lastsound=16;

	FileDump(memrom, "SpectrumRom", 0, 16384);
								
	armshared.pc = 0;
	armshared.iff1=0;
	armshared.iff2=0;
	armshared.im=1;
	armshared.r=0x80;

	i=filesize("ArmPalmSpecKeyDef");
	if(i>0) {
		int j;
		dhk=MemPtrNew(i+sizeof(struct hkeys_s));
		FileDump((UCHAR *)dhk, "ArmPalmSpecKeyDef", 0, i);
		j=i/sizeof(struct hkeys_s);
		dhk[j].name[0]='\0';
	} else {
		dhk=MemPtrNew(sizeof(struct hkeys_s));
		dhk[0].name[0]='\0';
	}

}

UInt32 PilotMain(UInt16 cmd, void *cmdPBP, UInt16 launchFlags)
{
	EventType e;
	UInt16 error;
	UCHAR sel;
	UCHAR savedhk[10];
	UCHAR Exit = FALSE;
	
	if(cmd == sysAppLaunchCmdNormalLaunch) {
		int o_bell=0, o[3], i;
		FormType *form=0;
		
		memrom = MemPtrNew(0x4000);
		memram = MemPtrNew(0xc000);
		init();
		MemMove(savedhk, prefs.hardkeys, 9);
		FrmGotoForm(FORM_MAIN);

		do {
			EvtGetEvent(&e, evtWaitForever);
			if(!SysHandleEvent(&e)) {
				if(!MenuHandleEvent(NULL, &e, &error)) {
					switch (e.eType) {
					case frmLoadEvent:
						FrmSetActiveForm(FrmInitForm(e.data.frmLoad.formID));
						form=FrmGetActiveForm();
						o_bell=FrmGetObjectIndex(form, LAB_SOUND);
						o[0]=FrmGetObjectIndex(form, LAB_0);
						o[1]=FrmGetObjectIndex(form, LAB_1);
						o[2]=FrmGetObjectIndex(form, LAB_2);
						
						if(prefs.sound) {
							FrmShowObject(form, o_bell);
						} else {
							FrmHideObject(form, o_bell);
						}
						
						for(i=0;i<3;i++)if(i==prefs.fast) {
							FrmShowObject(form, o[i]);
						} else {
							FrmHideObject(form, o[i]);
						}
						break;
					case frmOpenEvent:
						ListSNA();
						FrmDrawForm(form);
						break;
					case ctlEnterEvent:
						switch (e.data.ctlEnter.controlID) {
							case BUTT_LOAD:
								sel =
									LstGetSelection(FrmGetObjectPtr
													(form,
													 FrmGetObjectIndex
													 (form,
													  LIST_SNA)));
								MemMove(savedhk, prefs.hardkeys, 9);
								loadsnap(sel, &prefs);
								Exit = Game(&prefs);
								if(!Exit)FrmDrawForm(form);
								break;
							case BUTT_NEW:
								Exit = Game(&prefs);
								if(!Exit)FrmDrawForm(form);
								break;
							case BUTT_SPEED:
								prefs.fast++;
								if(prefs.fast==3)prefs.fast=0;
								for(i=0;i<3;i++)if(i==prefs.fast) {
									FrmShowObject(form, o[i]);
								} else {
									FrmHideObject(form, o[i]);
								}
								break;
							case BUTT_SOUND:
								prefs.sound=!prefs.sound;
								if(prefs.sound) {
									FrmShowObject(form, o_bell);
								} else {
									FrmHideObject(form, o_bell);
								}
								break;
							case BUTT_REDEFINE:
								i = redefinehk(prefs.hardkeys);
								Exit = i<0;
								if(i==1)prefs.global=1;
								if(!Exit)FrmDrawForm(form);
								break;
							case BUTT_SAVEKEYS: {
								int j, sel;
								
								j=0;
								sel = LstGetSelection(FrmGetObjectPtr(form, 
											FrmGetObjectIndex(form, LIST_SNA)));
								while(dhk[j].name[0])j++;
								MemMove(dhk[j].name, list[sel], 16);
								MemMove(dhk[j].keys, prefs.hardkeys, 10);
								if(filesize("ArmPalmSpecKeyDef")<=0)
									FileCreate("ArmPalmSpecKeyDef", (j+1)*sizeof(struct hkeys_s));
								filewrite("ArmPalmSpecKeyDef", (UCHAR *)dhk, 0, 
										(j+1)*sizeof(struct hkeys_s), 1);
								MemPtrFree(dhk);
								
								i=filesize("ArmPalmSpecKeyDef");
								if(i>0) {
									int j;
									dhk=MemPtrNew(i+sizeof(struct hkeys_s));
									FileDump((UCHAR *)dhk, "ArmPalmSpecKeyDef", 0, i);
									j=i/sizeof(struct hkeys_s);
									dhk[j].name[0]='\0';
								} else {
									dhk=MemPtrNew(sizeof(struct hkeys_s));
									dhk[0].name[0]='\0';
								}
								};
								break;
						}
						FrmHandleEvent(form, &e);
						break;
					default:
						FrmHandleEvent(form, &e);
						break;
					}
				}
			}
		} while(e.eType != appStopEvent && !Exit);

		MemMove(prefs.hardkeys, savedhk, 9);
		PrefSetAppPreferences( 'PSPe', 0x0101, 3, &prefs, sizeof(prefs), 1);
	
		FreeListSNA();
		if(dhk)MemPtrFree(dhk);
		MemPtrFree(memram);
		MemPtrFree(memrom);
	}
	return (errNone);
}
