Err sndCB (void *userdata, SndStreamRef channel, void *buffer, UInt32 *bufferSizeP) {
	struct shared_t *armshared=userdata;
	UInt32 l;
	
	l=*bufferSizeP;
	if(l>SNDBUFLEN)l=SNDBUFLEN;
	*bufferSizeP=l;

	armshared->scounter++;
	
	MemMove(buffer, (unsigned char *)armshared+103+armshared->sndread*SNDBUFLEN, l);
	if(++armshared->sndread == NUMSNDBUFS)armshared->sndread=0;
	return 0;
}

UCHAR Game(struct prefs_t *prefs)
{
	EventType e;
	UInt16 Exit = FALSE;
	UInt16 n;
	UInt8 lastkey[256];
	int lastshift=0;
	UInt8 k;
	UInt32 oldkeymask, curstate, laststate;
	WinHandle winH;
	BitmapType *bmpP;
	UInt32 starttime;
	UInt32 q=0;
	int sndstarted;
	int keystotal;
	int lastpen;
	UInt32 i;
	struct prefs_t localp;
	int fast;
	UInt32 olddepth;
	UInt16 oldcoord;

	MemHandle armz80H = DmGetResource('armc', armz80_id);
	void *armz80 = MemHandleLock(armz80H);
	MemHandle armrefreshH = DmGetResource('armc', armrefresh_id);
	void *armrefresh = MemHandleLock(armrefreshH);

	localp=*prefs;
	fast=localp.fast;
	
	oldcoord=WinGetCoordinateSystem();
	WinSetCoordinateSystem(kCoordinatesDouble);
	WinScreenMode(winScreenModeGet, NULL, NULL, &olddepth, NULL);
	WinScreenMode(winScreenModeSet, NULL, NULL, &depth, NULL);
	
	lastpen=0;
	
	if(localp.sound) {
		MemSet(armshared.sound, NUMSNDBUFS*SNDBUFLEN, 0);
		armshared.sndread=0;
		armshared.sndwrite=0;
					
		SndStreamCreateExtended(&sndref, sndOutput, sndFormatPCM, 22050, sndUInt8, 
				sndMono, sndCB, &armshared, SNDBUFLEN, FALSE);
		SndStreamSetVolume(sndref, 256);
		sndstarted=0;
		armshared.scounter = 0;
		armshared.sndsample = 0;
		fast=0;
	}
	
	for(n = 0; n < 16; n++) {
		struct rgb *c;
		
		c = getrgb(n);
		spalette[n].index = n;
		spalette[n].r = c->r;
		spalette[n].g = c->g;
		spalette[n].b = c->b;
	}
	WinPalette(winPaletteSet, 0, 16, spalette);

	winH = WinGetDisplayWindow();
	bmpP = WinGetBitmap(winH);
	sc = BmpGetBits(bmpP);

	for(i = 0; i < 216L * 320 ; i++)
		sc[i] = 0;
			
	drawkeyboard(localp.kdisp);
		
	armshared.sc = (UInt32) sc;
	armshared.ram = (UInt32) memram;
	armshared.rom = (UInt32) memrom;
	
	oldkeymask =
		KeySetMask(keyBitsAll &
				   ~(keyBitNavLeft | keyBitNavRight | keyBitNavSelect |
					 keyBitPageUp | keyBitPageDown | keyBitHard1 |
					 keyBitHard2 | keyBitHard3 | keyBitHard4));
	
	for(n = 0; n < 256; n++) {
		lastkey[n] = 0;
	}
	keystotal=0;

	starttime=TimGetTicks();
	armshared.counter = 0;
	laststate=0;
	
	while(!Exit) {
		int td, step;
		
		if(DEBUG) {
			if(curstate&keyBitHard1 && !(laststate&keyBitHard1))
				step=1;
		} else {
			UInt32 bits[9]={ keyBitHard1, keyBitHard2, keyBitHard3, keyBitHard4, 
			 keyBitNavRight, keyBitNavLeft, keyBitPageDown, keyBitPageUp, keyBitNavSelect };
			int i;

			curstate = KeyCurrentState();
			armshared.k[8]=31;
			for(i=0;i<9;i++) if(localp.hardkeys[i] && (curstate&bits[i])) {
				setkey((int)localp.hardkeys[i]);
				lastkey[(int)localp.hardkeys[i]]=2;
				keystotal=1;
			}
			armshared.k[8]^=31;
		}
		
		laststate=curstate;
		
		td=TimGetTicks()-starttime-armshared.counter*fast;
		
		if( (armshared.counter-armshared.scounter<(NUMSNDBUFS/2)) || 
				( (td>0) && (!DEBUG || step) )) {
			
			MemSemaphoreReserve(true);
			
			if(keystotal){
				keystotal=0;
				for(n = 0; n < 256; n++) {
					if(lastkey[n]) {
						lastkey[n]--;
						if(!lastkey[n]) {
							resetkey(n);
						} else keystotal=1;
					}
				}
			}

			armshared.tstates = 0;
			armshared.event_next_event = 70000;
			PceNativeCall(armz80, &armshared);
			if(armshared.counter-armshared.scounter>0)
					PceNativeCall(armrefresh, &armshared);
			armshared.counter++;
			if(++armshared.sndwrite == NUMSNDBUFS)armshared.sndwrite=0;
			armshared.lastborder=armshared.out254;
	
			if(localp.sound && armshared.counter==(NUMSNDBUFS/2)) {
				SndStreamStart(sndref);
				sndstarted=1;
			}
			
			MemSemaphoreRelease(true);
			step=0;
		}

		if((armshared.counter-armshared.scounter<(NUMSNDBUFS/2)) || (td>0))k=0;else k=1;
	
		if(localp.sound && (armshared.counter-armshared.scounter>=NUMSNDBUFS-1))k=2;
		
		EvtGetEvent(&e, k);
		
		if(!SysHandleEvent(&e)) {
			switch (e.eType) {
				
				case penDownEvent:
					if((e.screenX<10 || e.screenX>150) && 
							e.screenY>=108 && e.screenY<160) {
						PointType p;
						p.x=e.screenX*2;
						p.y=e.screenY*2;

						if(RctPtInRectangle(p.x, p.y, &Reset)) {
							armshared.iff1=0;
							armshared.iff2=0;
							armshared.im=1;
							armshared.pc=0;
						}
						
						if(RctPtInRectangle(p.x, p.y, &Hide)) {
							localp.kdisp++;
							if(localp.kdisp==2)localp.kdisp=0;
							drawkeyboard(localp.kdisp);
						}

						if(RctPtInRectangle(p.x, p.y, &Leave)) {
							Exit=TRUE;
						}
						
					}
					if (e.screenX>=10 && e.screenX<=150 &&
							e.screenY>=108 && e.screenY<160) {
						int x, y, c;
						
						x=(e.screenX*2)-20;
						y=(e.screenY*2)-216;

						c=xytochar(x, y);
						if(c>=0) {
							lastkey[c] = 255;
							setkey(c);
							lastpen=c;
							keystotal=1;
						}
					}
					break;
				case penUpEvent:
					if(lastpen) {
						if(localp.keymode && (lastpen==22 || lastpen==24)) {
							lastshift=lastpen;
						} else {
							lastkey[lastpen]=1;
							if(lastshift) {
								lastkey[lastshift]=1;
								lastshift=0;
							}
						}
						lastpen=0;
					}
					break;
				case keyDownEvent:
												
					lastkey[e.data.keyDown.chr] = 5;
					setkey(e.data.keyDown.chr);
					keystotal=1;
					if(DEBUG) {
						sc[(UInt32)195*320+q*4]=3;
						sc[(UInt32)195*320+q*4+1]=3;
						q++;
					}	
					break;
				case appStopEvent:
					Exit = TRUE;
					break;
				default:
					break;
			}
		}
	}

	if(localp.sound) {
		SndStreamStop(sndref);
		SndStreamDelete(sndref);
	}
	
	KeySetMask(oldkeymask);
	MemSemaphoreReserve(true);
	savesna(TMP_FILE, prefs);
	MemSemaphoreRelease(true);
	MemHandleUnlock(armrefreshH);
	MemHandleUnlock(armz80H);
	
	WinScreenMode(winScreenModeSet, NULL, NULL, &olddepth, NULL);
	WinSetCoordinateSystem(oldcoord);
	
	return (e.eType == appStopEvent);
}

int redefinehk(UCHAR *keys) {
	int ret;
	EventType e;
	int cont=1, k;
	WinHandle winH;
	BitmapType *bmpP;
	int n;
	UInt32 i;
	UInt32 olddepth;
	UInt16 oldcoord;
	RectangleType rk[9] = {
		{ {15,100}, {25,25} },
		{ {55,100}, {25,25} },
		{ {240,100}, {25,25} },
		{ {280,100}, {25,25} },
		{ {195,100}, {25,25} },
		{ {105,100}, {25,25} },
		{ {150,134}, {25,25} },
		{ {150,66}, {25,25} },
		{ {145,100}, {35,25} },
	};
	RectangleType kemprec[6]= {
		{ {160,165}, {90, 30}},
		{ {299,170}, {20,20} },
		{ {255,170}, {20,20} },
		{ {277,192}, {20,20} },
		{ {277,148}, {20,20} },
		{ {277,170}, {20,20} },
	};
	
	UCHAR hk[10];

	ret=0;
	
	MemMove(hk, keys, 9);
	
	oldcoord=WinGetCoordinateSystem();
	WinSetCoordinateSystem(kCoordinatesDouble);
	WinScreenMode(winScreenModeGet, NULL, NULL, &olddepth, NULL);
	WinScreenMode(winScreenModeSet, NULL, NULL, &depth, NULL);

	for(n = 0; n < 16; n++) {
		struct rgb *c;
		
		c = getrgb(n);
		spalette[n].index = n;
		spalette[n].r = c->r;
		spalette[n].g = c->g;
		spalette[n].b = c->b;
	}
	WinPalette(winPaletteSet, 0, 16, spalette);

	winH = WinGetDisplayWindow();
	bmpP = WinGetBitmap(winH);
	sc = BmpGetBits(bmpP);

	for(i = 0; i < 216L * 320 ; i++)
		sc[i] = 0;

	drawkeyboard(1);

	WinSetForeColor(7);
	WinSetTextColor(7);
	WinSetBackColor(0);

	WinDrawLine(0,40,319,40);
	WinDrawLine(160,0,160,40);
	WinDrawChars("CANCEL", 6, 50, 10);
	WinDrawChars("ACCEPT", 6, 210, 10);

	k=0;
	
	while(cont) {
		int x, y;

		for(i=0;i<9;i++) {
			if(i==k)WinSetForeColor(2); else WinSetForeColor(7);
			WinDrawRectangleFrame(roundFrame, &rk[i]);
			WinDrawChar(charmap(hk[i]), rk[i].topLeft.x+4, rk[i].topLeft.y+2); 
		}
		WinSetForeColor(7);
		for(i=0;i<6;i++) WinDrawRectangleFrame(roundFrame, &kemprec[i]);
		WinDrawChars("kempston", 8, kemprec[0].topLeft.x+2, kemprec[0].topLeft.y+2); 
		
		EvtGetEvent(&e, evtWaitForever);
		switch(e.eType) {
			case penDownEvent:
				/* TOP - cancel/accept */
				if(e.screenY<20) {
					cont=0;
					if(e.screenX>80) {
						MemMove(keys, hk, 9);
						ret=1;
					}
				}

				x=e.screenX*2;		
				y=e.screenY*2;

				/* select hard key to program */
				for(i=0;i<9;i++) if(RctPtInRectangle(x, y, &rk[i])) k=i;

				/* kempston */
				if(RctPtInRectangle(x, y, &kemprec[0])) {
					hk[4]='\001';
					hk[5]='\002';
					hk[6]='\003';
					hk[7]='\004';
					hk[8]='\005';
				}
				for(i=1;i<6;i++) if(RctPtInRectangle(x, y, &kemprec[i])){
					hk[k]=i;
				}

				/* on screen keyboard */
				if (x>=20 && x<=300 &&
						y>=216 && y<320) {
					int c;
					c=xytochar(x-20, y-216);
					if(c>=0) {
						hk[k]=c;
					}
				}
				break;
			case appStopEvent:
				ret=-1;
				cont=0;
				break;
			default:
		}
	}
	
	WinScreenMode(winScreenModeSet, NULL, NULL, &olddepth, NULL);
	WinSetCoordinateSystem(oldcoord);

	return ret;
}
