#include <PceNativeCall.h>
#include <Standalone.h>

#include "endian.h"
#include "armlet-ids.h"

STANDALONE_CODE_RESOURCE_ID (armrefresh_id);

unsigned long start (const void *emulStateP, char *userData68KP,
		                     Call68KFuncType *call68KFuncP) {

	int ad, bm, at,xy;
	int i, j, k, fl;
	unsigned int counter;
	unsigned char *sc, *memram;
	unsigned char border, lastborder;

	sc= (unsigned char *)ReadUnaligned32 (userData68KP);
	memram= (unsigned char *)ReadUnaligned32 (userData68KP+4);
	counter = ReadUnaligned32 (userData68KP+80);
	border = userData68KP[96]&7;
	lastborder = userData68KP[97]&7;
	
	ad=0;
	bm=0;
	at=6144;
	xy=12*320+32;

	if(counter%50>24)fl=1; else fl=0;
	
	for(i=0;i<3;i++) {
		for(j=0;j<256;j++) {
			int f, b;
			f=memram[at]&7;
			b=(memram[at]&0x78)>>3;
			if(b&8)f+=8;
			if(memram[at]&0x80 && fl) {
				int x;
				x=f;
				f=b;
				b=x;
			}
			at++;
			for(k=0;k<2048;k+=256) {
				if(memram[ad+k]&0x80)sc[xy++]=f; else sc[xy++]=b;
				if(memram[ad+k]&0x40)sc[xy++]=f; else sc[xy++]=b;
				if(memram[ad+k]&0x20)sc[xy++]=f; else sc[xy++]=b;
				if(memram[ad+k]&0x10)sc[xy++]=f; else sc[xy++]=b;
				if(memram[ad+k]&0x08)sc[xy++]=f; else sc[xy++]=b;
				if(memram[ad+k]&0x04)sc[xy++]=f; else sc[xy++]=b;
				if(memram[ad+k]&0x02)sc[xy++]=f; else sc[xy++]=b;
				if(memram[ad+k]&0x01)sc[xy++]=f; else sc[xy++]=b;
				xy+=312;
			}
			if((j&31) == 31)xy-=248 ; else xy-=2560-8;
			ad++;
		}
		ad+=2048-256;
	}
	
	if(border != lastborder) {
		xy=12*320-32;
		for(i=0;i<xy;i++)sc[i]=border;
		for(i=204*320-32;i<216*320;i++)sc[i]=border;
		for(i=12;i<204;i++) {
			int j;
			for(j=0;j<64;j++)sc[xy++]=border;
			xy+=256;
		}
		userData68KP[99]++;
	}
	return 0;
}

