#include "quicktime.h"

int usage()
{
	printf("usage: yuv4toyuv <input movie> <output.yuv>\n");
	printf("	Write a YUV4 encoded movie as a planar YUV 4:2:0 file.\n");
	exit(1);
}

int main(int argc, char *argv[])
{
	quicktime_t *file;
	FILE *output;
	long length, width, height, bytes;
	char *buffer_in, *buffer_out;
	int i, j, k, l, m;

	if(argc < 3)
	{
		usage();
	}

	if(!(file = quicktime_open(argv[1], 1, 0)))
	{
		printf("Open input failed\n");
		exit(1);
	}

	if(!(output = fopen(argv[2], "wb")))
	{
		perror("Open output failed");
		exit(1);
	}

	if(!quicktime_video_tracks(file))
	{
		printf("No video tracks.\n");
		exit(1);
	}

	length = quicktime_video_length(file, 0);
	width = quicktime_video_width(file, 0);
	height = quicktime_video_height(file, 0);
	bytes = width * height + width * height / 2;
	buffer_in = calloc(1, bytes);
	buffer_out = calloc(1, bytes);

	for(i = 0; i < length; i++)
	{

		quicktime_set_video_position(file, i, 0);
		quicktime_read_data(file, buffer_in, bytes);

		for(j = 0, k = 0, l = width * height, m = k + width * height / 4;
			j < width * height; 
			j += 4, k += 6, l++, m++)
		{
			buffer_out[j] = buffer_in[k + 2];
			buffer_out[j + 1] = buffer_in[k + 3];
			buffer_out[j + 2] = buffer_in[k + 4];
			buffer_out[j + 3] = buffer_in[k + 5];
			
			buffer_out[l] = buffer_in[k];
			buffer_out[m] = buffer_in[k + 1];
		}

		if(!fwrite(buffer_out, bytes, 1, output))
		{
			perror("write failed");
			fclose(output);
			exit(1);
		}
	}

	quicktime_close(file);
}
