#include <linux/config.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/pci.h>
#include <asm/io.h>

int trident_blank(int blank) {
	int i;
	switch(blank) {
		case 0:
			outb(0x25, 0x3ce);
			i=inb(0x3cf);
			outb(0x25, 0x3ce);
			outb(i|0x08, 0x3cf);
			
			outb(0x24, 0x3ce);
			i=inb(0x3cf);
			outb(0x24, 0x3ce);
			outb(i|0x08, 0x3cf);
			break;
		case 1:
		default:
			outb(0x25, 0x3ce);
			i=inb(0x3cf);
			outb(0x25, 0x3ce);
			outb(i|0x08, 0x3cf);
			
			outb(0x24, 0x3ce);
			i=inb(0x3cf);
			outb(0x24, 0x3ce);
			outb(i&0xf7, 0x3cf);
			break;
	}
	return 0;
}

extern int (*console_blank_hook)(int);

static int __init blank_init(void) {
	struct pci_dev * video_controller;

	video_controller = pci_find_class(PCI_CLASS_DISPLAY_VGA<<8, NULL);
	if(!video_controller || video_controller->vendor!=PCI_VENDOR_ID_TRIDENT) {
		printk(KERN_ERR "trident_blank: No trident VGA controller found.\n");
		return -ENODEV;
	}
	console_blank_hook=trident_blank;
	return 0;
}

static void __exit blank_exit(void) {
	console_blank_hook=NULL;
	return;
}

module_init(blank_init);
module_exit(blank_exit);

MODULE_AUTHOR("Matan Ziv-Av");
MODULE_LICENSE("GPL");

