static int compute_vclk(
        int Clock,
        int *out_n,
        int *out_dn,
        int *out_div,
        int *out_sbit,
        int *out_scale)
{
    float f,x,y,t, error, min_error;
    int n, dn, best_n=0, best_dn=0;

    f = (float) Clock;
    f /= 1000.0;
    if ((f > 250.0) || (f < 18.75))
        return 0;

    min_error = f;
    y = 1.0;
    x = f;
    while (x > 31.25) {
        y *= 2.0;
        x /= 2.0;
    }
    if (x >= 18.25) {
        x *= 8.0;
        y = 8.0 / y;
    } else if (x >= 15.625) {
        x *= 12.0;
        y = 12.0 / y;
    }

    t = y;
    if (t == (float) 1.5) {
        *out_div = 2;
        t *= 2.0;
    } else {
        *out_div = 1;
    }
    if (t > (float) 4.0) {
        *out_sbit = 1;
        t /= 2.0;
    } else {
        *out_sbit = 0;
    }

    *out_scale = (int) t;

    for (dn=2;dn<=32;dn++) {
        for (n=1;n<=128;n++) {
            error = x;
            error -= ((float) 14.318 * (float) n / (float) dn);
            if (error < (float) 0)
                    error = -error;
            if (error < min_error) {
                min_error = error;
                best_n = n;
                best_dn = dn;
            }
        }
    }
    *out_n = best_n;
    *out_dn = best_dn;
    return 1;
}

int sis_setclock(int clock) {
    int  n, m, d, sb, sc, i;
    
    compute_vclk(clock, &n, &m, &d, &sb, &sc);
    outb(0x2b, 0x3c4);
    outb( ((n-1) & 0x7f) | ((d-1)<<7), 0x3c5);
    outb(0x2c, 0x3c4);
    outb( ((m-1) & 0x1f) | (((sc-1)&3)<<5) | (sb ? 0x80:0), 0x3c5);
    outb(0x2d, 0x3c4);
    outb(0x80, 0x3c5);
    i=inb(0x3cc);
    outb(i|0x0c, 0x3c2);
    return 0;    
}

