#define TVP3026_INDEX	0x00
#define TVP3026_DATA	0x0a
#define RAMDAC_OFFSET	0x3c00

#define MID_XPIXCLKCTRL 0x1a
#define MID_XPIXPLLCM	0x4c
#define MID_XPIXPLLCN	0x4d
#define MID_XPIXPLLCP	0x4e
#define MID_XPIXPLLSTAT	0x4f


void MGAoutTi3026(reg, val)
unsigned char reg, val;
{
    OUTREG8(RAMDAC_OFFSET + TVP3026_INDEX, reg);
    OUTREG8(RAMDAC_OFFSET + TVP3026_DATA, val);
}

static unsigned char MGAinTi3026(reg)
unsigned char reg;
{
    int val;
    OUTREG8(RAMDAC_OFFSET + TVP3026_INDEX, reg);
    val = INREG8(RAMDAC_OFFSET + TVP3026_DATA);
    return val;
}

enum { ID_1064 = 0, ID_G100, ID_G200, ID_G400, ID_G450 };

#define MGA_MIN_VCO_FREQ    120000
#define MGA_MAX_VCO_FREQ    250000
#define MGA_MAX_PCLK_FREQ   250000
#define MGA_MAX_MCLK_FREQ   100000
#define MGA_REF_FREQ        27050.0
#define MGA_ALT_REF_FREQ    14318.0
#define MGA_FEED_DIV_MIN    8
#define MGA_FEED_DIV_MAX    127
#define MGA_IN_DIV_MIN      1
#define MGA_IN_DIV_MAX      30
#define MGA_ALT_IN_DIV_MAX      6
#define MGA_POST_DIV_MIN    0
#define MGA_POST_DIV_MAX    3

static ulong
MGACalcClock ( int f_out, int *m, int *n, int *p, int *s, int id)
{
    	ulong f_max=f_out+2000;
	int best_m=0, best_n=0;
	double f_pll, f_vco;
	double m_err, calc_f, base_freq;
        int mga_in_div_max;
	static double ref = 0.0;

	switch(id) {
            case ID_G400:
            case ID_G450:
                ref = MGA_REF_FREQ;
                mga_in_div_max = MGA_IN_DIV_MAX;
                mga_in_div_max = MGA_ALT_IN_DIV_MAX; /* 31 should be allowed,
                   					but does not work. */
                break;
            case ID_G200:
                ref = MGA_ALT_REF_FREQ;
                mga_in_div_max = MGA_ALT_IN_DIV_MAX;
                break;
            default:
                ref = MGA_ALT_REF_FREQ;
                mga_in_div_max = MGA_ALT_IN_DIV_MAX;
                break;
        }

	/* Make sure that f_min <= f_out <= f_max */
	if ( f_out < ( MGA_MIN_VCO_FREQ / 8))
		f_out = MGA_MIN_VCO_FREQ / 8;

	if ( f_out > f_max )
		f_out = f_max;

	/*
	 * f_pll = f_vco /  (2^p)
	 * Choose p so that MGA_MIN_VCO_FREQ   <= f_vco <= MGA_MAX_VCO_FREQ  
	 * we don't have to bother checking for this maximum limit.
	 */
	f_vco = ( double ) f_out;
	for ( *p = 0; *p < MGA_POST_DIV_MAX && f_vco < MGA_MIN_VCO_FREQ;
								( *p )++ )
		f_vco *= 2.0;

	/* Initial value of calc_f for the loop */
	calc_f = 0;

	base_freq = ref / ( 1 << *p );

	/* Initial amount of error for frequency maximum */
	m_err = f_out;

	/* Search for the different values of ( *m ) */
	for ( *m = MGA_IN_DIV_MIN ;
		*m < mga_in_div_max ; ( *m )++ )
	{
		/* see values of ( *n ) which we can't use */
		for ( *n = MGA_FEED_DIV_MIN;
			*n <= MGA_FEED_DIV_MAX; ( *n )++ )
		{ 
			calc_f = (base_freq * (*n)) / *m ;

		/*
		 * Pick the closest frequency.
		 */
			if (abs( calc_f - f_out ) < m_err ) {
				m_err = abs(calc_f - f_out);
				best_m = *m;
				best_n = *n;
			}
		}
	}
	
	/* Now all the calculations can be completed */
	f_vco = ref * best_n / best_m;

	/* Adjustments for filtering pll feed back */
        switch(id) {
	    case ID_G450:
		*s=0;
		break;
            case ID_G400: 
	        if ( (50000.0 <= f_vco)
	        && (f_vco < 110000.0) )
		        *s = 0;	
	        if ( (110000.0 <= f_vco)
	        && (f_vco < 170000.0) )
		        *s = 1;	
	        if ( (170000.0 <= f_vco)
	        && (f_vco < 240000.0) )
		        *s = 2;	
	        if ( (240000.0 <= f_vco)
	        && (f_vco < 310000.0) )
		        *s = 3;	
                break;
            case ID_G200:
	        if ( (50000.0 <= f_vco)
	        && (f_vco < 100000.0) )
		        *s = 0;	
	        if ( (100000.0 <= f_vco)
	        && (f_vco < 140000.0) )
		        *s = 1;	
	        if ( (140000.0 <= f_vco)
	        && (f_vco < 180000.0) )
		        *s = 2;	
	        if ( (180000.0 <= f_vco)
	        && (f_vco < 250000.0) )
		        *s = 3;	
                break;
        }

	f_pll = f_vco / ( 1 << *p );

	*m = best_m - 1;
	*n = best_n - 1;
	*p = ( 1 << *p ) - 1 ; 

        if((id==ID_G450) && (*p == 3)) *p=2;

	return f_pll;
}


int mga_setclock(int clock) {
    int m, n, p, s;
    uint8_t tmpByte;
    int i;
    int id;

    outb(1, 0x3C4);
    outb(inb(0x3C5) | 0x20, 0x3c5);

    i=inb(0x3cc);
    i&=0xf3;
    outb(i, 0x3c2);
    usleep(20000);

    id=ID_G450;    
    i = MGACalcClock(clock, &m, &n, &p, &s, id);

    MGAoutTi3026(MID_XPIXCLKCTRL, MGAinTi3026(MID_XPIXCLKCTRL) | 0x04);
    
    MGAoutTi3026(MID_XPIXPLLCM, m & 0x1f);
    MGAoutTi3026(MID_XPIXPLLCN, n & 0x7f);
    MGAoutTi3026(MID_XPIXPLLCP, ((s << 3) & 0x18) | (p & 0x07));

    i=inb(0x3cc);
    i&=0xf3;
    outb(i|0x08, 0x3c2);

    while ((MGAinTi3026(MID_XPIXPLLSTAT) & 0x40) != 0x40);
    MGAoutTi3026(MID_XPIXCLKCTRL, MGAinTi3026(MID_XPIXCLKCTRL) & 0xfb);
    
    outb(1, 0x3C4);
    outb(inb(0x3C5) & ~0x20, 0x3c5);
    
    return 0;
}
