#define TRUE 1
#define FALSE 0
typedef int bool;
#include <linux/vt.h>   /* for VT_RESIZE */
#  include <linux/tty.h>	/* for MAX_NR_CONSOLES */
#  include <sys/ioctl.h>
#  include <sys/kd.h>
#  include <ctype.h>
#include <sys/io.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <stdint.h>

unsigned char *MMIO_POINTER;
unsigned int IO_BASE;

#include "stm_sis.c"
#include "stm_r128.c"
#include "stm_banshee.c"
#include "stm_mga.c"
#include "stm_nv3.c"

int opentty(int tty)
{
  char devname[32];
  int fd;

  sprintf(devname, "/dev/vc/%d", tty);
  if((fd=open(devname, O_WRONLY|O_NOCTTY)) < 0) {
    sprintf(devname, "/dev/tty%d", tty);
    if((fd=open(devname, O_WRONLY|O_NOCTTY)) < 0) {
      return -1;
    }
  }
  return fd;
}

bool try_resize(int fd, void* p_struct_size, int memsize, int cmd)
{
  int cnt;

  if (!ioctl(fd, cmd, p_struct_size)) return(TRUE);
  return(FALSE);
}

bool generic_VT_RESIZE(void* p_struct_size, void* dummy, int allow1x1, int memsize, int cmd, char* descr)
{
  int fd;

  fd = opentty(0);

  if (try_resize(fd, p_struct_size, memsize, cmd)) return(FALSE);

  return(TRUE);

}

int do_VT_RESIZE(int cols, int rows, int allow1x1)
{
  struct vt_sizes my_vt_size, dummy_vt_size;      /* passes the new screen size on to the kernel */

  /* We need two bytes for each character (character + attribute), per console. */
  int ram_needed = cols * rows * 2 * MAX_NR_CONSOLES;

  my_vt_size.v_rows = rows;
  my_vt_size.v_cols = cols;
  my_vt_size.v_scrollsize = 0; /* kernel tries to get as many scroll-back lines as possible by itself (?) */
  
  dummy_vt_size.v_rows = 1;
  dummy_vt_size.v_cols = 1;
  dummy_vt_size.v_scrollsize = 0;

  return(generic_VT_RESIZE(&my_vt_size, &dummy_vt_size, allow1x1, ram_needed, VT_RESIZE, "VT_RESIZE"));
}

int do_VT_RESIZEX(int cols, int rows, int vlin, int clin, int vcol, int ccol, int allow1x1)
{
  struct vt_consize my_vt_size;      /* passes the new screen size on to the kernel */
  struct vt_consize dummy_vt_size = { 1 , 1 , 1 , 1 , 1 , 1 };
  int ram_needed = cols * rows * 2 * MAX_NR_CONSOLES;

  my_vt_size.v_rows = rows;
  my_vt_size.v_cols = cols;
  my_vt_size.v_vlin = vlin;
  my_vt_size.v_clin = clin;
  my_vt_size.v_vcol = vcol;
  my_vt_size.v_ccol = ccol;

  return(generic_VT_RESIZE(&my_vt_size, &dummy_vt_size, allow1x1, ram_needed, VT_RESIZEX, "VT_RESIZEX"));
}

int main(int argc, char *argv[])
{
int i, fd;
int ht, hd, hss, hse, vt, vd, vss, vse, clock;
int col, row, font;
unsigned int mmio_base, mmio_size;
int div3;

mmio_base=0xec000000;
mmio_size=16*1024;
fd=open("/dev/mem", O_RDWR);
IO_BASE=0xd800;

MMIO_POINTER = mmap(0, mmio_size, PROT_READ|PROT_WRITE, MAP_SHARED, fd, mmio_base);

iopl(3);
ioperm(0x3c0,0x20,1);

if(argc>1) {
    col=80;
    row=25;
    font=16;
} else {
#if 0
    col=100;
    row= 48;
    font=16;
    
    ht=1024;
    hd=800;
    hss=832;
    hse=936;
    vt=807;
    vd=768;
    vss=771;
    vse=777;
    clock=62000;
#else
    col=160;
    row=60;
    font=16;
    ht=1680;
    hd=1280;
    hss=1348;
    hse=1432;
    vt=1023;
    vd=960;
    vss=986;
    vse=989;
    clock=120000;
    
#endif
    outb(0x11, 0x3d4);
    i=inb(0x3d5);
    outb(0x11, 0x3d4);
    outb(i&0x7f, 0x3d5);
    
    outb(0, 0x3d4);
    outb( (ht / 8 ) - 5, 0x3d5);
    
    outb(1, 0x3d4);
    outb( (hd / 8) - 1, 0x3d5);
    
    outb(2, 0x3d4);
    outb( (hss / 8) - 1, 0x3d5);
    
    outb(3, 0x3d4);
    outb( ((hse / 8) & 0x1F) | 0x80, 0x3d5);
    
    outb(4, 0x3d4);
    outb( (hss / 8), 0x3d5);
    
    outb(5, 0x3d4);
    outb( (((hse / 8) & 0x20) << 2)
	    | ((hse / 8) & 0x1F), 0x3d5);
    
    outb(6, 0x3d4);
    outb( (vt - 2) & 0xFF, 0x3d5);
    
    outb(7, 0x3d4);
    outb( (((vt - 2) & 0x100) >> 8)
	    | (((vd - 1) & 0x100) >> 7)
	    | ((vss & 0x100) >> 6)
	    | ((vss & 0x100) >> 5)
	    | 0x10
	    | (((vt - 2) & 0x200) >> 4)
	    | (((vd - 1) & 0x200) >> 3)
	    | ((vss & 0x200) >> 2), 0x3d5);
    
    outb(9, 0x3d4);
    outb( ((vss & 0x200) >> 4) | 0x40 | (font-1), 0x3d5);
    
    outb(0x10, 0x3d4);
    outb( vss & 0xFF, 0x3d5);
    
    outb(0x11, 0x3d4);
    i=inb(0x3d4);
    outb(0x11, 0x3d4);
    outb( (vse & 0x0F) | (i&0xf0) , 0x3d5);
    
    outb(0x12, 0x3d4);
    outb( (vd - 1) & 0xFF, 0x3d5);
    
    outb(0x13, 0x3d4);
    outb( col/2, 0x3d5);	/* Just a guess. */
    
    outb(0x15, 0x3d4);
    outb( vss & 0xFF, 0x3d5);
    
    outb(0x16, 0x3d4);
    outb( (vse+1) & 0xFF, 0x3d5);

    r128_setclock(clock);
    
}

do_VT_RESIZE(col, row, 0);
do_VT_RESIZEX(col, row, vd, font, hd, 8, 0);

return 0;
}


