#include <unistd.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

static int ClockSelect(int clockIn,int *clockOut,int *mOut,
                                        int *nOut,int *pOut);
static int base_freq;

static int pci_read_config(unsigned char bus, unsigned char device,
        unsigned char fn, unsigned long *buf, int size)
{
   int f,i;
   char filename[256];

   sprintf(filename,"/proc/bus/pci/%02i/%02x.%i",bus,device,fn);
   f=open(filename,O_RDONLY);
   if(read(f,buf,4*size)<1)for(i=0;i<63;i++)buf[i]=-1;
   close(f);
   return 0;
}; 

int pci_find_vendor_vga(unsigned int vendor, unsigned long *conf)
{ unsigned long buf[64];
  int bus,device=0;

  for(bus=0;bus<16;bus++)
    for(device=0;device<32;device++){
      pci_read_config(bus,device,0,buf,3);
      if(((buf[0]&0xffff)==vendor)&&
        (((buf[2]>>16)&0xffff)==0x0300)) { /* VGA Class */
                pci_read_config(bus,device,0,buf,64);
                memcpy(conf,buf,256);
                return 0;
       };
    }  

  return -1;
}

int main()
{
	int i;
	int f;
	void *c, *d, *e;
	unsigned char *p, *q;
	unsigned long *l;
	unsigned long base;
	unsigned long buf[64];
	int mm,nn,pp;
	int newNVPLL, newMPLL, newNVclock, newMEMclock;

	if(pci_find_vendor_vga(0x1002,buf))exit(1);

	base=buf[6]&0xffffff00;

printf("%08x\n",base);

	f=open("/dev/mem",O_RDWR);

/* c is fro the clocks, d for PEXTDEV, and e for the crtc */
	c=mmap(0,65536,PROT_READ|PROT_WRITE,MAP_SHARED,f,base);
	p=(unsigned char *)c;
	l=(unsigned long *)c;
        
        printf(" %08x\n\n", *(l+(0x2f4>>2)));
	*(l+(0x2f4>>2)) = 0x00000c3c;
        printf(" %08x\n\n", *(l+(0x2f4>>2)));

};

