#define MAXDEVICES 	16
#define DEVNAME		"BCM"

/* all data transfered over PCI will be LE */

struct bcm_transfer {
	struct dev_info *dev;
        u8 *    	buffer;
        size_t  	len;
        u32     	proto;
	u32 		flags;
	struct bcm_transfer *next;
};

struct dev_info {
	struct bcm_dev	*bcm;
	char identity[64];
};

struct bcm_driver {
        int (*init)(struct dev_info *dev);
        void (*remove)(struct dev_info *dev);
};

typedef  struct {
	u64		phys;
	u32 	bufsize;
	u32		len;
	u32		flags;
	u32		proto;
	u64 	buffer;
}	ring_element;


struct common_data {
	unsigned char	signature[8];	/* BCM. written by card */
	u64		sequence;
	char	identity[64];
	u64		tx_phys;	/* data descriptor rings */
	u64		rx_phys;	/* filled by host */
	u32		serial; 
	u32		tx_size;
	u32		rx_size;
	u32		tx_tail;
	u32		tx_head;
	u32		rx_tail;
	u32		rx_head;
	u32		msg;		/* Can be used by card to pass messages */
	u32		arg;
}; /* Used for various communications */


/* host private per device data */
struct bcm_dev {
	struct pci_dev * dev;
	struct dev_info *info;
	struct common_data *common;
	u16 * mbox0;

	ring_element * tx_ring;
	ring_element * rx_ring;

	int tx_size;
	int rx_size;
	struct tq_struct tq_rx;
	struct tq_struct tq_tx;

	int rx_host_tail;
	int tx_host_tail;

	struct protocol *prot;
	struct bcm_transfer * tx_finished;
	struct bcm_transfer * tx_finished_last;
	struct bcm_transfer * rx_finished;
	struct bcm_transfer * rx_finished_last;
	struct bcm_transfer * tx_card;
	struct bcm_transfer * rx_card;
	int rx_dma_running;
	int tx_dma_running;
	struct bcm_transfer * tx_in_progress;
	struct bcm_transfer rx_in_progress;
};

struct bcm_payload {
        u32 proto;
        void (*tx_notify)(struct dev_info *, struct bcm_transfer *);
        void (*rx_action)(struct dev_info *, struct bcm_transfer *);
};

struct protocol {
	u32 	proto;
	struct bcm_payload * payload;
	struct protocol *next;
};

#define INT_INIT	0x00010000
#define INT_ACK		0x00040000
#define INT_TX		0x00020000
#define INT_RX		0x00080000

#define INT_UNK		0xfff00000

#define FLAGS_OWNER_HOST	0x00000001
#define FLAGS_OWNER_CARD	0x00000002
#define FLAGS_OWNER_MASK	0x0000000f
#define FLAGS_NOTIFY		0x00000010


extern int bcm_register_driver(struct bcm_driver *dr);
extern int bcm_register_payload(struct dev_info *bdev, struct bcm_payload *pl);
extern int bcm_unregister_payload(struct dev_info *bdev, struct bcm_payload *pl);
extern int bcm_transfer_data(struct bcm_transfer *tr);
