/* fuse.c: The Free Unix Spectrum Emulator
   Copyright (c) 1999-2000 Philip Kendall

   $Id: fuse.c,v 1.3 2000/12/08 15:13:49 pak Exp $

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   Author contact information:

   E-mail: pak@ast.cam.ac.uk
   Postal address: 15 Crescent Road, Wokingham, Berks, RG40 2DB, England

*/

#include <config.h>

#include <stdio.h>

#include "display.h"
#include "event.h"
#include "keyboard.h"
#include "snapshot.h"
#include "spectrum.h"
#include "tape.h"
#include "timer.h"
#include "x.h"
#include "z80.h"

/* A flag to say when we want to exit the emulator */
int fuse_exiting;

#ifdef MYSOUND
short *soundbuf;
short ay_levels[16];
int soundfd;
int framesize, soundspeed;
int ay_step;
#define AY_FREQ 1773400
#include <linux/soundcard.h>
#include <fcntl.h>
#include <pthread.h>

void *soundthread(void *data) {
    int i;
    while(1) {
        write(soundfd, soundbuf, framesize*2);
    }
}
#endif

static int fuse_init(int argc, char **argv);
static void fuse_show_copyright(void);
static int fuse_end(void);

int main(int argc,char **argv)
{
  if(fuse_init(argc,argv)) {
    fprintf(stderr,"Error initalising -- giving up!\n");
    return 1;
  }

  while( !fuse_exiting ) {
    z80_do_opcodes();
    event_do_events();
  }

  fuse_end();
  
  return 0;

}

static int fuse_init(int argc, char **argv)
{
#ifdef MYSOUND
  pthread_t th;
#endif
  int arg, j, k, i;

  fuse_show_copyright();

  if(display_init(argc,argv)) return 1;
  if(event_init()) return 1;
  timer_init();

  machine.machine=SPECTRUM_MACHINE_48; spectrum_init(); machine.reset();
  sp_keyboard_init();
  z80_init();

#ifdef MYSOUND
  soundfd=open("/dev/dsp",O_RDWR);
  arg=AFMT_S16_LE;
  j=ioctl(soundfd, SNDCTL_DSP_SETFMT, &arg);
  arg=0;
  j=ioctl(soundfd, SNDCTL_DSP_STEREO, &arg);
  soundspeed=44100;
  j=ioctl(soundfd, SNDCTL_DSP_SPEED, &soundspeed);
  arg=0x00080008;
  j=ioctl(soundfd, SNDCTL_DSP_SETFRAGMENT, &arg);

//  pthread_create(&th, NULL, soundthread, NULL);
  soundbuf=(short *)malloc(4096);
  framesize=soundspeed/50;
  ay_step=AY_FREQ*100/soundspeed;
  k=0x606000;
  for(i=15;i>0;i--) {
      ay_levels[i]=k>>12;
      k=((k/5786)<<12)+0x800;
  }
  ay_levels[0]=0;
#endif  
  return 0;

}

static void fuse_show_copyright(void)
{
  printf(
   "The Free Unix Spectrum Emulator (Fuse) version " VERSION ".\n"
   "Copyright (c) 1999-2000 Philip Kendall <pak@ast.cam.ac.uk> and others;\n"
   "\n"
   "This program is distributed in the hope that it will be useful,\n"
   "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
   "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
   "GNU General Public License for more details.\n\n");

}

/* Tidy-up function called at end of emulation */
static int fuse_end(void)
{
  timer_end();
#ifdef RSOUND
  sound_end();
#endif
  event_end();
  display_end();

  return 0;
}
