/* Copyright (C) 1993-1998 Russell Marks. See README for license details.
 *
 *  Changes by Matan Ziv-Av (zivav@cs.bgu.ac.il)
 *
 * font.c - provides code to use (nicer) BDF fonts converted with bdf2h.
 */

#include <stdio.h>
#include <string.h>
#include <vga.h>
#include "fontbmps.h"

#define TABSIZE  100   /* size of a tab, in pixels */

/* the copyright/license for the bitmap fonts says that all
 * copies of the fonts must contain the copyright. Since a copy
 * was embedded in the program above (`fontbmps.h'), we'd
 * best have this:
 */
static char *bitmap_fonts_copyright=
"The bitmap fonts zgv uses are: \
Copyright 1984-1989, 1994 Adobe Systems Incorporated. \
Copyright 1988, 1994 Digital Equipment Corporation.";


/* unused dummy routine to stop -Wall complaining about the copyright
 * message not being used.
 */
static void its_too_damn_picky_sometimes()
{
printf(bitmap_fonts_copyright);
}

/* returns width of text drawn in pixels */
int drawtext(int xpos,int ypos,int siz,char *str,int fgcol, int bgcol, int bpp)
{
static unsigned char scanbit[128];
unsigned char scanline[4096];
int f,c,x,y;
int initxpos=xpos;
signed char *ptr,*fontdat;
int ox,oy,w,h,dw;
int yst;
int xrunst=-1;
int *fonttbl;
int fontyofs,fontfh,fontoy;
int widthadd=0;

/* pick font to match siz.
 * It would be nicer if these were in a struct or something...! (XXX)
 * (That's really a problem with bdf2h.c rather than this, though.)
 */
switch(siz)
  {
  case 5:
    fontdat=font3dat; fonttbl=font3tbl;
    fontyofs=font3yofs; fontfh=font3fh; fontoy=font3oy;
    break;

  case 4:
    widthadd=1;
    /* falls through */
  
  case 3:
    fontdat=font2dat; fonttbl=font2tbl;
    fontyofs=font2yofs; fontfh=font2fh; fontoy=font2oy;
    break;
    
  /* this doesn't appear normally, but will if someone hacks
   * on zgv blindly. It gently gives them a clue. :-)
   */
  default:
    fprintf(stderr,"unsupported text size - treating siz as 2\n");
    /* falls through */
  
  case 2:
    fontdat=font1dat; fonttbl=font1tbl;
    fontyofs=font1yofs; fontfh=font1fh; fontoy=font1oy;
    break;
  }

for(f=0;f<strlen(str);f++)
  {
  c=str[f];
  if(c=='\t')
    {
    xpos=((xpos/TABSIZE)+1)*TABSIZE;
    continue;
    }
  if(c<32 || c>126) c='_';
  ptr=fontdat+fonttbl[c-32];
  ox=*ptr++; oy=*ptr++;
  w =*ptr++; h =*ptr++;
  dw=*ptr++;
  yst=fontfh-(oy-fontoy)-fontyofs-h;
  
  if(c!='\t')
    for(y=ypos+yst;y<ypos+yst+h;y++) {
      for(x=ox;x<ox+w;x++)
        if(*ptr++)
           memcpy(scanline+(x-ox)*bpp,&fgcol,bpp);
        else memcpy(scanline+(x-ox)*bpp,&bgcol,bpp);
      tv_drawscansegment(scanline,xpos,y,w*bpp);
    };
  
  xpos+=dw+widthadd;
  }

return(xpos-initxpos);
}
