/*******************************************************************
 *
 *  gwin_x11.c  graphics utility X-Window driver.              1.0
 *
 *  This is the driver for windowed display under X11, used by the
 *  graphics utility of the FreeType test suite.
 *
 *  Copyright 1996-1998 by
 *  David Turner, Robert Wilhelm, and Werner Lemberg.
 *
 *  This file is part of the FreeType project, and may only be used
 *  modified and distributed under the terms of the FreeType project
 *  license, LICENSE.TXT. By continuing to use, modify or distribute 
 *  this file you indicate that you have read the license and
 *  understand and accept it fully.
 *
 ******************************************************************/

#include "gdriver.h"
#include "gmain.h"
#include "gevents.h"

#include "freetype.h"
#include "common.h"     /* for Panic() */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <vga.h>

  /* Translator added to ease changes to control keys */

  typedef struct  _Translator
  {
    char    key;
    GEvent  event_class;
    int     event_info;
  } Translator;

#define NUM_Translators  20

  static const Translator  trans[NUM_Translators] =
  {
    { (char)27, event_Quit,              0 },
    { 'q',      event_Quit,              0 },

    { 'x',      event_Rotate_Glyph,     -1 },
    { 'c',      event_Rotate_Glyph,      1 },
    { 'v',      event_Rotate_Glyph,    -16 },
    { 'b',      event_Rotate_Glyph,     16 },

    { '{',      event_Change_Glyph, -10000 },
    { '}',      event_Change_Glyph,  10000 },
    { '(',      event_Change_Glyph,  -1000 },
    { ')',      event_Change_Glyph,   1000 },
    { '9',      event_Change_Glyph,   -100 },
    { '0',      event_Change_Glyph,    100 },
    { 'i',      event_Change_Glyph,    -10 },
    { 'o',      event_Change_Glyph,     10 },
    { 'k',      event_Change_Glyph,     -1 },
    { 'l',      event_Change_Glyph,      1 },

    { '+',      event_Scale_Glyph,      10 },
    { '-',      event_Scale_Glyph,     -10 },
    { 'u',      event_Scale_Glyph,       1 },
    { 'j',      event_Scale_Glyph,      -1 }
  };

  /* End of translators addition. See Get_Event() below */

  extern char      Header[];    /* defined in the test programs */

  static int gray;

  /* restore acreen to its original state */

  int  Driver_Restore_Mode( void )
  {
    vga_setmode(TEXT);
    return 1;       /* success */
  }

  int  Driver_Set_Graphics( int  mode )
  {

    int i;

    vga_init();
    vga_setmode(G1024x768x256);

    for(i=0;i<256;i++)vga_setpalette(i,i,i,i);
    for(i=0;i<5;i++)gray_palette[i]=i*63;

    Vio=(char *)vga_getgraphmem();
    vio_Height=768;
    vio_Width=1024;
    vio_ScanLineWidth=1024;
    
    gray=(mode == Graphics_Mode_Gray);
    
    return 1;       /* success */
  }

  int  Driver_Display_Bitmap( char*  buffer, int  line, int  col )
  {
    int    i,j,k;
    char*  tmp;

    vga_clear();

    tmp=buffer;

    if (gray) {
       for(i=line-1;i>=0;i--) {
          vga_drawscansegment((unsigned char *)tmp,0,i,col);
          tmp+=col;
       }
    } else {
        vga_setcolor(255);
        for(i=line;i>=0;i--) {
           for(j=0;j<col;j++) {
              int l=*tmp;
              for(k=0;k<8;k++) {
                 if(l&0x80)vga_drawpixel(j*8+k,i);
                 l<<=1;
              }
              tmp++;
           }
        }
    }
    return 1;
  }

  /* This function maps X keystrokes into GEvents.  Note that */
  /* currently only keystrokes events exit this function.     */

  void  Get_Event( TEvent*  event )
  {
    int ch, i;

    ch=vga_getch();

    for ( i = 0; i < NUM_Translators; i++ )
    {
      if ( ch == trans[i].key )
      {
        event->what = trans[i].event_class;
        event->info = trans[i].event_info;
        return;
      }
    }

    event->what = event_Keyboard;
    event->info = ch;
  }

