#define BSWAP

/* big endian memory */
unsigned char dummy[32];
unsigned char ram[32*1024*1024];

#define PHYSMEM 0x40000000
#define PROGSTART 0x10000
#define IO 0xc0000000

#ifdef BSWAP

#define _MEM(x) (*(unsigned int *)(ram+x))
#define _MEM8(x) (ram[(x&0xfffffffc)+3-(x&3)])
#define _MEM16(x) (*(unsigned short *)(ram+(x&0xfffffffc)+2-(x&2)))

#define _SMEM(x,d) *(unsigned int *)(ram+x)=d
#define _SMEM8(x,d) ram[(x&0xfffffffc)+3-(x&3)]=d
#define _SMEM16(x,d) *(unsigned short *)(ram+(x&0xfffffffc)+2-(x&2))=d

#else /* BSWAP */

#define _MEM(x) ((ram[x]<<24) | (ram[x+1]<<16) | (ram[x+2]<<8) | ram[x+3])
#define _MEM8(x) (ram[x])
#define _MEM16(x) ((ram[x]<<8) | ram[x+1])

#define _SMEM8(x,d) ram[x]=d
#define _SMEM16(x,d) ram[x]=(d)>>8; ram[x+1]=(d)&0xff 
#define _SMEM(x,d) ram[x]=(d)>>24; ram[x+1]=((d)>>16)&0xff; ram[x+2]=((d)>>8)&0xff; ram[x+3]=(d)&0xff 

#endif /* BSWAP */

#define SPMASK  0xffffe000
#define LPMASK  0xff000000
#define PPIMASK 0x000001c0
unsigned int lastimask=0, lastimr=1, lastitr=0;
unsigned int lastdwmask=0, lastdwmr=1, lastdwtr=0;
unsigned int lastdrmask=0, lastdrmr=1, lastdrtr=0;
int tn;

inline unsigned int IMMU(unsigned int x) {
    int tn=0;
    int ppi;
    while(tn<256) {
        if((ITLBMR[tn]&1) && ((x&LPMASK)==(ITLBMR[tn]&LPMASK))) {
            lastitr = ITLBTR[tn]&LPMASK;
            lastimr = ITLBMR[tn]&LPMASK;
            lastimask = LPMASK;
            ppi = (ITLBMR[tn]&PPIMASK)>>6;
//printf("ppi=%i\n",ppi);
            if(ppi) {
//printf("%i %i\n",IMMUCR2, SR&1);
                if(((IMMUCR2 << (1+(SR&1))) >> (2*ppi))&1) {
                    return (x&~LPMASK) | (ITLBTR[tn]&LPMASK); 
                } else {
                    forceex= EX_IFPE;
                    return 0;
                }
            } else {
                forceex= EX_IFPE;
                return 0;
            }
        } else if( (x&SPMASK)==(ITLBMR[tn]&SPMASK) ) {
            lastitr = ITLBTR[tn]&SPMASK;
            lastimr = ITLBMR[tn]&SPMASK;
            lastimask = SPMASK;
            ppi = (ITLBMR[tn]&PPIMASK)>>6;
//printf("ppi=%i\n",ppi);
            if(ppi) {
//printf("%i %i\n",IMMUCR2, SR&1);
                if(((IMMUCR2 << (1+(SR&1))) >> (2*ppi))&1) {
                    return (x&~SPMASK) | (ITLBTR[tn]&SPMASK);
                } else {
                    forceex= EX_IFPE;
                    return 0;
                }
            } else {
                forceex= EX_IFPE;
                return 0;
            }
        }
        tn++;
    }
    
    forceex=EX_ITLB;
    return 0;
}

inline unsigned int DMMUW(unsigned int x) {
    int tn=0;
    int ppi;
    while(tn<256) {
        if((DTLBMR[tn]&1) && ((x&LPMASK)==(DTLBMR[tn]&LPMASK))) {
            lastdwtr = DTLBTR[tn]&LPMASK;
            lastdwmr = DTLBMR[tn]&LPMASK;
            lastdwmask = LPMASK;
            ppi = (DTLBMR[tn]&PPIMASK)>>6;
//printf("ppi=%i\n",ppi);
            if(ppi) {
                if(((DMMUCR2 << (1+2*(SR&1))) >> (4*ppi))&1) {
                    return (x&~LPMASK) | (DTLBTR[tn]&LPMASK); 
                } else {
                    forceex= EX_DFPE;
                    return 0;
                }
            } else {
                forceex= EX_DFPE;
                return 0;
            }
            return (x&~LPMASK) | (DTLBTR[tn]&LPMASK); 
        } else if( (x&SPMASK)==(DTLBMR[tn]&SPMASK) ) {
            lastdwtr = DTLBTR[tn]&SPMASK;
            lastdwmr = DTLBMR[tn]&SPMASK;
            lastdwmask = SPMASK;
            ppi = (DTLBMR[tn]&PPIMASK)>>6;
//printf("ppi=%i\n",ppi);
            if(ppi) {
                if(((DMMUCR2 << (1+2*(SR&1))) >> (4*ppi))&1) {
                    return (x&~SPMASK) | (DTLBTR[tn]&SPMASK); 
                } else {
                    forceex= EX_DFPE;
                    return 0;
                }
            } else {
                forceex= EX_DFPE;
                return 0;
            }
        }
        tn++;
    }
    
    forceex=EX_DTLB;
    return 0;
}

inline unsigned int DMMUR(unsigned int x) {
    int tn=0;
    int ppi;
    while(tn<256) {
        if((DTLBMR[tn]&1) && ((x&LPMASK)==(DTLBMR[tn]&LPMASK))) {
            lastdrtr = DTLBTR[tn]&LPMASK;
            lastdrmr = DTLBMR[tn]&LPMASK;
            lastdrmask = LPMASK;
            ppi = (DTLBMR[tn]&PPIMASK)>>6;
//printf("ppi=%i\n",ppi);
            if(ppi) {
                if(((DMMUCR2 << (2+2*(SR&1))) >> (4*ppi))&1) {
                    return (x&~LPMASK) | (DTLBTR[tn]&LPMASK); 
                } else {
                    forceex= EX_DFPE;
                    return 0;
                }
            } else {
                forceex= EX_DFPE;
                return 0;
            }            return (x&~LPMASK) | (DTLBTR[tn]&LPMASK); 
        } else if( (x&SPMASK)==(DTLBMR[tn]&SPMASK) ) {
            lastdrtr = DTLBTR[tn]&SPMASK;
            lastdrmr = DTLBMR[tn]&SPMASK;
            lastdrmask = SPMASK;
            ppi = (DTLBMR[tn]&PPIMASK)>>6;
//printf("ppi=%i\n",ppi);
            if(ppi) {
                if(((DMMUCR2 << (2+2*(SR&1))) >> (4*ppi))&1) {
                    return (x&~SPMASK) | (DTLBTR[tn]&SPMASK); 
                } else {
                    forceex= EX_DFPE;
                    return 0;
                }
            } else {
                forceex= EX_DFPE;
                return 0;
            }
        }
        tn++;
    }
    
    forceex=EX_DTLB;
    return 0;
}

unsigned int IMEM(unsigned int x) {
    if(x&3) {
        forceex=EX_ALGN;
        return 0;
    }
    if(SR & SR_IME) {
        if((x&lastimask)==lastimr) x= (x&~lastimask) | lastitr; 
            else x=IMMU(x);
    } 
    if(x<PHYSMEM) return _MEM(x);
}

unsigned int MEM(unsigned int x) {
    if(x&3) {
        forceex=EX_ALGN;
        return 0;
    }
    if(SR & SR_DME) {
        if((x&lastdrmask)==lastdrmr) x= (x&~lastdrmask) | lastdrtr; 
            else x=DMMUR(x);
        if(forceex)return 0;
    }
    if(x<PHYSMEM) return _MEM(x);
}

unsigned int MEM8(unsigned int x) {
    if(SR & SR_DME) {
        if((x&lastdrmask)==lastdrmr) x= (x&~lastdrmask) | lastdrtr; 
            else x=DMMUR(x);
        if(forceex)return 0;
    }
    if(x<PHYSMEM) return _MEM8(x);
    if(x==IO) return 0; /* no input for a while */
}

unsigned int MEM16(unsigned int x) {
    if(x&1) {
        forceex=EX_ALGN;
        return 0;
    }
    if(SR & SR_DME) {
        if((x&lastdrmask)==lastdrmr) x= (x&~lastdrmask) | lastdrtr; 
            else x=DMMUR(x);
        if(forceex)return 0;
    }
    if(x<PHYSMEM) return _MEM16(x);
}

void SMEM(unsigned int x, unsigned int d) {
    if(x&3) {
        forceex=EX_ALGN;
        return;
    }
    if(SR & SR_DME) {
        if((x&lastdwmask)==lastdwmr) x= (x&~lastdwmask) | lastdwtr; 
            else x=DMMUW(x);
        if(forceex)return;
    }
    if(x<PHYSMEM) {
        _SMEM(x,d); 
    } else {
    }
}

void SMEM8(unsigned int x, unsigned int d) {
    if(SR & SR_DME) {
        if((x&lastdwmask)==lastdwmr) x= (x&~lastdwmask) | lastdwtr; 
            else x=DMMUW(x);
        if(forceex)return;
    }
    if(x<PHYSMEM) {
        _SMEM8(x,d); 
    } else {
        if(x==IO) putchar(d);
    }
}

void SMEM16(unsigned int x, unsigned int d) {
    if(x&1) {
        forceex=EX_ALGN;
        return;
    }
    if(SR & SR_DME) {
        if((x&lastdwmask)==lastdwmr) x= (x&~lastdwmask) | lastdwtr; 
            else x=DMMUW(x);
        if(forceex)return;
    }
    if(x<PHYSMEM) {
        _SMEM16(x,d); 
    } else {
    }
}


