/* ----------------------------------------------------------------------- */
/* printf */

void printchar(int c) {
    unsigned char *cc=(unsigned char *)0xc0000000;
    *cc=c; 
}

printn(int i) {
    char d[25]; 
    int j,k;
    
    if(i<0) {
        printchar('-');
        i=-i;
    }
    
    j=0;
    
    do {
        k=i/10;
        d[j]='0'+i-k*10;
        i=k;
        j++;
    } while (i);
    while(--j>=0)printchar(d[j]);
}

printx(unsigned int i) {
    char d[25]; 
    int j,k;
    
    if(i<0) {
        printchar('-');
        i=-i;
    }
    
    j=0;
    
    do {
        k=i/16;
        d[j]='0'+i-k*16;
        if(d[j]>'9')d[j]+=39;
        i=k;
        j++;
    } while (i);
    while(--j>=0)printchar(d[j]);
}

void printf(const unsigned char *fmt, ... ) {

    int i, l, params[16];
    int cp;
    char *str;
    register int v1 asm ("r4");
    register int v2 asm ("r5");
    
    params[0]=v1;
    params[1]=v2;
    asm("l.lws r5, 0(r2)");
    params[2]=v2;
    asm("l.lws r5, 4(r2)");
    params[3]=v2;
    asm("l.lws r5, 8(r2)");
    params[4]=v2;
    params[5]=0;
    cp=0;
    l=0;
    while(fmt[l]) {
        if(fmt[l]=='%') {
            int cont;

            l++;            
            cont=1;
            while(cont) {
                switch(fmt[l]) {
                    case 'd':
                    case 'u':
                    case 'i':
                        printn(params[cp++]);
                        cont=0;
                        break;
                    case 'x':
                        printx(params[cp++]);
                        cont=0;
                        break;
                    case 'c':
                        printchar(params[cp++]);
                        cont=0;
                        break;
                    case '%':
                        printchar('%');
                        cont=0;
                        break;
                }
                if(cont)l++;
            }
        } else printchar(fmt[l]);
        l++;
        if(cp>5)cp=5;
    }
}

/* ----------------------------------------------------------------------- */
/* Strings / Memory */

char *strcpy (char *dst0, char *src0)
{
	char *s = dst0;

        while (*dst0++ = *src0++);

	return s;	
}

int strcmp (const char *s1, const char *s2)
{
	char x;
	
	while ((x = *s1++) && (x == *s2++));
	
        return (*(unsigned char *) s1) - (*(unsigned char *) s2);
}

void bcopy(const void *srcvoid, void * dstvoid, int length)
{
  char *dst = dstvoid;
  const char *src = srcvoid;

  while (length--)
	  *dst++ = *src++;
}

/* ----------------------------------------------------------------------- */
/* System */

unsigned int read_timer(int x)
{
	register unsigned long count asm("r3") ;

        asm("l.sys 201");

	return count;
}

#if 0
void report(unsigned long value)
{
	unsigned long spr = 0x1234;
	asm("l.mtspr\t\t%0,%1,0x0" : : "r" (spr), "r" (value));
	return;
}
#else
void report(unsigned long value)
{
	unsigned long spr = 0x1234;
	printf("l.mtspr %x,%x\n", spr, value);
	return;
}
#endif

void exit(int x) {
    	asm("l.sys 203");
}

void __main()
{
}

