#include <linux/config.h>
#include <linux/module.h>
#include <linux/version.h>

#include <linux/init.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/slab.h>
#include <linux/pci.h>

#include <asm/uaccess.h>
#include <asm/io.h>

#include <asm/system.h>   /* cli(), *_flags */
#include <asm/segment.h>  /* memcpy and such */
#include <asm/pgtable.h>

#include "bcm.h"

#define DEVNAME "BCM"

static struct bcm_dev *bdev;

struct bcm_transfer trans;

void tx_notify(struct bcm_dev *bdev, struct bcm_transfer *tr) {

	printk(KERN_INFO "tx_notified: len=%i\n",tr->len);

}

void rx_action(struct bcm_dev *bdev, struct bcm_transfer *tr){
	printk(KERN_INFO "rx_acted: len=%i  bytes: %02x %02x %02x %02x\n",
			tr->len,tr->buffer[0],tr->buffer[1],tr->buffer[2],tr->buffer[3]);
}

struct bcm_payload payload={
	1,
	tx_notify,
	rx_action
};

int binit(struct dev_info *dev) {
	bdev=dev->bcm;
	printk(KERN_INFO "init called, %s\n", dev->identity);
	bcm_register_payload(bdev, &payload);
	trans.flags=FLAGS_NOTIFY;
	trans.proto=1;
	trans.len=2500;
	trans.buffer=kmalloc(5000, GFP_KERNEL);
	trans.buffer[0]=12;
	trans.buffer[1]=65;
	trans.buffer[2]=66;
	trans.buffer[3]=67;

	trans.dev=bdev;
	bcm_transfer_data(&trans);
	return 0;
}

static struct bcm_driver driver= {
	binit,
	NULL
};

static int __init s(void) {
	bcm_register_driver(&driver);	
	return 0;
}

static void __exit e(void) {
	return;
}

module_init(s);
module_exit(e);
MODULE_LICENSE("GPL");
