#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include "myts.h"
#include "pixop.h"
#include "font.h"

#define FONTHEIGHT 16

static unsigned int quadbits[256];

struct font font_pixmap = {
        .code_first = 0,
        .code_last = 255,
        .width =        8,
        .height =       16,
        .bpp =  4,
};

#define BE2LE(x) (x << 24 | x >> 24 | (x & (uint32_t)0x0000ff00UL) << 8 | (x & (uint32_t)0x00ff0000UL) >> 8)

static void calcquadbits()
{
    unsigned int j;
    int i,k;
    for (i=0;i<256;i++) {
        j=0;
        for(k=0;k<8;k++) {
            j<<=4;
            if(i&(128>>k))j+=15;
        }
        quadbits[i]=BE2LE(j);
        DBG(2,"quadbits[%02x]=%08x\n", i, j);
    }
}

int init_font(const char *cp, const char *font) {
    int cpf;
    int i;
    FILE *fontf;
    int charsdone;
    unsigned short cpb[256];

    calcquadbits();
    font_pixmap.pixmap=malloc((font_pixmap.code_last-font_pixmap.code_first+1)*
                                font_pixmap.width*font_pixmap.height*font_pixmap.bpp/8);

    cpf=open(cp,O_RDONLY);
    if(cpf<0) return -1;
    read(cpf,cpb,512);
    for (i=0;i<256;i++) {
        DBG(3,"CP Table %i = %04x\n", i, cpb[i]);
    }
    close(cpf);
    fontf=fopen(font,"r");
    if(fontf<0) return -2;
    charsdone=0;
    while(!feof(fontf) && charsdone<256){
        char line[1024];
        int i,j;
        unsigned int pix[FONTHEIGHT];

        fgets(line,1022,fontf);
        i=sscanf(line,"%04x:%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x", 
                &j, 
                &pix[0], &pix[1], &pix[2], &pix[3],
                &pix[4], &pix[5], &pix[6], &pix[7],
                &pix[8], &pix[9], &pix[10], &pix[11],
                &pix[12], &pix[13], &pix[14], &pix[15]);
        DBG(3,"i=%d\n",i);
        if(i<17) DBG(3, "Short font line. i=%d\n",i);
        DBG(3, "Found unicode char %04x.\n", j);
        if(i==17) {
            int l;
            for(l=0;l<256;l++){
                if(j==cpb[l]) {
                    unsigned int *p;
                    int k;
                    charsdone++;
                    DBG(3, "Found char %04x %02x\n", j, l);
                    p=(unsigned int *)(font_pixmap.pixmap+l*font_pixmap.width*font_pixmap.height*font_pixmap.bpp/8);
                    for(k=0;k<FONTHEIGHT;k++) *p++=quadbits[pix[k]];
                }
            }
        }
    }
    if(charsdone<256) DBG(0, "%d chars found.\n", charsdone);
    return 0;
}
