#include <X11/Xlib.h>
#include <X11/Xutil.h>
#define XK_MISCELLANY
#include <X11/keysymdef.h>
#include <stdio.h>

#include "bd.h"
#include "keys.h"

int color_fg;
int color_bg;
int color_uitext;
int color_selected;
int color_cursor;
int color_decor;

static char zero[8192];

static int xmax,xmin,ymax,ymin;

Window w;
Display *dpy;
Pixmap pm;
int scr;
int bpp;
Visual *vis;
XSetWindowAttributes attr;
GC gc, pmgc;
XGCValues values;
XImage *im;
char *mem;

int InputMask=KeyPressMask|ExposureMask|ResizeRedirectMask;

int readchar() {

    int ch;
    XEvent event;
    XKeyEvent *kev;
    XResizeRequestEvent *rev;
    int kc;
    
    ch=0;
    if((xmin<=xmax)&&(ymin<=ymax)) {
        XPutImage(dpy,w,gc,im,xmin,ymin,xmin,ymin,xmax-xmin+1,ymax-ymin+1);
//printf("readch %i,%i   %i,%i\n",xmin,ymin,xmax,ymax);
        xmin=display_width;
        xmax=0;
        ymin=display_pix_height;
        ymax=0;
    }
    while(ch==0) {
        XNextEvent(dpy, &event);
        switch(event.type) {
            case KeyPress:
                kev=(XKeyEvent *)&event;
                switch(kev->keycode) {
                    case 97: case 98: case 99: case 100: 
                        kc=kev->keycode+5;
                        break;
                    case 102: case 103: case 104: case 105:
                    case 106: case 107:
                        kc=kev->keycode+4;
                        break;
                    case 110: 
                        kc=101;
                        break;
                    case 111: 
                        kc=99;
                        break;
                    case 112: 
                        kc=96;
                        break;
                    case 116: 
                        kc=98;
                        break;
                    default:
                        kc=kev->keycode-8;
                }
                ch=translate_keycode(kc,kev->state);
                break;
            case Expose:
            case GraphicsExpose:
                XPutImage(dpy,w,gc,im,0,0,0,0,display_width,display_pix_height);
                xmin=display_width;
                xmax=0;
                ymin=display_pix_height;
                ymax=0;
                break;
            case ResizeRequest:
                rev=(XResizeRequestEvent *)&event;
                
                /* This can probably be done in a simpler way */
                XSelectInput(dpy,w,InputMask & ~ResizeRedirectMask);
                XResizeWindow(dpy,w,rev->width,rev->height);
                XFlush(dpy);
                XSelectInput(dpy,w,InputMask);

                changesize(rev->width,rev->height,DPI);
                break;
            default:
                printf("Event: %i\n",event.type);
        }
    }
    return ch;
}

int graphics_changesize() {

    XDestroyImage(im);
    XFreeGC(dpy,gc);
    
    gc=XCreateGC(dpy,w,0,&values);

    mem=(char *)malloc(display_pix_height*screen_pitch);
    im=XCreateImage(dpy,vis,bpp,ZPixmap,0,mem,display_width,display_pix_height,32,screen_pitch);

    graphbase=mem;
    return 0;
}

int init_graphics() {
    short *p;
    int i;
    char *displayname;
    XSizeHints *sizehints;
    
    displayname=getenv("DISPLAY");
    
    if(displayname==NULL) {
        printf("No default display.\n");
        exit(1);
    }
    
    dpy= XOpenDisplay(displayname);
    w = XCreateWindow(dpy, DefaultRootWindow(dpy), 0, 0, display_width, display_pix_height, 0, 
        	CopyFromParent, CopyFromParent, CopyFromParent,
                0, 0);
    XMapWindow(dpy, w);
    scr=DefaultScreen(dpy);
    bpp=DefaultDepth(dpy,scr);
    screen_bpp=(bpp+7)/8;
    vis=DefaultVisual(dpy,scr);
    gc=XCreateGC(dpy,w,0,&values);

    vis_pitch=vis_width*screen_bpp;
    screen_pitch=display_width*screen_bpp;

    mem=(char *)malloc(display_pix_height*screen_pitch);
    im=XCreateImage(dpy,vis,bpp,ZPixmap,0,mem,display_width,display_pix_height,32,screen_pitch);
    
    XPutImage(dpy,w,gc,im,0,0,0,0,display_width,display_pix_height);
    
    sizehints=XAllocSizeHints();
    sizehints->flags=PMinSize;
    sizehints->min_width=320;
    sizehints->min_height=240;
    
    XSetWMNormalHints(dpy,w,sizehints);
    XFree(sizehints);
    
    XFlush(dpy);

    graphbase=mem;
    
    switch(screen_bpp) {
        case 2:
            color_fg=0x0;
            color_bg=0xffff;
            color_uitext=0x400;
            color_selected=0x8000;
            color_cursor=0x8200;
            color_decor=0xfa06;
            p=(short *)zero;
            for(i=0;i<4096;i++)*(p+i)=color_bg;
            break;
        case 1:
            color_bg=15;
            color_fg=0;
            color_uitext=7;
            color_selected=4;
            color_cursor=0x87;
            color_decor=13;
            memset(zero,color_bg,8192);
            break;
    };

    XPutImage(dpy,w,gc,im,0,0,0,0,display_width,display_pix_height);
    xmin=display_width;
    xmax=0;
    ymin=display_pix_height;
    ymax=0;

    XSelectInput(dpy,w,InputMask );
    
    return 0;
}

int close_graphics() {
    return 0;
}

static int drawscansegment(char *buf, int x, int y, int pitch) {
    char *b;
    
    b=mem+screen_pitch*y+x*screen_bpp;
    memcpy(b,buf,pitch);
    if(x<xmin)xmin=x;
    if(y<ymin)ymin=y;
    if(x+pitch/screen_bpp>xmax)xmax=x+pitch/screen_bpp;
    if(y>ymax)ymax=y;
    
    return 0;
}

static int getscansegment(char *buf, int x, int y, int pitch) {
    char *b;
    
    b=mem+screen_pitch*y+x*screen_bpp;
    memcpy(buf,b,pitch);
    return 0;
}

int save_area(int x, int y, int pitch, int height, char *buf)
{
    int i;
    
    for(i=0;i<height;i++) {
        getscansegment(buf+pitch*i, x, y+i, pitch);
    }
    return 0;
}

int restore_area(int x, int y, int pitch, int height, char *buf)
{
    int i;
    
    for(i=0;i<height;i++) {
        drawscansegment(buf+pitch*i, x, y+i, pitch);
    }
    if((xmin<=xmax)&&(ymin<=ymax)) {
        XPutImage(dpy,w,gc,im,xmin,ymin,xmin,ymin,xmax-xmin+1,ymax-ymin+1);
//printf("restore %i,%i   %i,%i\n",xmin,ymin,xmax,ymax);
        xmin=display_width;
        xmax=0;
        ymin=display_pix_height;
        ymax=0;
    }
    
    return 0;
}

int blank_area(int x, int y, int pitch, int height)
{
    int i;
    
    for(i=0;i<height;i++) {
        drawscansegment(zero, x, y+i, pitch);
    }
    return 0;
}

int drawline(int x1, int y1, int x2, int y2, int col) {
    char *m;
    int d,n;
    
    m=graphbase+screen_pitch*y1+x1*screen_bpp;
    if(x2>x1) {
        d=screen_bpp;
        n=x2-x1;
    } else if (y1<y2) {
        d=screen_pitch;   
        n=y2-y1;
    } else return -1;

    for(;n>0;n--) {
        switch(screen_bpp) {
            case 1:
                *m=col;
                break;
            case 2:
                *(short *)m=col;
                break;
            case 4:
                *(long *)m=col;
                break;
            case 3:
                *m=col&0xff;
                *(m+1)=(col>>16)&0xff;
                *(m+2)=(col>>24)&0xff;
        }
        m+=d;
    }
/*
    if(x1<x2) {
        for(i=x1;i<=x2;i++)XPutPixel(im,i,y1,col);
    } else if(y1<y2) {
        for(i=y1;i<=y2;i++)XPutPixel(im,x1,i,col);
    }
*/
    if(x1<xmin)xmin=x1;
    if(y1<ymin)ymin=y1;
    if(x2>xmax)xmax=x2;
    if(y2>ymax)ymax=y2;

/*
    if((xmin<=xmax)&&(ymin<=ymax))
        XPutImage(dpy,w,gc,im,xmin,ymin,xmin,ymin,xmax-xmin+1,ymax-ymin+1);
printf("drawline %i,%i   %i,%i\n",xmin,ymin,xmax,ymax);
    xmin=display_width;
    xmax=0;
    ymin=display_pix_height;
    ymax=0;
*/

    return 0;
}

