#include "ft.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define MAXPARCHARS 1024

#define DISPWIDTH (WIDTH*dpi/72)
#define POINTSIZE 12
#define MAXFONTFILES 256

extern int PDPI;
extern int DPI;
extern int UDPI;
extern int WIDTH;
extern int HEIGHT;
extern int left_skip;
extern int left_spare;
extern int top_skip;
extern int vis_width;
extern int vis_height;
extern int vis_pix_height;
extern int vis_pitch;

extern int display_width;
extern int display_height;
extern int display_pix_height;

extern int page_width;
extern int page_height;
extern int page_right_margin;
extern int page_left_margin;
extern int page_top_margin;
extern int page_bottom_margin;

extern int color_fg;
extern int color_bg;
extern int color_uitext;
extern int color_selected;
extern int color_cursor;
extern int color_decor;

extern int ui_unit;
extern int ui_x;
extern int ui_y;
extern int ui_height;
extern int ui_width;

extern int autosavekeyinterval;

extern int volatile_selection;

extern int lasty;

extern int curfont;

typedef struct {
    int st;
    int end;
    int visend;
    int height;
    int width;
    int extwidth;
    int indent;
    int len;
    int yskip;
    int yoffs; /* relative to paragraph */
    int flags;
} line_t;

/* 
par_t.style is a bitfield
    0-1 language direction
    2-3 alignment/justification
    4   margin is from right/left
*/

typedef struct par_type {
/* those are "cache" values. They can be calculated */
    int line_pix_height;
    int line_point_height;
    int par_point_height;
    int par_point_ypos;
    int numlines;
    int lastline;
    int cacheflags;
    unsigned char *vistext;
    guint16 *v2l;
    line_t *lines[100];
    int *xpos;
    int *cfont;
/* this should be selected as the tallest of all fonts used */
    FT_font *font; 
    int ascender;
    
/* Those define the paragraph */
    int par_point_width;
    int par_point_margin;
    int style;
    int lineskip;
    int firstlineskip;
    int firstlineindent;
    
    unsigned char *text;

    int numfontchanges;
    int fontchange[64];
    int fontchangepos[64];
    
    int numtabs;
    int tabs[16];
    
    struct par_type *next;
    struct par_type *prev;
    struct par_type *parent;
} par_t;

typedef struct {
    char family[48];
    char fname[4][176];
    int flags;
    int style_flags;
    int face_flags;
} font_file_t;

typedef struct {
    int pos;
    par_t *par;
} pos_t;

#define SETPOS(x,y,z) {x.pos=y; x.par=z; }

extern FT_font *fonts[256];
extern FT_font *ui_font;
extern FT_font *ui_sfont;
extern font_file_t *fontfiles[MAXFONTFILES];
extern int fontfilesnum;
extern int fontsnum;
extern char fontpath[2040];
extern char printfile[2040];
extern par_t *first_par, *last_par;
extern pos_t sel_st, sel_end, curpos;

extern char filename[128];
extern char template[128];
extern char autosavefilename[128];

/* ui.c */
extern int choose_font(char *, int, int, int);
extern int choose_file_name(char *, char *);
extern int choose_parameters(par_t *);
extern int choose_tabs(par_t *);

/* io.c xio.c */
extern int save_area(int, int, int, int, char *);
extern int restore_area(int, int, int, int, char *);
extern int blank_area(int, int, int, int);
extern int init_graphics();
extern int close_graphics();
extern int drawline(int, int, int, int, int);
extern int graphics_changesize();
extern int readchar();

/* par.c */
extern par_t *new_par(par_t *);
extern int insert_par(par_t *, par_t *);
extern int del_par(par_t *par);
extern par_t *dup_par(par_t *par, int, int);
extern void free_par(par_t *par);

/* format.c */
extern int break_paragraph(par_t *, int, int);
extern int par_calc_cursor(par_t *, int, int, int *, int *, int *, int *);
extern int reformat(int, int, par_t *);
extern int par_calc_lines_ypos(par_t *, int);

/* files.c */
extern int save(char *, par_t *);
extern int load(char *);
extern int makeautosavename(char *, char *);

/* fonts.c */
extern int init_fonts(void);
extern int open_font(char *, int, int, int);
extern int open_ui_font(char *, int, int, int);
extern int change_fontres(FT_font *, int);

/* print.c */
extern int print_ps();

/* commands.c */
extern int split_par(par_t *, int);
extern int join_par(par_t *);
extern int insert_char(par_t *, int, int);
extern int del_char(par_t *, int);
extern int del_range(pos_t , pos_t );
extern int set_font_range(pos_t, pos_t, int);
extern int set_par_style(par_t *, int, int, int);

/* config.c */
extern int readconfigfile(void);
extern int set_size();

/* keyboard.c */
extern int translate_keycode(int, int);
extern int hebconv(int);

/* main.c */
extern int display_par_simple(par_t *, int, int, int, int, int, int, int);
extern int changesize(int, int, int);
extern int writen(int, int, int, unsigned char *, par_t *, int);
extern void writen_md(int, int, int, unsigned char *, par_t *, int, int, int);
extern int fontof(par_t *, int);
extern int selection(void);
extern int selected(par_t *, int);
extern int calc_xoffs_r2l(par_t *, int, int, int *, int *);
extern int clear_flags(void);

/* position.c */
extern pos_t pos_next(pos_t);
extern pos_t pos_prev(pos_t);
extern int pos_prior(pos_t, pos_t);
extern int pos_equal(pos_t, pos_t);
extern int pos_cmp(pos_t, pos_t);


