#include <freetype2/freetype.h>

typedef struct {
    FT_Bitmap bitmap;
    FT_Glyph_Metrics metrics;
    int flags;
    int horiAdvance; /* unscaled */
} font_element;

typedef struct {
    FT_Face face;
    font_element chars[256];
    FT_F26Dot6 width;
    FT_F26Dot6 height;
    int x_resolution;
    int y_resolution;
    FT_F26Dot6 pix_height;
    int ul_thickness;
    int ul_pos;
    FT_F26Dot6 ascender;
    FT_F26Dot6 descender;
} FT_font;

extern unsigned char *graphbase;
extern int screen_pitch;
extern int screen_bpp;
extern int ft_fg;
extern int ft_bg;
extern int ft_transparent;
extern font_element *ft_font;

extern int ft_writen(int,int,int, unsigned char *);
extern int loadfont(FT_font*, char*, int, int, int, int);
extern int checkfontencoding(char *,int *, int*, char*);
extern int drawchar(font_element *,int,int,int,int,int,int);
extern int changefontsize(FT_font *,int,int,int,int);
