#############################################################################
##
#W  numsgp-def.gd           Manuel Delgado <mdelgado@fc.up.pt>
#W                          Pedro A. Garcia-Sanchez <pedro@ugr.es>
#W                          Jose Morais <josejoao@fc.up.pt>
##
##
#H  @(#)$Id: numsgp-def.gd,v 0.971 $
##
#Y  Copyright 2005 by Manuel Delgado,
#Y  Pedro Garcia-Sanchez and Jose Joao Morais
#Y  We adopt the copyright regulations of GAP as detailed in the
#Y  copyright notice in the GAP manual.
##
#############################################################################


DeclareInfoClass("InfoNumSgps");



#############################################################################
##
#R  IsNumericalSemigroupRep
##
##  The representation of a numerical semigroup.
##
#############################################################################
DeclareRepresentation( "IsNumericalSemigroupRep",
        IsComponentObjectRep and IsAttributeStoringRep and IsAdditiveElement and IsAdditiveElementWithInverse and IsMultiplicativeElement,
        ["list"]);


#############################################################################
##
#C  IsNumericalSemigroup
##
##  The category of numerical semigroups.
##
#############################################################################
DeclareCategory( "IsNumericalSemigroup", IsObject and IsNumericalSemigroupRep);


#############################################################################
##
#C  IsNumericalSemigroup
##
##  The family category of numerical semigroups.
##
#############################################################################
DeclareCategoryFamily( "IsNumericalSemigroup" );


#############################################################################
##
#C  IsNumericalSemigroup
##
##  The collections category of numerical semigroups.
##
#############################################################################
DeclareCategoryCollections( "IsNumericalSemigroup" );



BindGlobal( "NumericalSemigroupsFamily",
        NewFamily( "NumericalSemigroups", IsNumericalSemigroup ));

BindGlobal( "NumericalSemigroupsType",
        NewType( NumericalSemigroupsFamily, IsNumericalSemigroup));




#############################################################################
##
#F  NumericalSemigroupByGenerators(arg)
##
##  Returns the numerical semigroup generated by arg.
##
#############################################################################
DeclareGlobalFunction( "NumericalSemigroupByGenerators" );


#############################################################################
##
#F  NumericalSemigroupByMinimalGenerators(arg)
##
##  Returns the numerical semigroup minimally generated by arg.
##  If the generators given are not minimal, the minimal ones
##  are computed and used.
##
#############################################################################
DeclareGlobalFunction( "NumericalSemigroupByMinimalGenerators" );



#############################################################################
##
#F  NumericalSemigroupByMinimalGeneratorsNC(arg)
##
##  Returns the numerical semigroup minimally generated by arg.
##  No test is made about args' minimality.
##
#############################################################################
DeclareGlobalFunction( "NumericalSemigroupByMinimalGeneratorsNC" );



#############################################################################
##
#F  ModularNumericalSemigroup(a,b)
##
##  Returns the modular numerical semigroup satisfying ax mod b <= x
##
#############################################################################
DeclareGlobalFunction( "ModularNumericalSemigroup" );



#############################################################################
##
#F  ProportionallyModularNumericalSemigroup(a,b,c)
##
##  Returns the proportionally modular numerical semigroup
##  satisfying ax mod b <= cx
##
#############################################################################
DeclareGlobalFunction( "ProportionallyModularNumericalSemigroup" );



#############################################################################
##
#F  NumericalSemigroupByInterval(arg)
##
##  Returns the numerical semigroup
##
#############################################################################
DeclareGlobalFunction( "NumericalSemigroupByInterval" );



#############################################################################
##
#F  NumericalSemigroupByOpenInterval(arg)
##
##  Returns the numerical semigroup
##
#############################################################################
DeclareGlobalFunction( "NumericalSemigroupByOpenInterval" );



#############################################################################
##
#F  NumericalSemigroupBySubAdditiveFunction(L)
##
##  Returns the numerical semigroup specified by the subadditive
##  function L.
##
#############################################################################
DeclareGlobalFunction( "NumericalSemigroupBySubAdditiveFunction" );



#############################################################################
##
#F  NumericalSemigroupByAperyList(L)
##
##  Returns the numerical semigroup specified by the Apery list L.
##
#############################################################################
DeclareGlobalFunction( "NumericalSemigroupByAperyList" );



#############################################################################
##
#F  NumericalSemigroupBySmallElements(L)
##
##  Returns the numerical semigroup specified by L,
##  which must be the list of elements of a numerical semigroup,
##  not greater than the Frobenius number + 1.
##
#############################################################################
DeclareGlobalFunction( "NumericalSemigroupBySmallElements" );


#############################################################################
##
#F  NumericalSemigroupByGaps(L)
##
##  Returns the numerical semigroup specified by L,
##  which must be the list of gaps of a numerical semigroup.
##
#############################################################################
DeclareGlobalFunction( "NumericalSemigroupByGaps" );



#############################################################################
##
#F  NumericalSemigroupByFundamentalGaps(L)
##
##  Returns the numerical semigroup specified by L,
##  which must be the list of fundamental gaps of a numerical semigroup.
##
#############################################################################
DeclareGlobalFunction( "NumericalSemigroupByFundamentalGaps" );


#############################################################################
##
#F  NumericalSemigroup(arg)
##
##  This function's first argument may be one of:
##  "generators", "minimalgenerators", "modular",
##  "propmodular", "elements", "gaps",
##  "fundamentalgaps", "subadditive" or "apery" according to
##  how the semigroup is being defined.
##  The following arguments must conform to the arguments of
##  the corresponding function defined above.
##  By default, the option "generators" is used, so,
##  gap> NumericalSemigroup(3,7);
##  <Numerical semigroup with 2 generators>
##
##
#############################################################################
DeclareGlobalFunction( "NumericalSemigroup" );



#############################################################################
##
#A  IsNumericalSemigroupByGenerators(S)
##
##  Tests if a numerical semigroup was given by its generators.
##
#############################################################################
DeclareAttribute( "IsNumericalSemigroupByGenerators", IsNumericalSemigroup);


#############################################################################
##
#A  IsNumericalSemigroupByMinimalGenerators(S)
##
##  Tests if a numerical semigroup was given by its minimal generators.
##
#############################################################################
DeclareAttribute( "IsNumericalSemigroupByMinimalGenerators", IsNumericalSemigroup);



#############################################################################
##
#A  IsNumericalSemigroupByInterval(S)
##
##  Tests if a numerical semigroup was given by an interval.
##
#############################################################################
DeclareAttribute( "IsNumericalSemigroupByInterval", IsNumericalSemigroup);



#############################################################################
##
#A  IsNumericalSemigroupByOpenInterval(S)
##
##  Tests if a numerical semigroup was given by an open interval.
##
#############################################################################
DeclareAttribute( "IsNumericalSemigroupByOpenInterval", IsNumericalSemigroup);



#############################################################################
##
#A  IsNumericalSemigroupBySubAdditiveFunction(S)
##
##  Tests if a numerical semigroup was given by a subadditive function.
##
#############################################################################
DeclareAttribute( "IsNumericalSemigroupBySubAdditiveFunction", IsNumericalSemigroup);



#############################################################################
##
#A  IsNumericalSemigroupByAperyList(S)
##
##  Tests if a numerical semigroup was given by its Apery list.
##
#############################################################################
DeclareAttribute( "IsNumericalSemigroupByAperyList", IsNumericalSemigroup);


#############################################################################
##
#A  IsNumericalSemigroupBySmallElements(S)
##
##  Tests if a numerical semigroup was given by its small elements.
##
#############################################################################
DeclareAttribute( "IsNumericalSemigroupBySmallElements", IsNumericalSemigroup);


#############################################################################
##
#A  IsNumericalSemigroupByGaps(S)
##
##  Tests if a numerical semigroup was given by its gaps.
##
#############################################################################
DeclareAttribute( "IsNumericalSemigroupByGaps", IsNumericalSemigroup);




#############################################################################
##
#A  IsNumericalSemigroupByFundamentalGaps(S)
##
##  Tests if a numerical semigroup was given by its fundamental gaps.
##
#############################################################################
DeclareAttribute( "IsNumericalSemigroupByFundamentalGaps", IsNumericalSemigroup);



#############################################################################
##
#A  IsProportionallyModularNumericalSemigroup(S)
##
##  Tests if a numerical semigroup is proportionally modular.
##
#############################################################################
DeclareAttribute( "IsProportionallyModularNumericalSemigroup", IsNumericalSemigroup);



#############################################################################
##
#A  IsModularNumericalSemigroup(S)
##
##  Tests if a numerical semigroup is modular.
##
#############################################################################
DeclareAttribute( "IsModularNumericalSemigroup", IsNumericalSemigroup);
