#############################################################################
##
#W  orbits.tst
#Y  Copyright (C) 2011-12                                James D. Mitchell
##
##  Licensing information can be found in the README file of this package.
##
#############################################################################
##

#ReadTest(Filename(DirectoriesPackageLibrary("citrus","tst"),"orbits.tst"));
# about 0.1s
gap> START_TEST("Citrus package: orbits.tst");
gap> LoadPackage("citrus", false);;

#
gap> InfoLevelInfoWarning:=InfoLevel(InfoWarning);;
gap> InfoLevelInfoCitrus:=InfoLevel(InfoCitrus);;
gap> SetInfoLevel(InfoWarning, 0);;
gap> SetInfoLevel(InfoCitrus, 0);

#
gap> gens:=[ Transformation( [ 1, 5, 2, 2, 3, 5, 2 ] ), 
>  Transformation( [ 7, 3, 6, 5, 2, 4, 1 ] ), 
>  Transformation( [ 7, 5, 3, 2, 5, 5, 6 ] ) ];;
gap> m:=Monoid(gens);;
gap> GradedImagesOfTransSemigroup(m);
[ [ [ 5 ], [ 3 ], [ 2 ], [ 6 ], [ 4 ] ], 
  [ [ 2, 5 ], [ 2, 3 ], [ 3, 5 ], [ 3, 6 ], [ 1, 5 ], [ 5, 7 ], [ 2, 6 ], 
      [ 4, 6 ], [ 1, 3 ], [ 2, 7 ], [ 1, 2 ], [ 5, 6 ], [ 3, 4 ], [ 4, 5 ], 
      [ 6, 7 ], [ 3, 7 ], [ 2, 4 ], [ 1, 4 ], [ 1, 6 ], [ 4, 7 ] ], 
  [ [ 3, 5, 7 ], [ 2, 3, 5 ], [ 3, 5, 6 ], [ 1, 2, 6 ], [ 2, 3, 6 ], 
      [ 1, 2, 5 ], [ 2, 4, 6 ], [ 3, 4, 7 ], [ 3, 4, 6 ], [ 1, 3, 5 ], 
      [ 2, 3, 7 ], [ 3, 4, 5 ], [ 2, 5, 6 ], [ 1, 5, 6 ], [ 4, 5, 6 ], 
      [ 1, 2, 3 ], [ 2, 6, 7 ], [ 1, 3, 6 ], [ 2, 5, 7 ], [ 2, 3, 4 ], 
      [ 2, 4, 7 ], [ 2, 4, 5 ], [ 3, 6, 7 ], [ 1, 3, 4 ], [ 4, 6, 7 ], 
      [ 1, 4, 6 ], [ 5, 6, 7 ], [ 1, 4, 5 ], [ 4, 5, 7 ], [ 1, 2, 4 ] ], 
  [ [ 1, 2, 3, 5 ], [ 2, 3, 6, 7 ], [ 1, 3, 4, 6 ], [ 2, 3, 5, 7 ], 
      [ 4, 5, 6, 7 ], [ 2, 3, 5, 6 ], [ 1, 2, 3, 6 ], [ 1, 2, 4, 5 ], 
      [ 2, 3, 4, 6 ], [ 3, 4, 6, 7 ], [ 3, 4, 5, 6 ], [ 1, 4, 5, 6 ], 
      [ 2, 4, 5, 6 ], [ 2, 4, 5, 7 ], [ 2, 3, 4, 5 ] ], 
  [ [ 2, 3, 5, 6, 7 ], [ 1, 2, 3, 4, 6 ], [ 3, 4, 5, 6, 7 ], 
      [ 1, 2, 4, 5, 6 ], [ 2, 3, 4, 5, 7 ], [ 1, 2, 3, 5, 6 ], 
      [ 2, 3, 4, 6, 7 ], [ 1, 3, 4, 5, 6 ], [ 2, 4, 5, 6, 7 ], 
      [ 1, 2, 3, 4, 5 ] ], [  ], [ [ 1 .. 7 ] ] ]
gap> Enumerate(ImagesOfTransSemigroup(m));;
gap> Set(Concatenation(GradedImagesOfTransSemigroup(m)))
> =Set(ImagesOfTransSemigroup(m));
true
gap> ForAll(GradedImagesOfTransSemigroup(m), x-> ForAll(x, y-> Length(y)
> =Length(x[1])));
true
gap> Enumerate(KernelsOfTransSemigroup(m));;
gap> Set(Concatenation(GradedKernelsOfTransSemigroup(m)))
> =Set(KernelsOfTransSemigroup(m));
true
gap> gens:=[ Transformation( [ 2, 4, 1, 5, 4, 4, 7, 3, 8, 1 ] ), 
>   Transformation( [ 3, 2, 8, 8, 4, 4, 8, 6, 5, 7 ] ), 
>   Transformation( [ 4, 10, 6, 6, 1, 2, 4, 10, 9, 7 ] ), 
>   Transformation( [ 6, 2, 2, 4, 9, 9, 5, 10, 1, 8 ] ), 
>   Transformation( [ 6, 4, 1, 6, 6, 8, 9, 6, 2, 2 ] ), 
>   Transformation( [ 6, 8, 1, 10, 6, 4, 9, 1, 9, 4 ] ), 
>   Transformation( [ 8, 6, 2, 3, 3, 4, 8, 6, 2, 9 ] ), 
>   Transformation( [ 9, 1, 2, 8, 1, 5, 9, 9, 9, 5 ] ), 
>   Transformation( [ 9, 3, 1, 5, 10, 3, 4, 6, 10, 2 ] ), 
>   Transformation( [ 10, 7, 3, 7, 1, 9, 8, 8, 4, 10 ] ) ];;
gap> s:=Semigroup(gens);;
gap> o:=Orb(s, [1,2,3,4], OnSets);; Enumerate(o);;
gap> StrongOrbitsInForwardOrbit(o);
[ [ [ 9 ], [ 4 ], [ 5 ], [ 6 ], [ 3 ], [ 8 ], [ 10 ], [ 1 ], [ 2 ], [ 7 ] ], 
  [ [ 4, 6 ], [ 2, 6 ], [ 2, 10 ], [ 4, 8 ], [ 6, 10 ], [ 4, 9 ], [ 5, 8 ], 
      [ 1, 8 ], [ 4, 10 ], [ 7, 8 ], [ 6, 8 ], [ 5, 9 ], [ 4, 5 ], [ 1, 7 ], 
      [ 8, 10 ], [ 1, 4 ], [ 8, 9 ], [ 1, 9 ], [ 3, 5 ], [ 1, 6 ], [ 3, 4 ], 
      [ 2, 8 ], [ 3, 6 ], [ 2, 4 ], [ 2, 9 ], [ 4, 7 ], [ 3, 8 ], [ 1, 3 ], 
      [ 1, 2 ], [ 2, 3 ], [ 3, 7 ], [ 2, 5 ], [ 1, 10 ], [ 3, 10 ], [ 6, 7 ], 
      [ 7, 10 ], [ 3, 9 ], [ 6, 9 ], [ 9, 10 ], [ 7, 9 ], [ 1, 5 ], [ 5, 7 ], 
      [ 5, 6 ], [ 2, 7 ], [ 5, 10 ] ], 
  [ [ 2, 4, 5 ], [ 6, 8, 10 ], [ 1, 3, 4 ], [ 2, 3, 8 ], [ 1, 4, 6 ], 
      [ 4, 6, 10 ], [ 2, 6, 8 ], [ 2, 4, 6 ], [ 2, 4, 8 ], [ 1, 8, 9 ], 
      [ 4, 8, 10 ], [ 5, 8, 9 ], [ 3, 4, 8 ], [ 3, 7, 8 ], [ 1, 6, 9 ], 
      [ 2, 4, 9 ], [ 8, 9, 10 ], [ 7, 9, 10 ], [ 1, 5, 8 ], [ 3, 6, 8 ], 
      [ 1, 3, 6 ], [ 2, 5, 9 ], [ 1, 2, 9 ], [ 2, 3, 5 ], [ 1, 6, 10 ], 
      [ 4, 8, 9 ], [ 4, 7, 8 ], [ 1, 9, 10 ], [ 4, 6, 9 ], [ 4, 9, 10 ], 
      [ 1, 4, 8 ], [ 7, 8, 10 ], [ 1, 4, 9 ], [ 2, 5, 8 ], [ 2, 9, 10 ], 
      [ 2, 6, 9 ], [ 4, 7, 9 ], [ 1, 4, 5 ], [ 1, 7, 10 ], [ 1, 2, 7 ], 
      [ 3, 4, 9 ], [ 1, 2, 6 ], [ 4, 6, 8 ], [ 2, 6, 10 ], [ 2, 8, 9 ], 
      [ 1, 2, 10 ], [ 1, 2, 4 ], [ 3, 5, 9 ], [ 4, 5, 8 ], [ 5, 6, 10 ], 
      [ 2, 3, 10 ], [ 3, 7, 10 ], [ 4, 6, 7 ], [ 7, 8, 9 ], [ 5, 6, 8 ], 
      [ 3, 4, 6 ], [ 1, 6, 8 ], [ 2, 4, 10 ], [ 6, 7, 10 ], [ 2, 4, 7 ], 
      [ 3, 4, 5 ], [ 1, 3, 7 ], [ 3, 8, 10 ], [ 6, 7, 8 ], [ 6, 8, 9 ], 
      [ 4, 5, 6 ], [ 3, 5, 10 ], [ 2, 3, 9 ], [ 6, 9, 10 ], [ 4, 5, 7 ], 
      [ 4, 5, 10 ], [ 2, 5, 10 ], [ 3, 6, 9 ], [ 1, 3, 10 ], [ 1, 2, 8 ], 
      [ 2, 3, 6 ], [ 1, 2, 5 ], [ 3, 9, 10 ], [ 5, 7, 8 ], [ 5, 9, 10 ], 
      [ 1, 5, 9 ], [ 1, 4, 10 ], [ 3, 8, 9 ], [ 1, 3, 8 ], [ 1, 2, 3 ], 
      [ 1, 3, 9 ], [ 3, 5, 8 ], [ 3, 4, 10 ], [ 1, 7, 9 ], [ 1, 5, 6 ], 
      [ 2, 7, 8 ], [ 3, 4, 7 ], [ 1, 5, 7 ], [ 1, 8, 10 ], [ 4, 7, 10 ], 
      [ 3, 6, 7 ], [ 1, 4, 7 ], [ 2, 5, 7 ], [ 1, 7, 8 ], [ 2, 3, 7 ], 
      [ 4, 5, 9 ], [ 5, 6, 9 ], [ 2, 3, 4 ], [ 1, 3, 5 ], [ 6, 7, 9 ], 
      [ 3, 7, 9 ], [ 1, 6, 7 ], [ 2, 7, 9 ], [ 3, 6, 10 ], [ 2, 6, 7 ], 
      [ 2, 8, 10 ], [ 2, 5, 6 ], [ 1, 5, 10 ], [ 2, 7, 10 ], [ 3, 5, 6 ], 
      [ 5, 8, 10 ], [ 3, 5, 7 ], [ 5, 6, 7 ] ], 
  [ [ 1, 2, 3, 4 ], [ 1, 2, 4, 5 ], [ 2, 3, 4, 8 ], [ 1, 2, 8, 9 ], 
      [ 2, 3, 5, 6 ], [ 1, 4, 6, 8 ], [ 1, 4, 6, 10 ], [ 4, 6, 8, 9 ], 
      [ 3, 4, 5, 8 ], [ 1, 3, 4, 5 ], [ 2, 4, 6, 9 ], [ 2, 4, 6, 8 ], 
      [ 1, 5, 8, 9 ], [ 2, 3, 6, 8 ], [ 1, 2, 5, 9 ], [ 1, 2, 6, 9 ], 
      [ 2, 3, 4, 5 ], [ 1, 6, 8, 10 ], [ 3, 4, 6, 7 ], [ 3, 7, 8, 9 ], 
      [ 4, 6, 9, 10 ], [ 4, 5, 7, 8 ], [ 1, 6, 9, 10 ], [ 1, 6, 8, 9 ], 
      [ 3, 6, 9, 10 ], [ 2, 6, 7, 9 ], [ 2, 4, 5, 8 ], [ 3, 5, 6, 10 ], 
      [ 1, 2, 3, 10 ], [ 4, 6, 7, 10 ], [ 2, 4, 6, 7 ], [ 4, 8, 9, 10 ], 
      [ 2, 3, 6, 9 ], [ 1, 2, 4, 8 ], [ 2, 4, 6, 10 ], [ 2, 4, 7, 8 ], 
      [ 1, 8, 9, 10 ], [ 1, 4, 6, 9 ], [ 3, 5, 9, 10 ], [ 1, 3, 4, 10 ], 
      [ 2, 5, 8, 9 ], [ 2, 4, 5, 6 ], [ 1, 2, 6, 10 ], [ 2, 4, 7, 10 ], 
      [ 1, 4, 5, 7 ], [ 2, 4, 5, 7 ], [ 6, 8, 9, 10 ], [ 1, 3, 4, 8 ], 
      [ 1, 5, 6, 9 ], [ 1, 2, 4, 9 ], [ 1, 2, 4, 6 ], [ 3, 4, 6, 8 ], 
      [ 1, 3, 5, 6 ], [ 1, 3, 9, 10 ], [ 3, 5, 7, 8 ], [ 1, 3, 4, 7 ], 
      [ 3, 7, 8, 10 ], [ 2, 6, 8, 9 ], [ 4, 7, 8, 9 ], [ 4, 5, 6, 10 ], 
      [ 1, 2, 6, 7 ], [ 7, 8, 9, 10 ], [ 1, 3, 7, 8 ], [ 2, 5, 6, 10 ], 
      [ 3, 4, 6, 9 ], [ 1, 4, 9, 10 ], [ 2, 3, 8, 9 ], [ 3, 4, 7, 8 ], 
      [ 1, 3, 5, 7 ], [ 2, 5, 6, 9 ], [ 2, 3, 4, 6 ], [ 1, 4, 8, 10 ], 
      [ 3, 6, 8, 9 ], [ 3, 4, 8, 9 ], [ 1, 5, 6, 10 ], [ 2, 3, 9, 10 ], 
      [ 1, 4, 8, 9 ], [ 4, 7, 8, 10 ], [ 4, 5, 8, 10 ], [ 1, 7, 8, 10 ], 
      [ 3, 6, 7, 8 ], [ 2, 5, 9, 10 ], [ 1, 4, 7, 10 ], [ 2, 4, 5, 9 ], 
      [ 4, 5, 6, 8 ], [ 1, 7, 8, 9 ], [ 3, 5, 6, 8 ], [ 1, 3, 6, 10 ], 
      [ 1, 2, 6, 8 ], [ 2, 6, 9, 10 ], [ 2, 7, 9, 10 ], [ 4, 7, 9, 10 ], 
      [ 2, 4, 5, 10 ], [ 2, 3, 5, 10 ], [ 1, 3, 7, 10 ], [ 2, 5, 6, 8 ], 
      [ 1, 6, 7, 10 ], [ 2, 3, 4, 9 ], [ 1, 3, 5, 10 ], [ 1, 2, 9, 10 ], 
      [ 2, 3, 5, 7 ], [ 1, 4, 6, 7 ], [ 4, 5, 6, 9 ], [ 1, 4, 7, 9 ], 
      [ 1, 4, 5, 6 ], [ 1, 7, 9, 10 ], [ 2, 4, 9, 10 ], [ 6, 7, 9, 10 ], 
      [ 1, 4, 7, 8 ], [ 2, 3, 4, 10 ], [ 1, 2, 5, 8 ], [ 1, 2, 3, 5 ], 
      [ 2, 4, 8, 9 ], [ 1, 2, 4, 10 ], [ 2, 3, 5, 9 ], [ 4, 6, 8, 10 ], 
      [ 2, 6, 7, 10 ], [ 4, 6, 7, 8 ], [ 3, 4, 5, 6 ], [ 1, 3, 7, 9 ], 
      [ 1, 2, 7, 8 ], [ 2, 3, 4, 7 ], [ 1, 2, 5, 6 ], [ 3, 4, 8, 10 ], 
      [ 2, 4, 8, 10 ], [ 2, 6, 7, 8 ], [ 3, 4, 5, 7 ], [ 1, 4, 5, 10 ], 
      [ 4, 5, 9, 10 ], [ 1, 6, 7, 9 ], [ 3, 4, 9, 10 ], [ 1, 2, 5, 10 ], 
      [ 3, 4, 7, 10 ], [ 1, 4, 5, 8 ], [ 5, 6, 9, 10 ], [ 1, 2, 7, 9 ], 
      [ 2, 3, 5, 8 ], [ 2, 3, 7, 8 ], [ 1, 3, 4, 6 ], [ 1, 3, 5, 9 ], 
      [ 3, 7, 9, 10 ], [ 4, 6, 7, 9 ], [ 3, 4, 5, 10 ], [ 1, 4, 5, 9 ], 
      [ 2, 4, 7, 9 ], [ 2, 5, 7, 8 ], [ 3, 4, 6, 10 ], [ 1, 5, 6, 8 ], 
      [ 3, 4, 5, 9 ], [ 1, 2, 4, 7 ], [ 5, 6, 8, 9 ], [ 1, 5, 7, 8 ], 
      [ 1, 2, 3, 9 ], [ 1, 3, 8, 9 ], [ 1, 2, 3, 8 ], [ 1, 3, 6, 9 ], 
      [ 1, 2, 5, 7 ], [ 1, 2, 3, 7 ], [ 1, 3, 4, 9 ], [ 1, 5, 9, 10 ], 
      [ 5, 6, 8, 10 ], [ 2, 3, 6, 10 ], [ 1, 2, 7, 10 ], [ 1, 3, 5, 8 ], 
      [ 1, 3, 8, 10 ], [ 2, 6, 8, 10 ], [ 2, 8, 9, 10 ], [ 2, 5, 6, 7 ], 
      [ 1, 2, 8, 10 ], [ 2, 3, 6, 7 ], [ 3, 4, 7, 9 ], [ 5, 6, 7, 8 ], 
      [ 1, 5, 8, 10 ], [ 2, 5, 8, 10 ], [ 4, 5, 6, 7 ], [ 3, 5, 6, 7 ], 
      [ 3, 5, 6, 9 ], [ 4, 5, 8, 9 ] ] ]
gap> gens:=[ Transformation( [ 1, 5, 2, 2, 3, 5, 2 ] ), 
>  Transformation( [ 7, 3, 6, 5, 2, 4, 1 ] ), 
>  Transformation( [ 7, 5, 3, 2, 5, 5, 6 ] ) ];;
gap> m:=Monoid(gens);;
gap> Enumerate(ImagesOfTransSemigroup(m));;
gap> Set(ImagesOfTransSemigroup(m));
[ [ 1, 2 ], [ 1, 2, 3 ], [ 1, 2, 3, 4, 5 ], [ 1 .. 7 ], [ 1, 2, 3, 4, 6 ], 
  [ 1, 2, 3, 5 ], [ 1, 2, 3, 5, 6 ], [ 1, 2, 3, 6 ], [ 1, 2, 4 ], 
  [ 1, 2, 4, 5 ], [ 1, 2, 4, 5, 6 ], [ 1, 2, 5 ], [ 1, 2, 6 ], [ 1, 3 ], 
  [ 1, 3, 4 ], [ 1, 3, 4, 5, 6 ], [ 1, 3, 4, 6 ], [ 1, 3, 5 ], [ 1, 3, 6 ], 
  [ 1, 4 ], [ 1, 4, 5 ], [ 1, 4, 5, 6 ], [ 1, 4, 6 ], [ 1, 5 ], [ 1, 5, 6 ], 
  [ 1, 6 ], [ 2 ], [ 2, 3 ], [ 2, 3, 4 ], [ 2, 3, 4, 5 ], [ 2, 3, 4, 5, 7 ], 
  [ 2, 3, 4, 6 ], [ 2, 3, 4, 6, 7 ], [ 2, 3, 5 ], [ 2, 3, 5, 6 ], 
  [ 2, 3, 5, 6, 7 ], [ 2, 3, 5, 7 ], [ 2, 3, 6 ], [ 2, 3, 6, 7 ], 
  [ 2, 3, 7 ], [ 2, 4 ], [ 2, 4, 5 ], [ 2, 4, 5, 6 ], [ 2, 4, 5, 6, 7 ], 
  [ 2, 4, 5, 7 ], [ 2, 4, 6 ], [ 2, 4, 7 ], [ 2, 5 ], [ 2, 5, 6 ], 
  [ 2, 5, 7 ], [ 2, 6 ], [ 2, 6, 7 ], [ 2, 7 ], [ 3 ], [ 3, 4 ], [ 3, 4, 5 ], 
  [ 3, 4, 5, 6 ], [ 3, 4, 5, 6, 7 ], [ 3, 4, 6 ], [ 3, 4, 6, 7 ], 
  [ 3, 4, 7 ], [ 3, 5 ], [ 3, 5, 6 ], [ 3, 5, 7 ], [ 3, 6 ], [ 3, 6, 7 ], 
  [ 3, 7 ], [ 4 ], [ 4, 5 ], [ 4, 5, 6 ], [ 4, 5, 6, 7 ], [ 4, 5, 7 ], 
  [ 4, 6 ], [ 4, 6, 7 ], [ 4, 7 ], [ 5 ], [ 5, 6 ], [ 5, 6, 7 ], [ 5, 7 ], 
  [ 6 ], [ 6, 7 ] ]
gap> Enumerate(KernelsOfTransSemigroup(m));;
gap> Set(KernelsOfTransSemigroup(m));
[ [ 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 2 ], [ 1, 1, 1, 1, 1, 2, 1 ], 
  [ 1, 1, 1, 1, 1, 2, 2 ], [ 1, 1, 1, 1, 1, 2, 3 ], [ 1, 1, 1, 1, 2, 1, 1 ], 
  [ 1, 1, 1, 1, 2, 1, 2 ], [ 1, 1, 1, 1, 2, 1, 3 ], [ 1, 1, 1, 1, 2, 2, 1 ], 
  [ 1, 1, 1, 1, 2, 2, 2 ], [ 1, 1, 1, 1, 2, 2, 3 ], [ 1, 1, 1, 1, 2, 3, 1 ], 
  [ 1, 1, 1, 1, 2, 3, 2 ], [ 1, 1, 1, 1, 2, 3, 3 ], [ 1, 1, 1, 1, 2, 3, 4 ], 
  [ 1, 1, 1, 2, 1, 1, 1 ], [ 1, 1, 1, 2, 1, 1, 2 ], [ 1, 1, 1, 2, 1, 1, 3 ], 
  [ 1, 1, 2, 1, 1, 1, 1 ], [ 1, 1, 2, 1, 1, 1, 2 ], [ 1, 1, 2, 1, 1, 1, 3 ], 
  [ 1, 1, 2, 1, 2, 1, 1 ], [ 1, 1, 2, 1, 2, 1, 2 ], [ 1, 1, 2, 1, 2, 1, 3 ], 
  [ 1, 1, 2, 1, 2, 2, 1 ], [ 1, 1, 2, 1, 2, 2, 2 ], [ 1, 1, 2, 1, 2, 2, 3 ], 
  [ 1, 1, 2, 1, 2, 3, 2 ], [ 1, 1, 2, 1, 3, 1, 1 ], [ 1, 1, 2, 1, 3, 1, 2 ], 
  [ 1, 1, 2, 1, 3, 1, 3 ], [ 1, 1, 2, 1, 3, 1, 4 ], [ 1, 1, 2, 1, 3, 3, 1 ], 
  [ 1, 1, 2, 1, 3, 3, 2 ], [ 1, 1, 2, 1, 3, 3, 3 ], [ 1, 1, 2, 1, 3, 3, 4 ], 
  [ 1, 1, 2, 2, 1, 1, 1 ], [ 1, 1, 2, 2, 1, 1, 2 ], [ 1, 1, 2, 2, 1, 1, 3 ], 
  [ 1, 1, 2, 2, 2, 1, 1 ], [ 1, 1, 2, 2, 2, 1, 2 ], [ 1, 1, 2, 2, 2, 1, 3 ], 
  [ 1, 1, 2, 2, 2, 2, 1 ], [ 1, 1, 2, 2, 2, 2, 2 ], [ 1, 1, 2, 2, 2, 2, 3 ], 
  [ 1, 1, 2, 2, 2, 3, 2 ], [ 1, 1, 2, 2, 2, 3, 3 ], [ 1, 1, 2, 2, 3, 1, 2 ], 
  [ 1, 1, 2, 2, 3, 3, 3 ], [ 1, 1, 2, 3, 1, 1, 1 ], [ 1, 1, 2, 3, 1, 1, 2 ], 
  [ 1, 1, 2, 3, 1, 1, 3 ], [ 1, 1, 2, 3, 1, 1, 4 ], [ 1, 1, 2, 3, 2, 1, 1 ], 
  [ 1, 1, 2, 3, 2, 1, 2 ], [ 1, 1, 2, 3, 2, 1, 3 ], [ 1, 1, 2, 3, 2, 1, 4 ], 
  [ 1, 1, 2, 3, 2, 2, 1 ], [ 1, 1, 2, 3, 2, 2, 2 ], [ 1, 1, 2, 3, 2, 2, 3 ], 
  [ 1, 1, 2, 3, 2, 2, 4 ], [ 1, 2, 1, 1, 1, 1, 1 ], [ 1, 2, 1, 1, 1, 1, 2 ], 
  [ 1, 2, 1, 1, 1, 1, 3 ], [ 1, 2, 1, 1, 1, 2, 1 ], [ 1, 2, 1, 1, 1, 2, 2 ], 
  [ 1, 2, 1, 1, 1, 2, 3 ], [ 1, 2, 1, 1, 1, 3, 1 ], [ 1, 2, 1, 1, 1, 3, 2 ], 
  [ 1, 2, 1, 1, 1, 3, 3 ], [ 1, 2, 1, 1, 1, 3, 4 ], [ 1, 2, 1, 1, 2, 2, 1 ], 
  [ 1, 2, 1, 1, 2, 2, 2 ], [ 1, 2, 1, 1, 2, 2, 3 ], [ 1, 2, 1, 1, 3, 2, 1 ], 
  [ 1, 2, 1, 1, 3, 2, 2 ], [ 1, 2, 1, 1, 3, 2, 3 ], [ 1, 2, 1, 1, 3, 2, 4 ], 
  [ 1, 2, 1, 1, 3, 3, 3 ], [ 1, 2, 1, 2, 1, 1, 1 ], [ 1, 2, 1, 2, 1, 1, 2 ], 
  [ 1, 2, 1, 2, 1, 1, 3 ], [ 1, 2, 1, 2, 1, 2, 1 ], [ 1, 2, 1, 2, 1, 2, 2 ], 
  [ 1, 2, 1, 2, 1, 2, 3 ], [ 1, 2, 1, 2, 1, 3, 1 ], [ 1, 2, 1, 2, 1, 3, 2 ], 
  [ 1, 2, 1, 2, 1, 3, 3 ], [ 1, 2, 1, 2, 1, 3, 4 ], [ 1, 2, 1, 2, 2, 2, 1 ], 
  [ 1, 2, 1, 2, 2, 2, 2 ], [ 1, 2, 1, 2, 2, 2, 3 ], [ 1, 2, 1, 2, 3, 2, 1 ], 
  [ 1, 2, 1, 2, 3, 2, 2 ], [ 1, 2, 1, 2, 3, 2, 3 ], [ 1, 2, 1, 2, 3, 2, 4 ], 
  [ 1, 2, 1, 2, 3, 3, 2 ], [ 1, 2, 1, 3, 1, 1, 1 ], [ 1, 2, 1, 3, 1, 1, 2 ], 
  [ 1, 2, 1, 3, 1, 1, 3 ], [ 1, 2, 1, 3, 1, 1, 4 ], [ 1, 2, 1, 3, 1, 2, 2 ], 
  [ 1, 2, 1, 3, 2, 2, 2 ], [ 1, 2, 1, 3, 2, 2, 3 ], [ 1, 2, 2, 1, 2, 2, 1 ], 
  [ 1, 2, 2, 1, 2, 2, 2 ], [ 1, 2, 2, 1, 2, 2, 3 ], [ 1, 2, 2, 2, 1, 1, 1 ], 
  [ 1, 2, 2, 2, 1, 1, 2 ], [ 1, 2, 2, 2, 1, 1, 3 ], [ 1, 2, 2, 2, 1, 2, 1 ], 
  [ 1, 2, 2, 2, 1, 2, 2 ], [ 1, 2, 2, 2, 1, 2, 3 ], [ 1, 2, 2, 2, 1, 3, 1 ], 
  [ 1, 2, 2, 2, 1, 3, 2 ], [ 1, 2, 2, 2, 1, 3, 3 ], [ 1, 2, 2, 2, 1, 3, 4 ], 
  [ 1, 2, 2, 2, 2, 1, 1 ], [ 1, 2, 2, 2, 2, 1, 2 ], [ 1, 2, 2, 2, 2, 1, 3 ], 
  [ 1, 2, 2, 2, 2, 2, 1 ], [ 1, 2, 2, 2, 2, 2, 2 ], [ 1, 2, 2, 2, 2, 2, 3 ], 
  [ 1, 2, 2, 2, 2, 3, 1 ], [ 1, 2, 2, 2, 2, 3, 2 ], [ 1, 2, 2, 2, 2, 3, 3 ], 
  [ 1, 2, 2, 2, 2, 3, 4 ], [ 1, 2, 2, 2, 3, 1, 2 ], [ 1, 2, 2, 2, 3, 1, 3 ], 
  [ 1, 2, 2, 2, 3, 2, 1 ], [ 1, 2, 2, 2, 3, 2, 2 ], [ 1, 2, 2, 2, 3, 2, 3 ], 
  [ 1, 2, 2, 2, 3, 2, 4 ], [ 1, 2, 2, 2, 3, 3, 1 ], [ 1, 2, 2, 2, 3, 3, 2 ], 
  [ 1, 2, 2, 2, 3, 3, 3 ], [ 1, 2, 2, 2, 3, 3, 4 ], [ 1, 2, 2, 2, 3, 4, 2 ], 
  [ 1, 2, 2, 2, 3, 4, 3 ], [ 1, 2, 2, 2, 3, 4, 5 ], [ 1, 2, 2, 3, 2, 2, 1 ], 
  [ 1, 2, 2, 3, 2, 2, 2 ], [ 1, 2, 2, 3, 2, 2, 3 ], [ 1, 2, 2, 3, 2, 2, 4 ], 
  [ 1, 2, 3, 1, 2, 2, 1 ], [ 1, 2, 3, 1, 2, 2, 2 ], [ 1, 2, 3, 1, 2, 2, 3 ], 
  [ 1, 2, 3, 1, 2, 2, 4 ], [ 1, 2, 3, 1, 3, 2, 2 ], [ 1, 2, 3, 1, 3, 3, 2 ], 
  [ 1, 2, 3, 1, 3, 3, 3 ], [ 1, 2, 3, 2, 1, 1, 2 ], [ 1, 2, 3, 2, 1, 2, 2 ], 
  [ 1, 2, 3, 2, 1, 2, 3 ], [ 1, 2, 3, 2, 2, 2, 1 ], [ 1, 2, 3, 2, 2, 2, 2 ], 
  [ 1, 2, 3, 2, 2, 2, 3 ], [ 1, 2, 3, 2, 2, 2, 4 ], [ 1, 2, 3, 2, 3, 1, 3 ], 
  [ 1, 2, 3, 2, 3, 2, 1 ], [ 1, 2, 3, 2, 3, 2, 2 ], [ 1, 2, 3, 2, 3, 2, 3 ], 
  [ 1, 2, 3, 2, 3, 2, 4 ], [ 1, 2, 3, 2, 3, 3, 1 ], [ 1, 2, 3, 2, 3, 3, 2 ], 
  [ 1, 2, 3, 2, 3, 3, 3 ], [ 1, 2, 3, 2, 3, 3, 4 ], [ 1, 2, 3, 2, 3, 4, 3 ], 
  [ 1, 2, 3, 2, 4, 2, 2 ], [ 1, 2, 3, 2, 4, 2, 3 ], [ 1, 2, 3, 2, 4, 2, 5 ], 
  [ 1, 2, 3, 2, 4, 4, 2 ], [ 1, 2, 3, 3, 1, 1, 1 ], [ 1, 2, 3, 3, 1, 1, 2 ], 
  [ 1, 2, 3, 3, 1, 1, 3 ], [ 1, 2, 3, 3, 1, 1, 4 ], [ 1, 2, 3, 3, 1, 2, 3 ], 
  [ 1, 2, 3, 3, 2, 2, 1 ], [ 1, 2, 3, 3, 2, 2, 2 ], [ 1, 2, 3, 3, 2, 2, 3 ], 
  [ 1, 2, 3, 3, 2, 2, 4 ], [ 1, 2, 3, 3, 3, 1, 1 ], [ 1, 2, 3, 3, 3, 1, 2 ], 
  [ 1, 2, 3, 3, 3, 1, 3 ], [ 1, 2, 3, 3, 3, 1, 4 ], [ 1, 2, 3, 3, 3, 2, 1 ], 
  [ 1, 2, 3, 3, 3, 2, 2 ], [ 1, 2, 3, 3, 3, 2, 3 ], [ 1, 2, 3, 3, 3, 2, 4 ], 
  [ 1, 2, 3, 3, 3, 3, 1 ], [ 1, 2, 3, 3, 3, 3, 2 ], [ 1, 2, 3, 3, 3, 3, 3 ], 
  [ 1, 2, 3, 3, 3, 3, 4 ], [ 1, 2, 3, 3, 3, 4, 3 ], [ 1, 2, 3, 3, 3, 4, 4 ], 
  [ 1, 2, 3, 3, 3, 4, 5 ], [ 1, 2, 3, 3, 4, 2, 3 ], [ 1, 2, 3, 3, 4, 4, 4 ], 
  [ 1, 2, 3, 4, 2, 2, 2 ], [ 1, 2, 3, 4, 2, 2, 4 ], [ 1, 2, 3, 4, 2, 2, 5 ], 
  [ 1, 2, 3, 4, 3, 2, 2 ], [ 1, 2, 3, 4, 3, 3, 2 ], [ 1, 2, 3, 4, 3, 3, 3 ], 
  [ 1, 2, 3, 4, 3, 3, 5 ], [ 1 .. 7 ] ]
gap> Length(last);
206
gap> gens:=[ Transformation( [ 4, 5, 7, 1, 8, 6, 1, 7 ] ), 
>  Transformation( [ 5, 5, 3, 8, 3, 7, 4, 6 ] ), 
>  Transformation( [ 5, 7, 4, 4, 1, 4, 4, 4 ] ), 
>  Transformation( [ 7, 1, 4, 3, 6, 1, 3, 7 ] ) ];;
gap> m:=Semigroup(gens);;
gap> Enumerate(ImagesOfTransSemigroup(m));;
gap> Set(ImagesOfTransSemigroup(m));
[ [ 1 ], [ 1 .. 8 ], [ 1, 3 ], [ 1, 3, 4 ], [ 1, 3, 4, 6, 7 ], 
  [ 1, 3, 4, 7 ], [ 1, 3, 6 ], [ 1, 3, 6, 7 ], [ 1, 3, 7 ], [ 1, 4 ], 
  [ 1, 4, 5 ], [ 1, 4, 5, 6, 7, 8 ], [ 1, 4, 5, 7 ], [ 1, 4, 6 ], 
  [ 1, 4, 6, 7 ], [ 1, 4, 6, 7, 8 ], [ 1, 4, 7 ], [ 1, 4, 8 ], [ 1, 6 ], 
  [ 1, 6, 7 ], [ 1, 6, 7, 8 ], [ 1, 6, 8 ], [ 1, 7 ], [ 1, 7, 8 ], [ 1, 8 ], 
  [ 3 ], [ 3, 4 ], [ 3, 4, 5 ], [ 3, 4, 5, 6, 7, 8 ], [ 3, 4, 5, 7 ], 
  [ 3, 4, 5, 7, 8 ], [ 3, 4, 5, 8 ], [ 3, 4, 6 ], [ 3, 4, 6, 7 ], 
  [ 3, 4, 6, 7, 8 ], [ 3, 4, 6, 8 ], [ 3, 4, 7 ], [ 3, 4, 7, 8 ], 
  [ 3, 4, 8 ], [ 3, 5 ], [ 3, 5, 7 ], [ 3, 5, 8 ], [ 3, 6 ], [ 3, 6, 7 ], 
  [ 3, 6, 7, 8 ], [ 3, 6, 8 ], [ 3, 7 ], [ 3, 7, 8 ], [ 3, 8 ], [ 4 ], 
  [ 4, 5 ], [ 4, 5, 6 ], [ 4, 5, 6, 7 ], [ 4, 5, 6, 7, 8 ], [ 4, 5, 7 ], 
  [ 4, 5, 7, 8 ], [ 4, 5, 8 ], [ 4, 6 ], [ 4, 6, 7 ], [ 4, 6, 8 ], [ 4, 7 ], 
  [ 4, 7, 8 ], [ 4, 8 ], [ 5 ], [ 5, 6 ], [ 5, 6, 7 ], [ 5, 6, 8 ], [ 5, 7 ], 
  [ 5, 7, 8 ], [ 5, 8 ], [ 6 ], [ 6, 7 ], [ 6, 7, 8 ], [ 6, 8 ], [ 7 ], 
  [ 7, 8 ], [ 8 ] ]

#
gap> SetInfoLevel(InfoWarning, InfoLevelInfoWarning);;
gap> SetInfoLevel(InfoCitrus, InfoLevelInfoCitrus);;
gap> Unbind(InfoLevelInfoCitrus);; Unbind(InfoLevelInfoWarning);;

#
gap> STOP_TEST( "Citrus package: orbits.tst", 10000);
